/*
 * Decompiled with CFR 0.152.
 */
package net.caladesiframework.elastic.provider;

import java.util.Map;
import net.caladesiframework.elastic.provider.ElasticProvider$;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\t]b\u0001B\u0001\u0003\u0001.\u0011q\"\u00127bgRL7\r\u0015:pm&$WM\u001d\u0006\u0003\u0007\u0011\t\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0003\u000b\u0019\tq!\u001a7bgRL7M\u0003\u0002\b\u0011\u0005\t2-\u00197bI\u0016\u001c\u0018N\u001a:b[\u0016<xN]6\u000b\u0003%\t1A\\3u\u0007\u0001\u0019B\u0001\u0001\u0007\u0013+A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"!D\n\n\u0005Qq!a\u0002)s_\u0012,8\r\u001e\t\u0003\u001bYI!a\u0006\b\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011e\u0001!Q3A\u0005\u0002i\t\u0001B\\8eK:\u000bW.Z\u000b\u00027A\u0011Ad\b\b\u0003\u001buI!A\b\b\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0013E\u0001\u0004TiJLgn\u001a\u0006\u0003=9A\u0001b\t\u0001\u0003\u0012\u0003\u0006IaG\u0001\n]>$WMT1nK\u0002B\u0001\"\n\u0001\u0003\u0016\u0004%\tAG\u0001\u0005a\u0006$\b\u000e\u0003\u0005(\u0001\tE\t\u0015!\u0003\u001c\u0003\u0015\u0001\u0018\r\u001e5!\u0011!I\u0003A!f\u0001\n\u0003Q\u0013\u0001E;tK\"#H\u000f]\"p]:,7\r^8s+\u0005Y\u0003CA\u0007-\u0013\ticBA\u0004C_>dW-\u00198\t\u0011=\u0002!\u0011#Q\u0001\n-\n\u0011#^:f\u0011R$\boQ8o]\u0016\u001cGo\u001c:!\u0011\u0015\t\u0004\u0001\"\u00013\u0003\u0019a\u0014N\\5u}Q!1'\u000e\u001c8!\t!\u0004!D\u0001\u0003\u0011\u0015I\u0002\u00071\u0001\u001c\u0011\u0015)\u0003\u00071\u0001\u001c\u0011\u001dI\u0003\u0007%AA\u0002-B\u0001\"\u000f\u0001\t\u0006\u0004%IAO\u0001\u0005]>$W-F\u0001<!\ta$)D\u0001>\u0015\tIdH\u0003\u0002@\u0001\u0006iQ\r\\1ti&\u001c7/Z1sG\"T\u0011!Q\u0001\u0004_J<\u0017BA\">\u0005\u0011qu\u000eZ3\t\u0011\u0015\u0003\u0001\u0012!Q!\nm\nQA\\8eK\u0002B\u0001b\u0012\u0001\t\u0006\u0004%I\u0001S\u0001\u0007G2LWM\u001c;\u0016\u0003%\u0003\"A\u0013'\u000e\u0003-S!a\u0012 \n\u00055[%AB\"mS\u0016tG\u000f\u0003\u0005P\u0001!\u0005\t\u0015)\u0003J\u0003\u001d\u0019G.[3oi\u0002BQ!\u0015\u0001\u0005\u0002I\u000bqa\u001d;beR,\u0006\u000fF\u0001<\u0011\u0015!\u0006\u0001\"\u0001V\u0003!\u0019\b.\u001e;e_^tW#\u0001,\u0011\u000559\u0016B\u0001-\u000f\u0005\u0011)f.\u001b;\t\u000bi\u0003A\u0011A.\u0002\u0017\u0015t7/\u001e:f\u0013:$W\r\u001f\u000b\u00049~\u000b\u0007CA\u0007^\u0013\tqfBA\u0002B]fDQ\u0001Y-A\u0002m\t\u0011\"\u001b8eKbt\u0015-\\3\t\u000b\tL\u0006\u0019A\u000e\u0002\u0011%$X-\u001c+za\u0016DQ\u0001\u001a\u0001\u0005\u0002\u0015\f1\u0002Z3mKR,\u0017J\u001c3fqR\u0011AL\u001a\u0005\u0006A\u000e\u0004\ra\u0007\u0005\u0006Q\u0002!\t![\u0001\bC\u0012$\u0017\n^3n)\u0015Qgo\u001e={!\tYG/D\u0001m\u0015\tig.A\u0004sK\u001a\u0014Xm\u001d5\u000b\u0005=\u0004\u0018aB5oI&\u001cWm\u001d\u0006\u0003cJ\fQ!\u00193nS:T!a\u001d \u0002\r\u0005\u001cG/[8o\u0013\t)HNA\bSK\u001a\u0014Xm\u001d5SKN\u0004xN\\:f\u0011\u0015\u0001w\r1\u0001\u001c\u0011\u0015\u0011w\r1\u0001\u001c\u0011\u0015Ix\r1\u0001\u001c\u0003\tIG\rC\u0003|O\u0002\u0007A0\u0001\u0005eEZ\u000bG.^3t!\ri\u0018QA\u0007\u0002}*\u0019q0!\u0001\u0002\u0011a\u001cwN\u001c;f]RT1!a\u0001?\u0003\u0019\u0019w.\\7p]&\u0019\u0011q\u0001@\u0003\u001fa\u001buN\u001c;f]R\u0014U/\u001b7eKJDq!a\u0003\u0001\t\u0003\ti!A\u0006hKRLE/Z7Cs&#G\u0003CA\b\u00037\ti\"a\b\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006s\u0003\r9W\r^\u0005\u0005\u00033\t\u0019BA\u0006HKR\u0014Vm\u001d9p]N,\u0007B\u00021\u0002\n\u0001\u00071\u0004\u0003\u0004c\u0003\u0013\u0001\ra\u0007\u0005\u0007s\u0006%\u0001\u0019A\u000e\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&\u0005Q!/Z7pm\u0016LE/Z7\u0015\u000f)\f9#!\u000b\u0002,!1\u0001-!\tA\u0002mAaAYA\u0011\u0001\u0004Y\u0002BB=\u0002\"\u0001\u00071\u0004C\u0004\u00020\u0001!\t!!\r\u0002#\u0015DXmY;uK\u001a+(P_=Rk\u0016\u0014\u0018\u0010\u0006\u0006\u00024\u0005}\u00121IA$\u0003\u0013\u0002B!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0004\u0003s\u0011\u0018AB:fCJ\u001c\u0007.\u0003\u0003\u0002>\u0005]\"AD*fCJ\u001c\u0007NU3ta>t7/\u001a\u0005\b\u0003\u0003\ni\u00031\u0001\u001c\u0003%1\u0017.\u001a7e\u001d\u0006lW\rC\u0004\u0002F\u00055\u0002\u0019A\u000e\u0002\u0013E,XM]=UKJl\u0007B\u00021\u0002.\u0001\u00071\u0004\u0003\u0004c\u0003[\u0001\ra\u0007\u0005\b\u0003\u001b\u0002A\u0011AA(\u0003!\u0019w.\u001e8u\u00032dGCBA)\u0003/\nI\u0006E\u0002\u000e\u0003'J1!!\u0016\u000f\u0005\u0011auN\\4\t\r\u0001\fY\u00051\u0001\u001c\u0011\u0019\u0011\u00171\na\u00017!I\u0011Q\f\u0001\u0002\u0002\u0013\u0005\u0011qL\u0001\u0005G>\u0004\u0018\u0010F\u00044\u0003C\n\u0019'!\u001a\t\u0011e\tY\u0006%AA\u0002mA\u0001\"JA.!\u0003\u0005\ra\u0007\u0005\tS\u0005m\u0003\u0013!a\u0001W!I\u0011\u0011\u000e\u0001\u0012\u0002\u0013\u0005\u00111N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiGK\u0002\u001c\u0003_Z#!!\u001d\u0011\t\u0005M\u0014QP\u0007\u0003\u0003kRA!a\u001e\u0002z\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003wr\u0011AC1o]>$\u0018\r^5p]&!\u0011qPA;\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003\u0007\u0003\u0011\u0013!C\u0001\u0003W\nabY8qs\u0012\"WMZ1vYR$#\u0007C\u0005\u0002\b\u0002\t\n\u0011\"\u0001\u0002\n\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAAFU\rY\u0013q\u000e\u0005\n\u0003\u001f\u0003\u0011\u0011!C!\u0003#\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAJ!\u0011\t)*a(\u000e\u0005\u0005]%\u0002BAM\u00037\u000bA\u0001\\1oO*\u0011\u0011QT\u0001\u0005U\u00064\u0018-C\u0002!\u0003/C\u0011\"a)\u0001\u0003\u0003%\t!!*\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u001d\u0006cA\u0007\u0002*&\u0019\u00111\u0016\b\u0003\u0007%sG\u000fC\u0005\u00020\u0002\t\t\u0011\"\u0001\u00022\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u0001/\u00024\"Q\u0011QWAW\u0003\u0003\u0005\r!a*\u0002\u0007a$\u0013\u0007C\u0005\u0002:\u0002\t\t\u0011\"\u0011\u0002<\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002>B)\u0011qXAc96\u0011\u0011\u0011\u0019\u0006\u0004\u0003\u0007t\u0011AC2pY2,7\r^5p]&!\u0011qYAa\u0005!IE/\u001a:bi>\u0014\b\"CAf\u0001\u0005\u0005I\u0011AAg\u0003!\u0019\u0017M\\#rk\u0006dGcA\u0016\u0002P\"I\u0011QWAe\u0003\u0003\u0005\r\u0001\u0018\u0005\n\u0003'\u0004\u0011\u0011!C!\u0003+\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003OC\u0011\"!7\u0001\u0003\u0003%\t%a7\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a%\t\u0013\u0005}\u0007!!A\u0005B\u0005\u0005\u0018AB3rk\u0006d7\u000fF\u0002,\u0003GD\u0011\"!.\u0002^\u0006\u0005\t\u0019\u0001/\b\u0013\u0005\u001d(!!A\t\u0002\u0005%\u0018aD#mCN$\u0018n\u0019)s_ZLG-\u001a:\u0011\u0007Q\nYO\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AAw'\u0015\tY/a<\u0016!!\t\t0a>\u001c7-\u001aTBAAz\u0015\r\t)PD\u0001\beVtG/[7f\u0013\u0011\tI0a=\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007C\u00042\u0003W$\t!!@\u0015\u0005\u0005%\bBCAm\u0003W\f\t\u0011\"\u0012\u0002\\\"Q!1AAv\u0003\u0003%\tI!\u0002\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fM\u00129A!\u0003\u0003\f!1\u0011D!\u0001A\u0002mAa!\nB\u0001\u0001\u0004Y\u0002\u0002C\u0015\u0003\u0002A\u0005\t\u0019A\u0016\t\u0015\t=\u00111^A\u0001\n\u0003\u0013\t\"A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tM!q\u0004\t\u0006\u001b\tU!\u0011D\u0005\u0004\u0005/q!AB(qi&|g\u000e\u0005\u0004\u000e\u00057Y2dK\u0005\u0004\u0005;q!A\u0002+va2,7\u0007C\u0004\u0003\"\t5\u0001\u0019A\u001a\u0002\u0007a$\u0003\u0007\u0003\u0006\u0003&\u0005-\u0018\u0013!C\u0001\u0003\u0013\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0004B\u0003B\u0015\u0003W\f\n\u0011\"\u0001\u0002\n\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3\u0007\u0003\u0006\u0003.\u0005-\u0018\u0011!C\u0005\u0005_\t1B]3bIJ+7o\u001c7wKR\u0011!\u0011\u0007\t\u0005\u0003+\u0013\u0019$\u0003\u0003\u00036\u0005]%AB(cU\u0016\u001cG\u000f")
public class ElasticProvider
implements Product,
Serializable {
    private final String nodeName;
    private final String path;
    private final boolean useHttpConnector;
    private Node node;
    private Client client;
    private volatile byte bitmap$0;

    public static boolean apply$default$3() {
        return ElasticProvider$.MODULE$.apply$default$3();
    }

    public static boolean $lessinit$greater$default$3() {
        return ElasticProvider$.MODULE$.$lessinit$greater$default$3();
    }

    public static Function1<Tuple3<String, String, Object>, ElasticProvider> tupled() {
        return ElasticProvider$.MODULE$.tupled();
    }

    public static Function1<String, Function1<String, Function1<Object, ElasticProvider>>> curried() {
        return ElasticProvider$.MODULE$.curried();
    }

    private Node node$lzycompute() {
        ElasticProvider elasticProvider = this;
        synchronized (elasticProvider) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.node = this.startUp();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.node;
        }
    }

    private Client client$lzycompute() {
        ElasticProvider elasticProvider = this;
        synchronized (elasticProvider) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.client = this.node().client();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.client;
        }
    }

    public String nodeName() {
        return this.nodeName;
    }

    public String path() {
        return this.path;
    }

    public boolean useHttpConnector() {
        return this.useHttpConnector;
    }

    private Node node() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.node$lzycompute() : this.node;
    }

    private Client client() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.client$lzycompute() : this.client;
    }

    public Node startUp() {
        ImmutableSettings.Builder settings = ImmutableSettings.settingsBuilder();
        settings.put("node.name", this.nodeName());
        settings.put("path.data", this.path());
        settings.put("http.enabled", this.useHttpConnector());
        return NodeBuilder.nodeBuilder().settings((Settings.Builder)settings).clusterName(this.nodeName()).data(true).local(true).node();
    }

    public void shutdown() {
        this.client().close();
        this.node().close();
    }

    public Object ensureIndex(String indexName, String itemType) {
        Object object;
        this.node().client().admin().cluster().prepareHealth(new String[0]).setWaitForYellowStatus().execute().actionGet();
        Map map = ((ClusterHealthResponse)this.client().admin().cluster().health(new ClusterHealthRequest(new String[]{indexName})).actionGet()).getIndices();
        if (map.containsKey(indexName)) {
            object = BoxedUnit.UNIT;
        } else {
            ImmutableSettings.Builder settings = ImmutableSettings.settingsBuilder();
            settings.put("_index", indexName);
            settings.put("_type", itemType);
            CreateIndexRequest request = Requests.createIndexRequest((String)indexName).settings((Settings.Builder)settings);
            object = this.client().admin().indices().create(request).actionGet();
        }
        return object;
    }

    public Object deleteIndex(String indexName) {
        Object object;
        this.node().client().admin().cluster().prepareHealth(new String[0]).setWaitForYellowStatus().execute().actionGet();
        Map map = ((ClusterHealthResponse)this.client().admin().cluster().health(new ClusterHealthRequest(new String[]{indexName})).actionGet()).getIndices();
        if (map.containsKey(indexName)) {
            DeleteIndexRequest request = Requests.deleteIndexRequest((String)indexName);
            object = this.client().admin().indices().delete(request).actionGet();
        } else {
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    public RefreshResponse addItem(String indexName, String itemType, String id, XContentBuilder dbValues) {
        long start = System.currentTimeMillis();
        this.client().prepareIndex(indexName, itemType, id).setSource(dbValues).execute().actionGet();
        long end = System.currentTimeMillis();
        return (RefreshResponse)this.client().admin().indices().prepareRefresh(new String[0]).execute().actionGet();
    }

    public GetResponse getItemById(String indexName, String itemType, String id) {
        GetResponse response = (GetResponse)this.client().prepareGet(indexName, itemType, id).execute().actionGet();
        return response;
    }

    public RefreshResponse removeItem(String indexName, String itemType, String id) {
        DeleteRequest request = Requests.deleteRequest((String)indexName).type(itemType).id(id);
        this.client().delete(request).actionGet();
        return (RefreshResponse)this.client().admin().indices().prepareRefresh(new String[0]).execute().actionGet();
    }

    public SearchResponse executeFuzzyQuery(String fieldName, String queryTerm, String indexName, String itemType) {
        SearchResponse response = (SearchResponse)this.client().prepareSearch(new String[]{indexName}).setTypes(new String[]{itemType}).setQuery((QueryBuilder)QueryBuilders.queryString((String)new StringOps(Predef$.MODULE$.augmentString("%s*")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{queryTerm}))).field(fieldName)).execute().actionGet();
        return response;
    }

    public long countAll(String indexName, String itemType) {
        CountResponse countResponse = (CountResponse)this.client().prepareCount(new String[]{indexName}).execute().actionGet();
        return countResponse.getCount();
    }

    public ElasticProvider copy(String nodeName, String path, boolean useHttpConnector) {
        return new ElasticProvider(nodeName, path, useHttpConnector);
    }

    public String copy$default$1() {
        return this.nodeName();
    }

    public String copy$default$2() {
        return this.path();
    }

    public boolean copy$default$3() {
        return this.useHttpConnector();
    }

    public String productPrefix() {
        return "ElasticProvider";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.useHttpConnector());
                break;
            }
            case 1: {
                object = this.path();
                break;
            }
            case 0: {
                object = this.nodeName();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ElasticProvider;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.nodeName()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
        n = Statics.mix((int)n, (int)(this.useHttpConnector() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)3);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ElasticProvider)) return false;
        boolean bl = true;
        if (!bl) return false;
        ElasticProvider elasticProvider = (ElasticProvider)x$1;
        String string = this.nodeName();
        String string2 = elasticProvider.nodeName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.path();
        String string4 = elasticProvider.path();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        if (this.useHttpConnector() != elasticProvider.useHttpConnector()) return false;
        if (!elasticProvider.canEqual(this)) return false;
        return true;
    }

    public ElasticProvider(String nodeName, String path, boolean useHttpConnector) {
        this.nodeName = nodeName;
        this.path = path;
        this.useHttpConnector = useHttpConnector;
        Product.class.$init$((Product)this);
    }
}

