/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import io.github.zlika.reproducible.JaxbObjectFactoryFixer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="strip-jaxb", defaultPhase=LifecyclePhase.PROCESS_SOURCES, threadSafe=true)
public final class StripJaxbMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(defaultValue="${project.build.directory}/generated-sources", property="reproducible.generatedDirectory", required=true)
    private File generatedDirectory;
    @Parameter(defaultValue="false", property="reproducible.skip")
    private boolean skip;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution of goal \"strip-jaxb\"");
        } else {
            this.fix();
        }
    }

    private void fix() throws MojoExecutionException {
        if (!this.generatedDirectory.exists() || !this.generatedDirectory.isDirectory()) {
            return;
        }
        Charset charset = Charset.forName(this.encoding);
        JaxbObjectFactoryFixer fixer = new JaxbObjectFactoryFixer(charset);
        File tmpFile = this.createTempFile();
        try {
            Files.walk(this.generatedDirectory.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(f -> "ObjectFactory.java".equals(f.toFile().getName())).forEach(f -> {
                this.getLog().info((CharSequence)("Stripping " + f.toFile().getAbsolutePath()));
                try {
                    fixer.strip(f.toFile(), tmpFile);
                    Files.move(tmpFile.toPath(), f, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)("Error when normalizing " + f.toFile().getAbsolutePath()), (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error when visiting " + this.generatedDirectory.getAbsolutePath(), (Exception)e);
        }
    }

    private File createTempFile() throws MojoExecutionException {
        try {
            File out = File.createTempFile("ObjectFactory", null);
            out.deleteOnExit();
            return out;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot create temp file", (Exception)e);
        }
    }
}

