/*
 * Decompiled with CFR 0.152.
 */
package net.bytepowered.flux.starter;

import net.bytepowered.flux.core.MetadataDecoder;
import net.bytepowered.flux.core.MetadataRegistry;
import net.bytepowered.flux.core.MetadataResolver;
import net.bytepowered.flux.impl.JsonDecoder;
import net.bytepowered.flux.impl.registry.ZookeeperMetadataRegistry;
import net.bytepowered.flux.impl.registry.ZookeeperRegistryConfig;
import net.bytepowered.flux.impl.resolver.MethodMetadataResolver;
import net.bytepowered.flux.starter.SpringBootstrap;
import net.bytepowered.flux.starter.SpringClientConfig;
import net.bytepowered.flux.starter.SpringRegistryConfig;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SpringConfiguration {
    @Bean
    SpringBootstrap bootstrap() {
        return new SpringBootstrap(this.clientConfig(), this.registry(), this.resolver());
    }

    @Bean
    MetadataDecoder decoder() {
        return new JsonDecoder();
    }

    @Bean
    MetadataResolver resolver() {
        return new MethodMetadataResolver();
    }

    @Bean
    MetadataRegistry registry() {
        return new ZookeeperMetadataRegistry(this.zookeeperConfig(), this.decoder());
    }

    @Bean
    ZookeeperRegistryConfig zookeeperConfig() {
        SpringRegistryConfig c = this.registryConfig();
        return new ZookeeperRegistryConfig(c.getSessionTimeoutMs(), c.getConnectionTimeoutMs(), c.getAddress());
    }

    @Bean
    SpringRegistryConfig registryConfig() {
        return new SpringRegistryConfig();
    }

    @Bean
    SpringClientConfig clientConfig() {
        return new SpringClientConfig();
    }
}

