/*
 * Decompiled with CFR 0.152.
 */
package net.bytepowered.flux.starter;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.bytepowered.flux.annotation.FxMapping;
import net.bytepowered.flux.core.MetadataRegistry;
import net.bytepowered.flux.core.MetadataResolver;
import net.bytepowered.flux.core.ServiceBeanMetadata;
import net.bytepowered.flux.starter.SpringClientConfig;
import org.apache.dubbo.config.spring.ServiceBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.util.StringUtils;

public class SpringBootstrap
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringBootstrap.class);
    private final SpringClientConfig config;
    private final MetadataRegistry registry;
    private final MetadataResolver resolver;

    public SpringBootstrap(SpringClientConfig config, MetadataRegistry registry, MetadataResolver resolver) {
        this.config = config;
        this.registry = registry;
        this.resolver = resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ApplicationReadyEvent event) {
        LOGGER.info("Flux client discovery start scanning...");
        Instant start = Instant.now();
        List<ServiceBeanMetadata> metadata = this.searchMappingBeans((ApplicationContext)event.getApplicationContext());
        try {
            this.registry.startup();
            this.registry.submit(metadata.stream().flatMap(m -> this.resolver.resolve(m).stream()).collect(Collectors.toList()));
        }
        catch (Exception e) {
            LOGGER.error("Flux client discovery error: ", (Throwable)e);
        }
        finally {
            this.registry.shutdown();
        }
        LOGGER.info("Flux client discovery scan COMPLETED: {}ms", (Object)Duration.between(start, Instant.now()));
    }

    private List<ServiceBeanMetadata> searchMappingBeans(ApplicationContext context) {
        List<String> packages = this.scanPackages();
        if (packages.isEmpty()) {
            return this.searchPackageBeans(null, context);
        }
        if (packages.size() == 1) {
            return this.searchPackageBeans(packages.get(0), context);
        }
        return ((Stream)packages.stream().parallel()).flatMap(pack -> this.searchPackageBeans((String)pack, context).stream()).collect(Collectors.toList());
    }

    private List<ServiceBeanMetadata> searchPackageBeans(String packageName, ApplicationContext context) {
        boolean filterPackage;
        boolean bl = filterPackage = !StringUtils.isEmpty((Object)packageName);
        if (filterPackage) {
            LOGGER.info("Flux filter package: {}", (Object)packageName);
        }
        String prefix = this.config.getPrefix();
        String applicationName = context.getApplicationName();
        Collection beans = context.getBeansOfType(ServiceBean.class).values();
        LOGGER.debug("Load dubbo service beans: {}", (Object)beans.size());
        return beans.stream().filter(sb -> {
            if (filterPackage) {
                return sb.getInterface().startsWith(packageName);
            }
            return true;
        }).peek(bean -> LOGGER.info("Found dubbo.bean: {}", bean)).map(bean -> ServiceBeanMetadata.builder().application(applicationName).prefix(prefix).group(bean.getGroup()).version(bean.getVersion()).interfaceName(bean.getInterface()).interfaceClass(bean.getInterfaceClass()).methods(Arrays.stream(bean.getInterfaceClass().getDeclaredMethods()).filter(m -> m.isAnnotationPresent(FxMapping.class)).collect(Collectors.toList())).build()).collect(Collectors.toList());
    }

    private List<String> scanPackages() {
        String basePackage = this.config.getBasePackage();
        if (basePackage == null || basePackage.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.stream(basePackage.split(",")).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }
}

