/*
 * Decompiled with CFR 0.152.
 */
package net.brdloush.dbstopwatch;

import com.p6spy.engine.common.PreparedStatementInformation;
import com.p6spy.engine.common.StatementInformation;
import com.p6spy.engine.event.JdbcEventListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class P6SpyStatsCollector
extends JdbcEventListener {
    private static final ThreadLocal<QueryStatsBuffer> threadLocalStats = ThreadLocal.withInitial(QueryStatsBuffer::new);

    public static void markBlockStart() {
        threadLocalStats.get().markBlockStart();
    }

    public static BlockStats getBlockStats() {
        return threadLocalStats.get().getBlockStats();
    }

    public static void reset() {
        threadLocalStats.get().reset();
    }

    public void onAfterExecuteQuery(PreparedStatementInformation preparedStatementInformation, long l, SQLException sQLException) {
        this.trackExecuteQuery((StatementInformation)preparedStatementInformation, l, preparedStatementInformation.getSql());
    }

    public void onAfterExecuteQuery(StatementInformation statementInformation, long l, String string, SQLException sQLException) {
        this.trackExecuteQuery(statementInformation, l, string);
    }

    private void trackExecuteQuery(StatementInformation statementInformation, long l, String string) {
        if (statementInformation != null && statementInformation.getSql() != null && !this.isSystemQuery(string)) {
            threadLocalStats.get().recordQuery(l / 1000000L, string);
        }
    }

    public void onAfterExecuteUpdate(StatementInformation statementInformation, long l, String string, int n, SQLException sQLException) {
        this.trackExecuteAndExecuteUpdate(statementInformation, l, string);
    }

    public void onAfterExecuteUpdate(PreparedStatementInformation preparedStatementInformation, long l, int n, SQLException sQLException) {
        this.trackExecuteAndExecuteUpdate((StatementInformation)preparedStatementInformation, l, preparedStatementInformation.getSql());
    }

    public void onAfterExecute(PreparedStatementInformation preparedStatementInformation, long l, SQLException sQLException) {
        this.trackExecuteAndExecuteUpdate((StatementInformation)preparedStatementInformation, l, preparedStatementInformation.getSql());
    }

    public void onAfterExecute(StatementInformation statementInformation, long l, String string, SQLException sQLException) {
        this.trackExecuteAndExecuteUpdate(statementInformation, l, statementInformation.getSql());
    }

    private void trackExecuteAndExecuteUpdate(StatementInformation statementInformation, long l, String string) {
        if (statementInformation != null && statementInformation.getSql() != null && !this.isSystemQuery(string)) {
            threadLocalStats.get().recordUpdate(l / 1000000L, string);
        }
    }

    public void onAfterExecuteBatch(StatementInformation statementInformation, long l, int[] nArray, SQLException sQLException) {
        String string;
        if (statementInformation != null && statementInformation.getSql() != null && !this.isSystemQuery(string = statementInformation.getSql())) {
            threadLocalStats.get().recordBatch(l / 1000000L, string);
        }
    }

    private boolean isSystemQuery(String string) {
        String string2 = string.trim().toLowerCase();
        return string2.startsWith("select 1") || string2.contains("information_schema") || string2.contains("sys.") || string2.startsWith("set ");
    }

    private static class QueryStatsBuffer {
        private final List<StatementExecution> queries = new ArrayList<StatementExecution>();
        private final List<StatementExecution> updates = new ArrayList<StatementExecution>();
        private final List<StatementExecution> batches = new ArrayList<StatementExecution>();
        private int blockStartIndexQueries = 0;
        private int blockStartIndexUpdates = 0;
        private int blockStartIndexBatches = 0;

        private QueryStatsBuffer() {
        }

        public void recordQuery(long l, String string) {
            this.queries.add(new StatementExecution(l, string));
        }

        public void recordUpdate(long l, String string) {
            this.updates.add(new StatementExecution(l, string));
        }

        public void recordBatch(long l, String string) {
            this.batches.add(new StatementExecution(l, string));
        }

        public void markBlockStart() {
            this.blockStartIndexQueries = this.queries.size();
            this.blockStartIndexUpdates = this.updates.size();
            this.blockStartIndexBatches = this.batches.size();
        }

        public BlockStats getBlockStats() {
            List<StatementExecution> list = this.queries.subList(this.blockStartIndexQueries, this.queries.size());
            List<StatementExecution> list2 = this.updates.subList(this.blockStartIndexUpdates, this.updates.size());
            List<StatementExecution> list3 = this.batches.subList(this.blockStartIndexBatches, this.batches.size());
            return new BlockStats(list.size(), list.stream().mapToLong(StatementExecution::getExecutionTimeMs).sum(), list.stream().mapToLong(StatementExecution::getExecutionTimeMs).max().orElse(0L), list.stream().map(StatementExecution::getSql).toList(), list2.size(), list2.stream().mapToLong(StatementExecution::getExecutionTimeMs).sum(), list2.stream().mapToLong(StatementExecution::getExecutionTimeMs).max().orElse(0L), list2.stream().map(StatementExecution::getSql).toList(), list3.size(), list3.stream().mapToLong(StatementExecution::getExecutionTimeMs).sum(), list3.stream().mapToLong(StatementExecution::getExecutionTimeMs).max().orElse(0L), list3.stream().map(StatementExecution::getSql).toList());
        }

        public void reset() {
            this.queries.clear();
            this.updates.clear();
            this.batches.clear();
            this.blockStartIndexQueries = 0;
            this.blockStartIndexUpdates = 0;
            this.blockStartIndexBatches = 0;
        }
    }

    public static class BlockStats {
        private final int queryCount;
        private final long queryTotalMs;
        private final long queryMaxMs;
        private final List<String> querySqls;
        private final int updateCount;
        private final long updateTotalMs;
        private final long updateMaxMs;
        private final List<String> updateSqls;
        private final int batchCount;
        private final long batchTotalMs;
        private final long batchMaxMs;
        private final List<String> batchSqls;

        public BlockStats(int n, long l, long l2, List<String> list, int n2, long l3, long l4, List<String> list2, int n3, long l5, long l6, List<String> list3) {
            this.queryCount = n;
            this.queryTotalMs = l;
            this.queryMaxMs = l2;
            this.querySqls = list;
            this.updateCount = n2;
            this.updateTotalMs = l3;
            this.updateMaxMs = l4;
            this.updateSqls = list2;
            this.batchCount = n3;
            this.batchTotalMs = l5;
            this.batchMaxMs = l6;
            this.batchSqls = list3;
        }

        public int getQueryCount() {
            return this.queryCount;
        }

        public long getQueryTotalMs() {
            return this.queryTotalMs;
        }

        public double getQueryMaxMs() {
            return this.queryMaxMs;
        }

        public List<String> getQuerySqls() {
            return this.querySqls;
        }

        public int getUpdateCount() {
            return this.updateCount;
        }

        public long getUpdateTotalMs() {
            return this.updateTotalMs;
        }

        public double getUpdateMaxMs() {
            return this.updateMaxMs;
        }

        public List<String> getUpdateSqls() {
            return this.updateSqls;
        }

        public int getBatchCount() {
            return this.batchCount;
        }

        public long getBatchTotalMs() {
            return this.batchTotalMs;
        }

        public double getBatchMaxMs() {
            return this.batchMaxMs;
        }

        public List<String> getBatchSqls() {
            return this.batchSqls;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            BlockStats blockStats = (BlockStats)object;
            return this.queryCount == blockStats.queryCount && this.queryTotalMs == blockStats.queryTotalMs && this.queryMaxMs == blockStats.queryMaxMs && this.updateCount == blockStats.updateCount && this.updateTotalMs == blockStats.updateTotalMs && this.updateMaxMs == blockStats.updateMaxMs && this.batchCount == blockStats.batchCount && this.batchTotalMs == blockStats.batchTotalMs && this.batchMaxMs == blockStats.batchMaxMs && Objects.equals(this.querySqls, blockStats.querySqls) && Objects.equals(this.updateSqls, blockStats.updateSqls) && Objects.equals(this.batchSqls, blockStats.batchSqls);
        }

        public int hashCode() {
            return Objects.hash(this.queryCount, this.queryTotalMs, this.queryMaxMs, this.querySqls, this.updateCount, this.updateTotalMs, this.updateMaxMs, this.updateSqls, this.batchCount, this.batchTotalMs, this.batchMaxMs, this.batchSqls);
        }

        public String toString() {
            return "BlockStats{queryCount=" + this.queryCount + ", queryTotalMs=" + this.queryTotalMs + ", queryMaxMs=" + this.queryMaxMs + ", updateCount=" + this.updateCount + ", updateTotalMs=" + this.updateTotalMs + ", updateMaxMs=" + this.updateMaxMs + ", batchCount=" + this.batchCount + ", batchTotalMs=" + this.batchTotalMs + ", batchMaxMs=" + this.batchMaxMs + "}";
        }
    }

    private static class StatementExecution {
        private final long executionTimeMs;
        private final String sql;

        public StatementExecution(long l, String string) {
            this.executionTimeMs = l;
            this.sql = string;
        }

        public long getExecutionTimeMs() {
            return this.executionTimeMs;
        }

        public String getSql() {
            return this.sql;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            StatementExecution statementExecution = (StatementExecution)object;
            return this.executionTimeMs == statementExecution.executionTimeMs && Objects.equals(this.sql, statementExecution.sql);
        }

        public int hashCode() {
            return Objects.hash(this.executionTimeMs, this.sql);
        }

        public String toString() {
            return "StatementExecution{executionTimeMs=" + this.executionTimeMs + ", sql='" + this.sql + "'}";
        }
    }
}

