/*
 * Decompiled with CFR 0.152.
 */
package net.brdloush.dbstopwatch;

import java.text.NumberFormat;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.brdloush.dbstopwatch.P6SpyStatsCollector;

public class DbStopWatch {
    private final String id;
    private final Consumer<String> logFunction;
    private final Clock clock;
    private List<TaskInfo> taskList = new ArrayList<TaskInfo>();
    private long startTimeNanos = 0L;
    private String currentTaskName = null;
    private TaskInfo lastTaskInfo = null;
    private int taskCount = 0;
    private long totalTimeNanos = 0L;

    public DbStopWatch() {
        this("", null, null);
    }

    public DbStopWatch(String string) {
        this(string, null, null);
    }

    public DbStopWatch(String string, Consumer<String> consumer) {
        this(string, consumer, null);
    }

    public DbStopWatch(String string, Consumer<String> consumer, Supplier<Clock> supplier) {
        this.id = string;
        this.logFunction = consumer;
        this.clock = supplier != null ? supplier.get() : Clock.systemUTC();
    }

    public void setKeepTaskList(boolean bl) {
        this.taskList = bl ? new ArrayList() : null;
    }

    public void start() {
        this.start("");
    }

    public void start(String string) {
        if (this.logFunction != null) {
            this.logFunction.accept(this.id + " / \"" + string + "\" - START\n");
        }
        if (this.currentTaskName != null) {
            throw new IllegalStateException("Can't start DbStopWatch: it's already running");
        }
        this.currentTaskName = string;
        this.startTimeNanos = this.epochNanoFromClock();
        P6SpyStatsCollector.markBlockStart();
    }

    private long epochNanoFromClock() {
        Instant instant = this.clock.instant();
        long l = instant.getEpochSecond();
        int n = instant.getNano();
        return l * 1000000000L + (long)n;
    }

    public void stopAndStart(String string) {
        this.stop();
        this.start(string);
    }

    public void finish() {
        if (this.isRunning()) {
            this.stop();
        }
        if (this.logFunction != null) {
            this.logFunction.accept(this.prettyPrint());
        }
    }

    public void stop() {
        if (this.currentTaskName == null) {
            throw new IllegalStateException("Can't stop DbStopWatch: it's not running");
        }
        if (this.logFunction != null) {
            this.logFunction.accept(this.id + " / \"" + this.currentTaskName + "\" - END\n");
        }
        long l = this.epochNanoFromClock() - this.startTimeNanos;
        this.totalTimeNanos += l;
        P6SpyStatsCollector.BlockStats blockStats = P6SpyStatsCollector.getBlockStats();
        this.lastTaskInfo = new TaskInfo(this.currentTaskName, l, blockStats.getQueryCount(), blockStats.getQueryMaxMs(), blockStats.getQueryTotalMs(), blockStats.getUpdateCount(), blockStats.getUpdateMaxMs(), blockStats.getUpdateTotalMs(), blockStats.getBatchCount(), blockStats.getBatchMaxMs(), blockStats.getBatchTotalMs());
        if (this.taskList != null) {
            this.taskList.add(this.lastTaskInfo);
        }
        ++this.taskCount;
        this.currentTaskName = null;
    }

    public boolean isRunning() {
        return this.currentTaskName != null;
    }

    public String getCurrentTaskName() {
        return this.currentTaskName;
    }

    public TaskInfo getLastTaskInfo() {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tasks run");
        }
        return this.lastTaskInfo;
    }

    public TaskInfo[] getTaskInfo() {
        if (this.taskList == null) {
            throw new IllegalStateException("Task info is not being kept!");
        }
        return this.taskList.toArray(new TaskInfo[0]);
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public long getTotalTimeNanos() {
        return this.totalTimeNanos;
    }

    public long getTotalTimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.totalTimeNanos);
    }

    public double getTotalTimeSeconds() {
        return this.getTotalTime(TimeUnit.SECONDS);
    }

    public double getTotalTime(TimeUnit timeUnit) {
        return (double)this.totalTimeNanos / (double)TimeUnit.NANOSECONDS.convert(1L, timeUnit);
    }

    public String prettyPrint() {
        return this.prettyPrint(TimeUnit.SECONDS);
    }

    public String prettyPrint(TimeUnit timeUnit) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
        numberFormat.setMaximumFractionDigits(9);
        numberFormat.setGroupingUsed(false);
        NumberFormat numberFormat2 = NumberFormat.getPercentInstance(Locale.ENGLISH);
        numberFormat2.setMinimumIntegerDigits(2);
        numberFormat2.setGroupingUsed(false);
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("DbStopWatch '").append(this.id).append("': ");
        String string = timeUnit == TimeUnit.NANOSECONDS ? numberFormat.format(this.getTotalTimeNanos()) : numberFormat.format(this.getTotalTime(timeUnit));
        stringBuilder.append(string).append(" ").append(timeUnit.name().toLowerCase());
        int n = Math.max(stringBuilder.length(), 130);
        stringBuilder.append("\n");
        if (this.taskList != null) {
            String string2 = "-".repeat(n) + "\n";
            Object object = timeUnit.name();
            object = ((String)object).charAt(0) + ((String)object).substring(1).toLowerCase();
            object = String.format("%-12s", object);
            stringBuilder.append(string2);
            stringBuilder.append((String)object).append("  %       Q-cnt    Q-max     Q-total     U-cnt    U-max     U-total     B-cnt    B-max     B-total     DB%     Task name\n");
            stringBuilder.append(string2);
            int n2 = string.indexOf(46);
            if (n2 < 0) {
                n2 = string.length();
            }
            numberFormat.setMinimumIntegerDigits(n2);
            numberFormat.setMaximumFractionDigits(10 - n2);
            for (TaskInfo taskInfo : this.taskList) {
                String string3;
                String string4 = timeUnit == TimeUnit.NANOSECONDS ? numberFormat.format(taskInfo.getTimeNanos()) : numberFormat.format(taskInfo.getTime(timeUnit));
                String string5 = numberFormat2.format((double)taskInfo.getTimeMillis() / (double)this.getTotalTimeMillis());
                long l = taskInfo.getQueryCount();
                String[] stringArray = this.formatTimeDisplay(l, taskInfo.getQueryMaxMs(), taskInfo.getQueryTotalMs());
                long l2 = taskInfo.getUpdateCount();
                String[] stringArray2 = this.formatTimeDisplay(l2, taskInfo.getUpdateMaxMs(), taskInfo.getUpdateTotalMs());
                long l3 = taskInfo.getBatchCount();
                String[] stringArray3 = this.formatTimeDisplay(l3, taskInfo.getBatchMaxMs(), taskInfo.getBatchTotalMs());
                if (l2 > 0L || l > 0L || l3 > 0L) {
                    double d = (double)(taskInfo.getUpdateTotalMs() + taskInfo.getQueryTotalMs() + taskInfo.getBatchTotalMs()) / (double)taskInfo.getTimeMillis() * 100.0;
                    string3 = String.format("%-8.0f", d);
                } else {
                    string3 = String.format("%-8s", "-");
                }
                stringBuilder.append(String.format("%-14s", string4));
                stringBuilder.append(String.format("%-8s", string5));
                stringBuilder.append(String.format("%-9d", l));
                stringBuilder.append(String.format("%-10s", stringArray[0]));
                stringBuilder.append(String.format("%-12s", stringArray[1]));
                stringBuilder.append(String.format("%-9d", l2));
                stringBuilder.append(String.format("%-10s", stringArray2[0]));
                stringBuilder.append(String.format("%-12s", stringArray2[1]));
                stringBuilder.append(String.format("%-9d", l3));
                stringBuilder.append(String.format("%-10s", stringArray3[0]));
                stringBuilder.append(String.format("%-12s", stringArray3[1]));
                stringBuilder.append(string3);
                stringBuilder.append(taskInfo.getTaskName()).append('\n');
            }
        } else {
            stringBuilder.append("No task info kept");
        }
        return stringBuilder.toString();
    }

    public String shortSummary() {
        return "DbStopWatch '" + this.id + "': " + this.getTotalTimeSeconds() + " seconds";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.shortSummary());
        if (this.taskList != null) {
            for (TaskInfo taskInfo : this.taskList) {
                stringBuilder.append("; [").append(taskInfo.getTaskName()).append("] took ").append(taskInfo.getTimeSeconds()).append(" seconds");
                int n = (int)Math.round(100.0 * taskInfo.getTimeSeconds() / this.getTotalTimeSeconds());
                stringBuilder.append(" = ").append(n).append("%");
                if (taskInfo.getQueryCount() > 0L) {
                    int n2 = (int)Math.round((double)taskInfo.getQueryTotalMs() / (double)taskInfo.getTimeMillis() * 100.0);
                    stringBuilder.append(" (").append(taskInfo.getQueryCount()).append(" queries, ").append(taskInfo.getQueryTotalMs()).append("ms total, ").append(n2).append("% DB)");
                    continue;
                }
                stringBuilder.append(" (no queries)");
            }
        } else {
            stringBuilder.append("; no task info kept");
        }
        return stringBuilder.toString();
    }

    private String[] formatTimeDisplay(long l, double d, long l2) {
        if (l > 0L) {
            return new String[]{String.format("%-9.0f", d), String.format("%-11s", l2)};
        }
        return new String[]{String.format("%-9s", "-"), String.format("%-11s", "-")};
    }

    public static class TaskInfo {
        private final String taskName;
        private final long timeNanos;
        private final long queryCount;
        private final double queryMaxMs;
        private final long queryTotalMs;
        private final long updateCount;
        private final double updateMaxMs;
        private final long updateTotalMs;
        private final long batchCount;
        private final double batchMaxMs;
        private final long batchTotalMs;

        public TaskInfo(String string, long l, long l2, double d, long l3, long l4, double d2, long l5, long l6, double d3, long l7) {
            this.taskName = string;
            this.timeNanos = l;
            this.queryCount = l2;
            this.queryMaxMs = d;
            this.queryTotalMs = l3;
            this.updateCount = l4;
            this.updateMaxMs = d2;
            this.updateTotalMs = l5;
            this.batchCount = l6;
            this.batchMaxMs = d3;
            this.batchTotalMs = l7;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public long getTimeNanos() {
            return this.timeNanos;
        }

        public long getQueryCount() {
            return this.queryCount;
        }

        public double getQueryMaxMs() {
            return this.queryMaxMs;
        }

        public long getQueryTotalMs() {
            return this.queryTotalMs;
        }

        public long getUpdateCount() {
            return this.updateCount;
        }

        public double getUpdateMaxMs() {
            return this.updateMaxMs;
        }

        public long getUpdateTotalMs() {
            return this.updateTotalMs;
        }

        public long getBatchCount() {
            return this.batchCount;
        }

        public double getBatchMaxMs() {
            return this.batchMaxMs;
        }

        public long getBatchTotalMs() {
            return this.batchTotalMs;
        }

        public long getTimeMillis() {
            return TimeUnit.NANOSECONDS.toMillis(this.timeNanos);
        }

        public double getTimeSeconds() {
            return this.getTime(TimeUnit.SECONDS);
        }

        public double getTime(TimeUnit timeUnit) {
            return (double)this.timeNanos / (double)TimeUnit.NANOSECONDS.convert(1L, timeUnit);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            TaskInfo taskInfo = (TaskInfo)object;
            return this.timeNanos == taskInfo.timeNanos && this.queryCount == taskInfo.queryCount && Double.compare(taskInfo.queryMaxMs, this.queryMaxMs) == 0 && this.queryTotalMs == taskInfo.queryTotalMs && this.updateCount == taskInfo.updateCount && Double.compare(taskInfo.updateMaxMs, this.updateMaxMs) == 0 && this.updateTotalMs == taskInfo.updateTotalMs && this.batchCount == taskInfo.batchCount && Double.compare(taskInfo.batchMaxMs, this.batchMaxMs) == 0 && this.batchTotalMs == taskInfo.batchTotalMs && Objects.equals(this.taskName, taskInfo.taskName);
        }

        public int hashCode() {
            return Objects.hash(this.taskName, this.timeNanos, this.queryCount, this.queryMaxMs, this.queryTotalMs, this.updateCount, this.updateMaxMs, this.updateTotalMs, this.batchCount, this.batchMaxMs, this.batchTotalMs);
        }

        public String toString() {
            return "TaskInfo{taskName='" + this.taskName + "', timeNanos=" + this.timeNanos + ", queryCount=" + this.queryCount + ", queryMaxMs=" + this.queryMaxMs + ", queryTotalMs=" + this.queryTotalMs + ", updateCount=" + this.updateCount + ", updateMaxMs=" + this.updateMaxMs + ", updateTotalMs=" + this.updateTotalMs + ", batchCount=" + this.batchCount + ", batchMaxMs=" + this.batchMaxMs + ", batchTotalMs=" + this.batchTotalMs + "}";
        }
    }
}

