/*
 * Decompiled with CFR 0.152.
 */
package net.brdloush.dbstopwatch;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import net.brdloush.dbstopwatch.P6SpyStatsCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001/B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0011J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0003J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0011J\u0006\u0010\u0018\u001a\u00020\u0013J\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003J\u0006\u0010\f\u001a\u00020\bJ\u0011\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u001a\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001c\u001a\u00020\u000eJ\u0006\u0010\u001d\u001a\u00020\nJ\u0006\u0010\u001e\u001a\u00020\nJ\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020\u0003J\u000e\u0010$\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#J\u0006\u0010%\u001a\u00020\u0003J\b\u0010&\u001a\u00020\u0003H\u0016JI\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030(2\u0006\u0010)\u001a\u00020\n2\b\u0010*\u001a\u0004\u0018\u00010 2\b\u0010+\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010,\u001a\u00020\u000e2\b\b\u0002\u0010-\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010.R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lnet/brdloush/dbstopwatch/DbStatsStopWatch;", "", "id", "", "<init>", "(Ljava/lang/String;)V", "taskList", "", "Lnet/brdloush/dbstopwatch/DbStatsStopWatch$TaskInfo;", "startTimeNanos", "", "currentTaskName", "lastTaskInfo", "taskCount", "", "totalTimeNanos", "setKeepTaskList", "", "keepTaskList", "", "start", "taskName", "stopAndStart", "stop", "isRunning", "getTaskInfo", "", "()[Lnet/brdloush/dbstopwatch/DbStatsStopWatch$TaskInfo;", "getTaskCount", "getTotalTimeNanos", "getTotalTimeMillis", "getTotalTimeSeconds", "", "getTotalTime", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "prettyPrint", "shortSummary", "toString", "formatTimeDisplay", "Lkotlin/Pair;", "count", "maxMs", "totalMs", "maxWidth", "totalWidth", "(JLjava/lang/Double;Ljava/lang/Long;II)Lkotlin/Pair;", "TaskInfo", "db-stopwatch"})
@SourceDebugExtension(value={"SMAP\nDbStatsStopWatch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbStatsStopWatch.kt\nnet/brdloush/dbstopwatch/DbStatsStopWatch\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,312:1\n1#2:313\n37#3:314\n36#3,3:315\n*S KotlinDebug\n*F\n+ 1 DbStatsStopWatch.kt\nnet/brdloush/dbstopwatch/DbStatsStopWatch\n*L\n118#1:314\n118#1:315,3\n*E\n"})
public final class DbStatsStopWatch {
    @NotNull
    private final String id;
    @Nullable
    private List<TaskInfo> taskList;
    private long startTimeNanos;
    @Nullable
    private String currentTaskName;
    @Nullable
    private TaskInfo lastTaskInfo;
    private int taskCount;
    private long totalTimeNanos;

    public DbStatsStopWatch(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
        this.taskList = new ArrayList();
    }

    public /* synthetic */ DbStatsStopWatch(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        this(string);
    }

    public final void setKeepTaskList(boolean keepTaskList) {
        this.taskList = keepTaskList ? (List)new ArrayList() : null;
    }

    public final void start() {
        this.start("");
    }

    public final void start(@NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        if (!(this.currentTaskName == null)) {
            boolean bl = false;
            String string = "Can't start DbStatsStopWatch: it's already running";
            throw new IllegalStateException(string.toString());
        }
        this.currentTaskName = taskName;
        this.startTimeNanos = System.nanoTime();
        P6SpyStatsCollector.Companion.markBlockStart();
    }

    public final void stopAndStart(@NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        this.stop();
        this.start(taskName);
    }

    public final void stop() {
        if (!(this.currentTaskName != null)) {
            boolean bl = false;
            String string = "Can't stop DbStatsStopWatch: it's not running";
            throw new IllegalStateException(string.toString());
        }
        long lastTime = System.nanoTime() - this.startTimeNanos;
        this.totalTimeNanos += lastTime;
        P6SpyStatsCollector.BlockStats blockStats = P6SpyStatsCollector.Companion.getBlockStats();
        String string = this.currentTaskName;
        Intrinsics.checkNotNull((Object)string);
        this.lastTaskInfo = new TaskInfo(string, lastTime, blockStats.getQueryCount(), blockStats.getQueryMaxMs(), blockStats.getQueryTotalMs(), blockStats.getUpdateCount(), blockStats.getUpdateMaxMs(), blockStats.getUpdateTotalMs());
        List<TaskInfo> list = this.taskList;
        if (list != null) {
            TaskInfo taskInfo = this.lastTaskInfo;
            Intrinsics.checkNotNull((Object)taskInfo);
            list.add(taskInfo);
        }
        int n = this.taskCount;
        this.taskCount = n + 1;
        this.currentTaskName = null;
    }

    public final boolean isRunning() {
        return this.currentTaskName != null;
    }

    @Nullable
    public final String currentTaskName() {
        return this.currentTaskName;
    }

    @NotNull
    public final TaskInfo lastTaskInfo() {
        TaskInfo taskInfo = this.lastTaskInfo;
        if (taskInfo == null) {
            throw new IllegalStateException("No tasks run".toString());
        }
        return taskInfo;
    }

    @NotNull
    public final TaskInfo[] getTaskInfo() {
        TaskInfo[] taskInfoArray;
        block3: {
            block2: {
                taskInfoArray = this.taskList;
                if (this.taskList == null) break block2;
                Collection $this$toTypedArray$iv = (Collection)taskInfoArray;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                taskInfoArray = thisCollection$iv.toArray(new TaskInfo[0]);
                if (taskInfoArray != null) break block3;
            }
            throw new IllegalStateException("Task info is not being kept!".toString());
        }
        return taskInfoArray;
    }

    public final int getTaskCount() {
        return this.taskCount;
    }

    public final long getTotalTimeNanos() {
        return this.totalTimeNanos;
    }

    public final long getTotalTimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.totalTimeNanos);
    }

    public final double getTotalTimeSeconds() {
        return this.getTotalTime(TimeUnit.SECONDS);
    }

    public final double getTotalTime(@NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        return (double)this.totalTimeNanos / (double)TimeUnit.NANOSECONDS.convert(1L, timeUnit);
    }

    @NotNull
    public final String prettyPrint() {
        return this.prettyPrint(TimeUnit.SECONDS);
    }

    @NotNull
    public final String prettyPrint(@NotNull TimeUnit timeUnit) {
        NumberFormat numberFormat;
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        NumberFormat $this$prettyPrint_u24lambda_u242 = numberFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
        boolean bl = false;
        $this$prettyPrint_u24lambda_u242.setMaximumFractionDigits(9);
        $this$prettyPrint_u24lambda_u242.setGroupingUsed(false);
        NumberFormat nf = numberFormat;
        NumberFormat $this$prettyPrint_u24lambda_u243 = $this$prettyPrint_u24lambda_u242 = NumberFormat.getPercentInstance(Locale.ENGLISH);
        boolean bl2 = false;
        $this$prettyPrint_u24lambda_u243.setMinimumIntegerDigits(2);
        $this$prettyPrint_u24lambda_u243.setGroupingUsed(false);
        NumberFormat pf = $this$prettyPrint_u24lambda_u242;
        StringBuilder sb = new StringBuilder(256);
        sb.append("DbStatsStopWatch '" + this.id + "': ");
        String total = timeUnit == TimeUnit.NANOSECONDS ? nf.format(this.getTotalTimeNanos()) : nf.format(this.getTotalTime(timeUnit));
        StringBuilder stringBuilder = sb.append(total);
        StringBuilder stringBuilder2 = new StringBuilder().append(' ');
        String string = timeUnit.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        stringBuilder.append(stringBuilder2.append(string).toString());
        int width = Math.max(sb.length(), 130);
        sb.append("\n");
        List<TaskInfo> list = this.taskList;
        if (list != null) {
            List<TaskInfo> tasks = list;
            boolean bl3 = false;
            String line = StringsKt.repeat((CharSequence)"-", (int)width) + '\n';
            String it = timeUnit.name();
            boolean bl4 = false;
            char c = StringsKt.first((CharSequence)it);
            String string2 = it.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String string3 = string2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            String string4 = string3;
            String unitName = StringsKt.padEnd$default((String)(c + string4), (int)12, (char)'\u0000', (int)2, null);
            sb.append(line);
            sb.append(unitName + "  %       Q-cnt    Q-max     Q-total     U-cnt    U-max     U-total     DB%     Task name\n");
            sb.append(line);
            Intrinsics.checkNotNull((Object)total);
            int digits = StringsKt.indexOf$default((CharSequence)total, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (digits < 0) {
                digits = total.length();
            }
            nf.setMinimumIntegerDigits(digits);
            nf.setMaximumFractionDigits(10 - digits);
            for (TaskInfo task : tasks) {
                Object[] objectArray;
                String string5;
                String string6;
                String taskTime = timeUnit == TimeUnit.NANOSECONDS ? nf.format(task.getTimeNanos()) : nf.format(task.getTime(timeUnit));
                String taskPercentage = pf.format(task.getTimeSeconds() / this.getTotalTimeSeconds());
                long queryCount = task.getQueryCount();
                Pair pair = DbStatsStopWatch.formatTimeDisplay$default(this, queryCount, task.getQueryMaxMs(), task.getQueryTotalMs(), 0, 0, 24, null);
                String queryMaxTimeDisplay = (String)pair.component1();
                String queryTotalTimeDisplay = (String)pair.component2();
                long updateCount = task.getUpdateCount();
                Pair pair2 = DbStatsStopWatch.formatTimeDisplay$default(this, updateCount, task.getUpdateMaxMs(), task.getUpdateTotalMs(), 0, 0, 24, null);
                String updateMaxTimeDisplay = (String)pair2.component1();
                String updateTotalTimeDisplay = (String)pair2.component2();
                if (updateCount > 0L || queryCount > 0L) {
                    double dbPercent = ((double)task.getUpdateTotalMs() + (double)task.getQueryTotalMs()) / (double)task.getTimeMillis() * (double)100;
                    String string7 = "%-8.0f";
                    Object[] objectArray2 = new Object[]{dbPercent};
                    String string8 = String.format(string7, Arrays.copyOf(objectArray2, objectArray2.length));
                    string6 = string8;
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"format(...)");
                } else {
                    string5 = "%-8s";
                    objectArray = new Object[]{"-"};
                    String string9 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
                    string6 = string9;
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"format(...)");
                }
                String dbPercentage = string6;
                string5 = "%-14s";
                objectArray = new Object[]{taskTime};
                String string10 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"format(...)");
                sb.append(string10);
                string5 = "%-8s";
                objectArray = new Object[]{taskPercentage};
                String string11 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"format(...)");
                sb.append(string11);
                string5 = "%-9d";
                objectArray = new Object[]{queryCount};
                String string12 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"format(...)");
                sb.append(string12);
                string5 = "%-10s";
                objectArray = new Object[]{queryMaxTimeDisplay};
                String string13 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"format(...)");
                sb.append(string13);
                string5 = "%-12s";
                objectArray = new Object[]{queryTotalTimeDisplay};
                String string14 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"format(...)");
                sb.append(string14);
                string5 = "%-9d";
                objectArray = new Object[]{updateCount};
                String string15 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"format(...)");
                sb.append(string15);
                string5 = "%-10s";
                objectArray = new Object[]{updateMaxTimeDisplay};
                String string16 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"format(...)");
                sb.append(string16);
                string5 = "%-12s";
                objectArray = new Object[]{updateTotalTimeDisplay};
                String string17 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"format(...)");
                sb.append(string17);
                sb.append(dbPercentage);
                sb.append(task.getTaskName()).append('\n');
            }
        } else {
            DbStatsStopWatch $this$prettyPrint_u24lambda_u246 = this;
            boolean bl5 = false;
            sb.append("No task info kept");
        }
        String string18 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"toString(...)");
        return string18;
    }

    @NotNull
    public final String shortSummary() {
        return "DbStatsStopWatch '" + this.id + "': " + this.getTotalTimeSeconds() + " seconds";
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder(this.shortSummary());
        List<TaskInfo> list = this.taskList;
        if (list != null) {
            List<TaskInfo> tasks = list;
            boolean bl = false;
            for (TaskInfo task : tasks) {
                StringBuilder stringBuilder;
                sb.append("; [" + task.getTaskName() + "] took " + task.getTimeSeconds() + " seconds");
                int percent = MathKt.roundToInt((double)(100.0 * task.getTimeSeconds() / this.getTotalTimeSeconds()));
                sb.append(" = " + percent + '%');
                if (task.getQueryCount() > 0L) {
                    int dbPercent = MathKt.roundToInt((double)((double)task.getQueryTotalMs() / (double)task.getTimeMillis() * (double)100));
                    stringBuilder = sb.append(" (" + task.getQueryCount() + " queries, " + task.getQueryTotalMs() + "ms total, " + dbPercent + "% DB)");
                    continue;
                }
                stringBuilder = sb.append(" (no queries)");
            }
        } else {
            DbStatsStopWatch $this$toString_u24lambda_u248 = this;
            boolean bl = false;
            sb.append("; no task info kept");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final Pair<String, String> formatTimeDisplay(long count, Double maxMs, Long totalMs, int maxWidth, int totalWidth) {
        Pair pair;
        if (count > 0L) {
            String string = "%-" + maxWidth + ".0f";
            Object[] objectArray = new Object[]{maxMs};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            string = "%-" + totalWidth + 's';
            objectArray = new Object[]{totalMs};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            pair = TuplesKt.to((Object)string2, (Object)string3);
        } else {
            String string = "%-" + maxWidth + 's';
            Object[] objectArray = new Object[]{"-"};
            String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            string = "%-" + totalWidth + 's';
            objectArray = new Object[]{"-"};
            String string5 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
            pair = TuplesKt.to((Object)string4, (Object)string5);
        }
        return pair;
    }

    static /* synthetic */ Pair formatTimeDisplay$default(DbStatsStopWatch dbStatsStopWatch, long l, Double d, Long l2, int n, int n2, int n3, Object object) {
        if ((n3 & 8) != 0) {
            n = 9;
        }
        if ((n3 & 0x10) != 0) {
            n2 = 11;
        }
        return dbStatsStopWatch.formatTimeDisplay(l, d, l2, n, n2);
    }

    public DbStatsStopWatch() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\u0005\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010\u001a\u001a\u00020\u0005J\u0006\u0010\u001b\u001a\u00020\bJ\u000e\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001eJ\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\bH\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\t\u0010%\u001a\u00020\bH\u00c6\u0003J\t\u0010&\u001a\u00020\u0005H\u00c6\u0003JY\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012\u00a8\u0006."}, d2={"Lnet/brdloush/dbstopwatch/DbStatsStopWatch$TaskInfo;", "", "taskName", "", "timeNanos", "", "queryCount", "queryMaxMs", "", "queryTotalMs", "updateCount", "updateMaxMs", "updateTotalMs", "<init>", "(Ljava/lang/String;JJDJJDJ)V", "getTaskName", "()Ljava/lang/String;", "getTimeNanos", "()J", "getQueryCount", "getQueryMaxMs", "()D", "getQueryTotalMs", "getUpdateCount", "getUpdateMaxMs", "getUpdateTotalMs", "getTimeMillis", "getTimeSeconds", "getTime", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "", "toString", "db-stopwatch"})
    public static final class TaskInfo {
        @NotNull
        private final String taskName;
        private final long timeNanos;
        private final long queryCount;
        private final double queryMaxMs;
        private final long queryTotalMs;
        private final long updateCount;
        private final double updateMaxMs;
        private final long updateTotalMs;

        public TaskInfo(@NotNull String taskName, long timeNanos, long queryCount, double queryMaxMs, long queryTotalMs, long updateCount, double updateMaxMs, long updateTotalMs) {
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            this.taskName = taskName;
            this.timeNanos = timeNanos;
            this.queryCount = queryCount;
            this.queryMaxMs = queryMaxMs;
            this.queryTotalMs = queryTotalMs;
            this.updateCount = updateCount;
            this.updateMaxMs = updateMaxMs;
            this.updateTotalMs = updateTotalMs;
        }

        @NotNull
        public final String getTaskName() {
            return this.taskName;
        }

        public final long getTimeNanos() {
            return this.timeNanos;
        }

        public final long getQueryCount() {
            return this.queryCount;
        }

        public final double getQueryMaxMs() {
            return this.queryMaxMs;
        }

        public final long getQueryTotalMs() {
            return this.queryTotalMs;
        }

        public final long getUpdateCount() {
            return this.updateCount;
        }

        public final double getUpdateMaxMs() {
            return this.updateMaxMs;
        }

        public final long getUpdateTotalMs() {
            return this.updateTotalMs;
        }

        public final long getTimeMillis() {
            return TimeUnit.NANOSECONDS.toMillis(this.timeNanos);
        }

        public final double getTimeSeconds() {
            return this.getTime(TimeUnit.SECONDS);
        }

        public final double getTime(@NotNull TimeUnit timeUnit) {
            Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
            return (double)this.timeNanos / (double)TimeUnit.NANOSECONDS.convert(1L, timeUnit);
        }

        @NotNull
        public final String component1() {
            return this.taskName;
        }

        public final long component2() {
            return this.timeNanos;
        }

        public final long component3() {
            return this.queryCount;
        }

        public final double component4() {
            return this.queryMaxMs;
        }

        public final long component5() {
            return this.queryTotalMs;
        }

        public final long component6() {
            return this.updateCount;
        }

        public final double component7() {
            return this.updateMaxMs;
        }

        public final long component8() {
            return this.updateTotalMs;
        }

        @NotNull
        public final TaskInfo copy(@NotNull String taskName, long timeNanos, long queryCount, double queryMaxMs, long queryTotalMs, long updateCount, double updateMaxMs, long updateTotalMs) {
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            return new TaskInfo(taskName, timeNanos, queryCount, queryMaxMs, queryTotalMs, updateCount, updateMaxMs, updateTotalMs);
        }

        public static /* synthetic */ TaskInfo copy$default(TaskInfo taskInfo, String string, long l, long l2, double d, long l3, long l4, double d2, long l5, int n, Object object) {
            if ((n & 1) != 0) {
                string = taskInfo.taskName;
            }
            if ((n & 2) != 0) {
                l = taskInfo.timeNanos;
            }
            if ((n & 4) != 0) {
                l2 = taskInfo.queryCount;
            }
            if ((n & 8) != 0) {
                d = taskInfo.queryMaxMs;
            }
            if ((n & 0x10) != 0) {
                l3 = taskInfo.queryTotalMs;
            }
            if ((n & 0x20) != 0) {
                l4 = taskInfo.updateCount;
            }
            if ((n & 0x40) != 0) {
                d2 = taskInfo.updateMaxMs;
            }
            if ((n & 0x80) != 0) {
                l5 = taskInfo.updateTotalMs;
            }
            return taskInfo.copy(string, l, l2, d, l3, l4, d2, l5);
        }

        @NotNull
        public String toString() {
            return "TaskInfo(taskName=" + this.taskName + ", timeNanos=" + this.timeNanos + ", queryCount=" + this.queryCount + ", queryMaxMs=" + this.queryMaxMs + ", queryTotalMs=" + this.queryTotalMs + ", updateCount=" + this.updateCount + ", updateMaxMs=" + this.updateMaxMs + ", updateTotalMs=" + this.updateTotalMs + ')';
        }

        public int hashCode() {
            int result = this.taskName.hashCode();
            result = result * 31 + Long.hashCode(this.timeNanos);
            result = result * 31 + Long.hashCode(this.queryCount);
            result = result * 31 + Double.hashCode(this.queryMaxMs);
            result = result * 31 + Long.hashCode(this.queryTotalMs);
            result = result * 31 + Long.hashCode(this.updateCount);
            result = result * 31 + Double.hashCode(this.updateMaxMs);
            result = result * 31 + Long.hashCode(this.updateTotalMs);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TaskInfo)) {
                return false;
            }
            TaskInfo taskInfo = (TaskInfo)other;
            if (!Intrinsics.areEqual((Object)this.taskName, (Object)taskInfo.taskName)) {
                return false;
            }
            if (this.timeNanos != taskInfo.timeNanos) {
                return false;
            }
            if (this.queryCount != taskInfo.queryCount) {
                return false;
            }
            if (Double.compare(this.queryMaxMs, taskInfo.queryMaxMs) != 0) {
                return false;
            }
            if (this.queryTotalMs != taskInfo.queryTotalMs) {
                return false;
            }
            if (this.updateCount != taskInfo.updateCount) {
                return false;
            }
            if (Double.compare(this.updateMaxMs, taskInfo.updateMaxMs) != 0) {
                return false;
            }
            return this.updateTotalMs == taskInfo.updateTotalMs;
        }
    }
}

