/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.verify;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.verify.ITestSuiteValidator;
import net.bpelunit.framework.xml.suite.XMLCompleteHumanTaskActivity;
import net.bpelunit.framework.xml.suite.XMLConditionGroup;
import net.bpelunit.framework.xml.suite.XMLHumanPartnerTrack;
import net.bpelunit.framework.xml.suite.XMLTestCase;
import net.bpelunit.framework.xml.suite.XMLTestSuite;
import net.bpelunit.framework.xml.suite.XMLTestSuiteDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionGroupsExistInTestSuiteValidator
implements ITestSuiteValidator {
    @Override
    public void validate(XMLTestSuiteDocument suite) throws SpecificationException {
        Set<String> conditionGroupNames = this.extractConditionGroups(suite.getTestSuite()).keySet();
        Set<String> referencedConditionGroupNames = this.extractUsedConditionGroupNames(suite.getTestSuite());
        for (String cgName : referencedConditionGroupNames) {
            if (conditionGroupNames.contains(cgName)) continue;
            throw new SpecificationException("Condition Group referenced but not defined: " + cgName);
        }
    }

    private Map<String, XMLConditionGroup> extractConditionGroups(XMLTestSuite suite) {
        HashMap<String, XMLConditionGroup> cgs = new HashMap<String, XMLConditionGroup>();
        if (suite.getConditionGroups() != null && suite.getConditionGroups().getConditionGroupList() != null) {
            for (XMLConditionGroup cg : suite.getConditionGroups().getConditionGroupList()) {
                cgs.put(cg.getName(), cg);
            }
        }
        return cgs;
    }

    private Set<String> extractUsedConditionGroupNames(XMLTestSuite suite) {
        Set<String> retval = this.extractionConditionGroupNamesUsedInTestCases(suite);
        retval.addAll(this.extractConditionGroupNamesUsedInCondtionGroupInheritance(suite));
        return retval;
    }

    private Set<String> extractConditionGroupNamesUsedInCondtionGroupInheritance(XMLTestSuite suite) {
        HashSet<String> retval = new HashSet<String>();
        if (suite.getConditionGroups() != null) {
            for (XMLConditionGroup cg : suite.getConditionGroups().getConditionGroupList()) {
                if (cg.getInheritFrom() == null) continue;
                retval.add(cg.getInheritFrom());
            }
        }
        return retval;
    }

    private Set<String> extractionConditionGroupNamesUsedInTestCases(XMLTestSuite suite) {
        HashSet<String> retval = new HashSet<String>();
        List<XMLHumanPartnerTrack> humanPartnerTracks = this.extractHumanTracks(suite);
        for (XMLHumanPartnerTrack pt : humanPartnerTracks) {
            for (XMLCompleteHumanTaskActivity a : pt.getCompleteHumanTaskList()) {
                retval.addAll(a.getConditionGroupList());
            }
        }
        return retval;
    }

    private List<XMLHumanPartnerTrack> extractHumanTracks(XMLTestSuite suite) {
        ArrayList<XMLHumanPartnerTrack> retval = new ArrayList<XMLHumanPartnerTrack>();
        for (XMLTestCase tc : suite.getTestCases().getTestCaseList()) {
            retval.addAll(tc.getHumanPartnerTrackList());
        }
        return retval;
    }
}

