/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model.test.data;

import com.rits.cloning.Cloner;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.namespace.NamespaceContext;
import net.bpelunit.framework.control.util.XMLPrinterTool;
import net.bpelunit.framework.control.util.XPathTool;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.model.test.activity.Activity;
import net.bpelunit.framework.model.test.activity.VelocityContextProvider;
import net.bpelunit.framework.model.test.report.ArtefactStatus;
import net.bpelunit.framework.model.test.report.ITestArtefact;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public abstract class DataSpecification
implements ITestArtefact {
    private static final Cloner CLONER = new Cloner();
    private Activity fActivity;
    protected NamespaceContext fNamespaceContext;
    protected ArtefactStatus fStatus;

    public DataSpecification(Activity parent, NamespaceContext nsContext) throws SpecificationException {
        this.fActivity = parent;
        this.fNamespaceContext = nsContext;
        this.fStatus = ArtefactStatus.createInitialStatus();
    }

    public ITestArtefact getParent() {
        return this.fActivity;
    }

    public ArtefactStatus getStatus() {
        return this.fStatus;
    }

    public void reportProgress(ITestArtefact artefact) {
        this.fActivity.reportProgress(artefact);
    }

    public boolean hasProblems() {
        return this.fStatus.hasProblems();
    }

    protected String expandTemplateToString(VelocityContextProvider context, String template) throws Exception {
        Context velocityCtx = CLONER.deepClone(context.createVelocityContext());
        velocityCtx.put("xpath", new XPathTool(this.fNamespaceContext));
        velocityCtx.put("printer", new XMLPrinterTool());
        StringWriter writer = new StringWriter();
        Velocity.evaluate(velocityCtx, (Writer)writer, "expandTemplate", template);
        String expandedTemplate = writer.toString();
        return expandedTemplate;
    }
}

