/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model.test.activity;

import java.util.List;
import net.bpelunit.framework.model.AbstractPartner;
import net.bpelunit.framework.model.test.PartnerTrack;
import net.bpelunit.framework.model.test.activity.ActivityContext;
import net.bpelunit.framework.model.test.data.SendDataSpecification;
import net.bpelunit.framework.model.test.report.ArtefactStatus;
import net.bpelunit.framework.model.test.report.ITestArtefact;
import net.bpelunit.framework.model.test.report.StateData;
import net.bpelunit.framework.model.test.wire.OutgoingMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Activity
implements ITestArtefact {
    private PartnerTrack fPartnerTrack;
    protected ArtefactStatus fStatus;
    private String fAssumption;

    public Activity(PartnerTrack partnerTrack) {
        this.fPartnerTrack = partnerTrack;
        this.fStatus = ArtefactStatus.createInitialStatus();
    }

    public abstract void run(ActivityContext var1);

    public PartnerTrack getPartnerTrack() {
        return this.fPartnerTrack;
    }

    public AbstractPartner getPartner() {
        return this.fPartnerTrack.getPartner();
    }

    public abstract int getActivityCount();

    public abstract String getActivityCode();

    public boolean hasProblems() {
        return this.getStatus().hasProblems();
    }

    public String getAssumption() {
        return this.fAssumption;
    }

    public void setAssumption(String assumption) {
        this.fAssumption = assumption;
    }

    @Override
    public abstract String getName();

    @Override
    public ArtefactStatus getStatus() {
        return this.fStatus;
    }

    @Override
    public abstract ITestArtefact getParent();

    @Override
    public abstract List<ITestArtefact> getChildren();

    @Override
    public List<StateData> getStateData() {
        return this.fStatus.getAsStateData();
    }

    @Override
    public void reportProgress(ITestArtefact artefact) {
        this.fPartnerTrack.reportProgress(artefact);
    }

    public String toString() {
        return this.getName();
    }

    protected static void copyProtocolOptions(SendDataSpecification source, OutgoingMessage target) {
        for (String option : source.getProtocolOptionNames()) {
            target.addProtocolOption(option, source.getProtocolOption(option));
        }
    }
}

