/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model.test;

import com.rits.cloning.Cloner;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bpelunit.framework.control.datasource.DataSourceUtil;
import net.bpelunit.framework.control.ext.IDataSource;
import net.bpelunit.framework.control.run.TestCaseRunner;
import net.bpelunit.framework.model.test.PartnerTrack;
import net.bpelunit.framework.model.test.TestSuite;
import net.bpelunit.framework.model.test.report.ArtefactStatus;
import net.bpelunit.framework.model.test.report.ITestArtefact;
import net.bpelunit.framework.model.test.report.StateData;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCase
implements ITestArtefact {
    private String fName;
    private Map<String, String> fMetaDataMap;
    private TestSuite fSuite;
    private List<PartnerTrack> fPartnerTracks;
    private ArtefactStatus fStatus;
    private TestCaseRunner fRunner;
    private boolean fAbortedByUser;
    private String fSetUpVelocityScript;
    private Context fTestSuiteVelocityContext;
    private IDataSource fDataSource;
    private int fRowIndex;
    private static final Cloner CLONER = new Cloner();

    public TestCase(TestSuite suite, String name) {
        this.fSuite = suite;
        this.fName = name;
        this.fAbortedByUser = false;
        this.fMetaDataMap = new HashMap<String, String>();
        this.fPartnerTracks = new ArrayList<PartnerTrack>();
        this.fStatus = ArtefactStatus.createInitialStatus();
    }

    public void setName(String name) {
        this.fName = name;
    }

    public void addPartnerTrack(PartnerTrack track) {
        this.fPartnerTracks.add(track);
    }

    public void run() {
        this.fSuite.startTestCase(this);
        this.fRunner = new TestCaseRunner(this.fSuite.getLocalServer(), this);
        this.fRunner.run();
        for (PartnerTrack partnerTrack : this.fPartnerTracks) {
            if (partnerTrack.getStatus().isError()) {
                this.fStatus = partnerTrack.getStatus();
                continue;
            }
            if (!partnerTrack.getStatus().isFailure()) continue;
            this.fStatus = partnerTrack.getStatus();
        }
        if (this.fAbortedByUser) {
            this.fStatus = ArtefactStatus.createAbortedStatus("Aborted by user.");
        }
        if (!this.fStatus.hasProblems()) {
            this.fStatus = ArtefactStatus.createPassedStatus();
        }
        this.fSuite.endTestCase(this);
    }

    public void abortTest() {
        this.fAbortedByUser = true;
        this.fRunner.abortTest();
    }

    @Override
    public String getName() {
        return "Test Case " + this.fName;
    }

    public String getRawName() {
        return this.fName;
    }

    @Override
    public List<ITestArtefact> getChildren() {
        ArrayList<ITestArtefact> children = new ArrayList<ITestArtefact>();
        for (PartnerTrack track : this.getPartnerTracks()) {
            children.add(track);
        }
        return children;
    }

    @Override
    public ITestArtefact getParent() {
        return this.fSuite;
    }

    @Override
    public ArtefactStatus getStatus() {
        return this.fStatus;
    }

    @Override
    public List<StateData> getStateData() {
        ArrayList<StateData> stateData = new ArrayList<StateData>();
        stateData.addAll(this.fStatus.getAsStateData());
        for (String key : this.fMetaDataMap.keySet()) {
            stateData.add(new StateData(key, this.fMetaDataMap.get(key)));
        }
        return stateData;
    }

    @Override
    public void reportProgress(ITestArtefact artefac) {
        this.fSuite.reportProgress(artefac);
    }

    public void addProperty(String property, String value) {
        this.fMetaDataMap.put(property, value);
    }

    public List<PartnerTrack> getPartnerTracks() {
        return this.fPartnerTracks;
    }

    public TestSuite getSuite() {
        return this.fSuite;
    }

    public String getProperty(String property) {
        return this.fMetaDataMap.get(property);
    }

    public boolean hasProblems() {
        return this.fStatus.hasProblems();
    }

    public int getActivityCount() {
        int no = 0;
        for (PartnerTrack partnerTrack : this.fPartnerTracks) {
            no += partnerTrack.getActivityCount();
        }
        return no;
    }

    public String toString() {
        return this.getName();
    }

    public Context createVelocityContext() throws Exception {
        if (this.fTestSuiteVelocityContext == null) {
            this.fTestSuiteVelocityContext = this.getSuite().createVelocityContext();
        }
        Context ctx = CLONER.deepClone(this.fTestSuiteVelocityContext);
        ctx.put("testCaseName", this.getRawName());
        if (this.fDataSource != null) {
            DataSourceUtil.initializeContext(ctx, this.fDataSource, this.fRowIndex);
        }
        if (this.fSetUpVelocityScript != null) {
            StringWriter sW = new StringWriter();
            Velocity.evaluate(ctx, (Writer)sW, "setUpTestCase", this.fSetUpVelocityScript);
        }
        return ctx;
    }

    public String getSetUpVelocityScript() {
        return this.fSetUpVelocityScript;
    }

    public void setSetUpVelocityScript(String script) {
        this.fSetUpVelocityScript = script;
    }

    public void setDataSource(IDataSource fDataSource) {
        this.fDataSource = fDataSource;
    }

    public IDataSource getDataSource() {
        return this.fDataSource;
    }

    public void setRowIndex(int fRowIndex) {
        this.fRowIndex = fRowIndex;
    }

    public int getRowIndex() {
        return this.fRowIndex;
    }
}

