/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model.test;

import com.rits.cloning.Cloner;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import net.bpelunit.framework.control.run.TestCaseRunner;
import net.bpelunit.framework.model.AbstractPartner;
import net.bpelunit.framework.model.Partner;
import net.bpelunit.framework.model.test.TestCase;
import net.bpelunit.framework.model.test.activity.Activity;
import net.bpelunit.framework.model.test.activity.ActivityContext;
import net.bpelunit.framework.model.test.activity.VelocityContextProvider;
import net.bpelunit.framework.model.test.data.ContextXPathVariableResolver;
import net.bpelunit.framework.model.test.report.ArtefactStatus;
import net.bpelunit.framework.model.test.report.ITestArtefact;
import net.bpelunit.framework.model.test.report.StateData;
import org.apache.log4j.Logger;
import org.apache.velocity.context.Context;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartnerTrack
implements ITestArtefact,
Runnable,
VelocityContextProvider {
    private TestCase fTestCase;
    private List<Activity> fActivities = new ArrayList<Activity>();
    private AbstractPartner fPartner;
    private TestCaseRunner fRunner;
    private ArtefactStatus fStatus;
    private Logger fLogger;
    private String fAssumption;
    private NamespaceContext fNamespaceContext;
    private Context fTestCaseVelocityContext;
    private ActivityContext fActivityContext;
    private static final Cloner CLONER = new Cloner();

    public PartnerTrack(TestCase testCase, AbstractPartner client) {
        this.fPartner = client;
        this.fTestCase = testCase;
        this.fStatus = ArtefactStatus.createInitialStatus();
        this.fLogger = Logger.getLogger(this.getClass());
    }

    public void initialize(TestCaseRunner runner) {
        this.fRunner = runner;
    }

    public void setActivities(List<Activity> activities) {
        if (activities != null) {
            this.fActivities = activities;
        } else {
            this.fActivities.clear();
        }
    }

    public void addActivity(Activity a) {
        if (this.fActivities == null) {
            this.fActivities = new ArrayList<Activity>();
        }
        this.fActivities.add(a);
    }

    @Override
    public void run() {
        this.fLogger.info(this.getName() + " now active.");
        this.fActivityContext = new ActivityContext(this.fRunner, this);
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            return;
        }
        if (this.assumptionHolds(this.fAssumption)) {
            for (Activity activity : this.fActivities) {
                if (this.assumptionHolds(activity.getAssumption())) {
                    this.fLogger.info(this.getName() + " now starting activity " + activity);
                    activity.run(this.fActivityContext);
                    this.fLogger.info(this.getName() + " returned from activity " + activity);
                } else {
                    this.fLogger.info(this.getName() + " skipped activity " + activity);
                }
                this.reportProgress(activity);
                if (!activity.hasProblems()) continue;
                this.fStatus = activity.getStatus();
                break;
            }
        } else {
            this.fLogger.info(this.getName() + " was skipped.");
        }
        if (!this.hasProblems()) {
            this.fStatus = ArtefactStatus.createPassedStatus();
        }
        this.fLogger.info(this.getName() + " finished.");
        this.reportProgress(this);
        if (this.hasProblems()) {
            this.fRunner.doneWithFault(this);
        } else {
            this.fRunner.done(this);
        }
    }

    public boolean hasProblems() {
        return this.fStatus.hasProblems();
    }

    public String getPartnerName() {
        return this.fPartner.getName();
    }

    public AbstractPartner getPartner() {
        return this.fPartner;
    }

    public int getActivityCount() {
        int activityCount = 0;
        for (Activity activity : this.fActivities) {
            activityCount += activity.getActivityCount();
        }
        return activityCount;
    }

    public String toString() {
        return this.getName();
    }

    public void setAssumption(String assumption) {
        this.fAssumption = assumption;
    }

    public void setNamespaceContext(NamespaceContext context) {
        this.fNamespaceContext = context;
    }

    @Override
    public String getName() {
        return "Partner Track " + this.getPartner().getName();
    }

    public String getRawName() {
        return this.getPartner().getName();
    }

    @Override
    public List<ITestArtefact> getChildren() {
        ArrayList<ITestArtefact> children = new ArrayList<ITestArtefact>();
        for (Activity activity : this.fActivities) {
            children.add(activity);
        }
        return children;
    }

    @Override
    public ITestArtefact getParent() {
        return this.fTestCase;
    }

    @Override
    public ArtefactStatus getStatus() {
        return this.fStatus;
    }

    @Override
    public List<StateData> getStateData() {
        return this.fStatus.getAsStateData();
    }

    @Override
    public void reportProgress(ITestArtefact artefac) {
        this.fTestCase.reportProgress(artefac);
    }

    @Override
    public Context createVelocityContext() throws Exception {
        if (this.fTestCaseVelocityContext == null) {
            this.fTestCaseVelocityContext = this.fRunner.createVelocityContext();
        }
        Context ctx = CLONER.deepClone(this.fTestCaseVelocityContext);
        ctx.put("partnerTrackName", this.getRawName());
        if (this.getPartner() instanceof Partner) {
            ctx.put("partnerTrackURL", ((Partner)this.getPartner()).getSimulatedURL());
        }
        if (this.fActivityContext != null) {
            ctx.put("request", this.fActivityContext.getLastRequest());
            ctx.put("partnerTrackReceived", this.fActivityContext.getReceivedMessages());
            ctx.put("partnerTrackSent", this.fActivityContext.getSentMessages());
        }
        return ctx;
    }

    private boolean assumptionHolds(String assumption) {
        if (assumption == null) {
            return true;
        }
        try {
            Context context = this.createVelocityContext();
            XPath xpath = XPathFactory.newInstance().newXPath();
            xpath.setNamespaceContext(this.fNamespaceContext);
            xpath.setXPathVariableResolver(new ContextXPathVariableResolver(context));
            return (Boolean)xpath.evaluate(assumption, this.createEmptyDocument(), XPathConstants.BOOLEAN);
        }
        catch (Exception e) {
            this.fStatus = ArtefactStatus.createErrorStatus("Failed to evaluate the assumption " + this.fAssumption, e);
            return false;
        }
    }

    private Document createEmptyDocument() throws ParserConfigurationException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
    }
}

