/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.coverage.receiver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.bpelunit.framework.BPELUnitRunner;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.handler.AbstractHttpHandler;
import org.mortbay.util.ByteArrayISO8859Writer;

public class MarkersServiceHandler
extends AbstractHttpHandler {
    private Logger logger = Logger.getLogger(this.getClass());
    private static final long serialVersionUID = -2402788148972993151L;

    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        if (!request.getMethod().equals("POST")) {
            this.logger.error("Got a non-POST request - rejecting message " + pathInContext);
            return;
        }
        String partnerName = MarkersServiceHandler.getPartnerName(pathInContext);
        if (partnerName.equals("_CoverageReportingService_")) {
            this.sendResponse(response, 200, "");
            StringBuffer buf = MarkersServiceHandler.readRequest(request);
            BPELUnitRunner.getCoverageMeasurmentTool().putMessage(buf.toString());
        }
    }

    private static String getPartnerName(String path) {
        String stringToTest = path;
        stringToTest = StringUtils.removeEnd(stringToTest, "/");
        stringToTest = StringUtils.substringAfterLast(stringToTest, "/");
        return stringToTest;
    }

    private static StringBuffer readRequest(HttpRequest request) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(request.getInputStream()));
        StringBuffer theRequest = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            theRequest.append(line);
        }
        return theRequest;
    }

    private void sendResponse(HttpResponse response, int code, String body) throws IOException {
        response.setContentType("text/xml");
        response.setStatus(code);
        ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer(2048);
        writer.write(body);
        writer.flush();
        response.setContentLength(writer.size());
        writer.writeTo(response.getOutputStream());
        writer.destroy();
    }
}

