/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.coverage.receiver;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Scanner;
import net.bpelunit.framework.coverage.annotation.MetricsManager;
import net.bpelunit.framework.coverage.receiver.MarkerState;
import net.bpelunit.framework.coverage.receiver.MarkersRegistryForBPELFile;
import net.bpelunit.framework.coverage.result.statistic.IFileStatistic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkersRegisterForArchive {
    private Hashtable<String, MarkerState> allCoverageLabels;
    private List<MarkersRegistryForBPELFile> bpelFiles;
    private List<String> infos;
    private MarkersRegistryForBPELFile currentFileRegestry = null;
    private MetricsManager metricManager;

    public MarkersRegisterForArchive(MetricsManager metricManager) {
        this.metricManager = metricManager;
        this.allCoverageLabels = new Hashtable();
        this.bpelFiles = new ArrayList<MarkersRegistryForBPELFile>();
        this.infos = new ArrayList<String>();
    }

    public void registerMarker(String marker) {
        MarkerState status = new MarkerState();
        this.allCoverageLabels.put(marker, status);
        this.currentFileRegestry.registerMarker(marker, status);
    }

    public synchronized void setCoverageStatusForAllMarker(String marker, String testCase) {
        Scanner scanner = new Scanner(marker);
        scanner.useDelimiter("#");
        while (scanner.hasNext()) {
            String marke = scanner.next().trim();
            if (marke.length() <= 0) continue;
            this.setCoverageStatusForMarker(marke, testCase);
        }
        this.notifyAll();
    }

    private void setCoverageStatusForMarker(String coverageMarker, String testCase) {
        MarkerState status;
        if (testCase != null && (status = this.allCoverageLabels.get(coverageMarker)) != null) {
            status.setState(true, testCase);
        }
    }

    public List<IFileStatistic> getStatistics() {
        ArrayList<IFileStatistic> statistics = new ArrayList<IFileStatistic>();
        for (MarkersRegistryForBPELFile registry4File : this.bpelFiles) {
            statistics.add(registry4File.getFileStatistic());
        }
        return statistics;
    }

    public void addRegistryForFile(String fileName) {
        MarkersRegistryForBPELFile registry4File = new MarkersRegistryForBPELFile(fileName, this.metricManager);
        this.bpelFiles.add(registry4File);
        this.currentFileRegestry = registry4File;
    }

    public void addInfo(String info) {
        this.infos.add(info);
    }

    public List<String> getInfo() {
        return this.infos;
    }
}

