/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.coverage.annotation.tools.bpelxmltools;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.bpelunit.framework.control.util.JDomHelper;
import net.bpelunit.framework.coverage.annotation.tools.bpelxmltools.BasicActivities;
import net.bpelunit.framework.coverage.annotation.tools.bpelxmltools.StructuredActivities;
import net.bpelunit.framework.coverage.annotation.tools.bpelxmltools.exprlang.ExpressionLanguage;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelXMLTools {
    public static final Namespace NAMESPACE_BPEL_1_1 = Namespace.getNamespace("http://schemas.xmlsoap.org/ws/2003/03/business-process/");
    public static final Namespace NAMESPACE_BPEL_2_0 = Namespace.getNamespace("http://docs.oasis-open.org/wsbpel/2.0/process/executable");
    public static int sequence_count = 0;
    public static int flow_count = 0;
    public static int invoke_count = 0;
    public static final String PROCESS_ELEMENT = "process";
    public static final String VARIABLE_ELEMENT = "variable";
    private static final String VARIABLES_ELEMENT = "variables";
    public static final String ASSIGN_ELEMENT = "assign";
    public static final String COPY_ELEMENT = "copy";
    public static final String FROM_ELEMENT = "from";
    public static final String TO_ELEMENT = "to";
    public static final String LITERAL_ELEMENT = "literal";
    public static final String IF_ELEMENT = "if";
    public static final String CONDITION_ELEMENT = "condition";
    public static final String ELSE_ELEMENT = "else";
    public static final String SOURCES_ELEMENT = "sources";
    public static final String TARGETS_ELEMENT = "targets";
    public static final String SOURCE_ELEMENT = "source";
    public static final String TARGET_ELEMENT = "target";
    public static final String ELSE_IF_ELEMENT = "elseif";
    public static final String PARTNERLINKS_ELEMENT = "partnerLinks";
    public static final String PARTNERLINK_ELEMENT = "partnerLink";
    public static final String PARTNERLINK_ATTRIBUTE = "partnerLink";
    public static final String PARTNERLINKTYPE_ATTRIBUTE = "partnerLinkType";
    public static final String OPERATION_ATTRIBUTE = "operation";
    public static final String PORTTYPE_ATTRIBUTE = "portType";
    public static final String CATCH_ELEMENT = "catch";
    public static final String CATCHALL_ELEMENT = "catchAll";
    public static final String INT_VARIABLE_TYPE = "xsd:int";
    public static final String STRING_VARIABLE_TYPE = "xsd:string";
    public static final String FAULT_HANDLERS = "faultHandlers";
    public static final String COMPENSATION_HANDLER = "compensationHandler";
    public static final String SWITCH_CASE_ELEMENT = "case";
    public static final String SWITCH_OTHERWISE_ELEMENT = "otherwise";
    public static final String FOREACH_PARALLEL_ATTR = "parallel";
    public static final String CREATE_INSTANCE_ATTR = "createInstance";
    public static final String FOREACH_COUNTERNAME_ATTR = "counterName";
    public static final String FOREACH_COUNTER_STARTVALUE_ATTR = "startCounterValue";
    public static final String FOREACH_COUNTER_FINALVALUE_ATTR = "finalCounterValue";
    public static final String FOREACH_PARALLEL_ATTR_VALUE_YES = "yes";
    public static final String INPUTVARIABLE_ATTR = "inputVariable";
    public static final String PARTNERROLE_ATTR_AND_ELEMENT = "partnerRole";
    public static final String PART_ATTR = "part";
    public static final String VARIABLE_ATTR = "variable";
    public static final String TYPE_ATTR = "type";
    public static final String NAME_ATTR = "name";
    public static final String MESSAGETYPE_ATTR = "messageType";
    public static final String EXPRESSION_LANGUAGE_ATTR = "expressionLanguage";
    private static final String PREFIX_FOR_NEW_VARIABLE = "_zyx";
    public static int count = 0;
    public static Element process_element;

    public static Namespace getProcessNamespace() {
        return process_element.getNamespace();
    }

    public static String createVariableName() {
        return PREFIX_FOR_NEW_VARIABLE + count++;
    }

    public static Element createVariable(String name, String messageType, String type) {
        if (name == null) {
            name = BpelXMLTools.createVariableName();
        }
        Element variable = BpelXMLTools.createBPELElement("variable");
        if (type != null) {
            variable.setAttribute(TYPE_ATTR, type);
        }
        if (messageType != null) {
            variable.setAttribute(MESSAGETYPE_ATTR, messageType);
        }
        variable.setAttribute(NAME_ATTR, name);
        return variable;
    }

    public static Element insertNewStringVariable(String variableName, Element scope) {
        if (variableName == null) {
            variableName = BpelXMLTools.createVariableName();
        }
        Element variable = new Element("variable", BpelXMLTools.getProcessNamespace());
        variable.setAttribute(NAME_ATTR, variableName);
        variable.setAttribute(TYPE_ATTR, STRING_VARIABLE_TYPE);
        BpelXMLTools.insertVariable(variable, scope);
        return variable;
    }

    public static Element insertNewIntVariable(Element scope, String name) {
        if (name == null) {
            name = BpelXMLTools.createVariableName();
        }
        Element variable = BpelXMLTools.createBPELElement("variable");
        variable.setAttribute(NAME_ATTR, name);
        variable.setAttribute(TYPE_ATTR, INT_VARIABLE_TYPE);
        BpelXMLTools.insertVariable(variable, scope);
        return variable;
    }

    public static void insertVariable(Element variable, Element scope) {
        Element variables;
        if (scope == null) {
            scope = process_element;
        }
        if ((variables = scope.getChild(VARIABLES_ELEMENT, BpelXMLTools.getProcessNamespace())) == null) {
            variables = new Element(VARIABLES_ELEMENT, BpelXMLTools.getProcessNamespace());
            scope.addContent(0, variables);
        }
        List<Element> allVariables = JDomHelper.getChildren(variables, "variable", BpelXMLTools.getProcessNamespace());
        boolean exist = false;
        String variableName = variable.getAttributeValue(NAME_ATTR);
        for (Element element : allVariables) {
            if (!element.getAttributeValue(NAME_ATTR).equals(variableName)) continue;
            exist = true;
            break;
        }
        if (!exist) {
            variables.addContent(variable);
        }
    }

    public static Element encloseInSequence(Element activity) {
        Element parent = activity.getParentElement();
        int index = parent.indexOf(activity);
        Element sequence = BpelXMLTools.createSequence();
        sequence.addContent(activity.detach());
        parent.addContent(index, sequence);
        activity = sequence;
        return activity;
    }

    public static Element ensureElementIsInSequence(Element activity) {
        Element parent = activity.getParentElement();
        activity = parent.getName().equals("sequence") ? parent : BpelXMLTools.encloseInSequence(activity);
        return activity;
    }

    public static boolean isSequence(Element activity) {
        return activity.getName().equals("sequence");
    }

    public static Element getFirstEnclosedActivity(Element element) {
        Element activity = null;
        List<Element> children = JDomHelper.getElementsInContent(element);
        for (Element child : children) {
            if (!BpelXMLTools.isActivity(child)) continue;
            activity = child;
            break;
        }
        return activity;
    }

    public static boolean canCreateInstance(Element activity) {
        String value = activity.getAttributeValue(CREATE_INSTANCE_ATTR, "no");
        return FOREACH_PARALLEL_ATTR_VALUE_YES.equals(value);
    }

    public static Element encloseElementInFlow(Element activity) {
        Element parent = activity.getParentElement();
        int index = parent.indexOf(activity);
        Element flow = BpelXMLTools.createBPELElement("flow");
        activity.detach();
        flow.addContent(activity);
        parent.addContent(index, flow);
        return flow;
    }

    public static Element ensureElementIsInFlow(Element activity) {
        Element parent = activity.getParentElement();
        if (!parent.getName().equals("flow")) {
            activity = BpelXMLTools.encloseElementInFlow(activity);
        }
        return activity;
    }

    public static boolean isFlow(Element activity) {
        return activity.getName().equals("flow");
    }

    public static Element createSequence() {
        ++sequence_count;
        return new Element("sequence", BpelXMLTools.getProcessNamespace());
    }

    public static boolean isStructuredActivity(Element activity) {
        return StructuredActivities.isStructuredActivity(activity);
    }

    public static boolean isBasicActivity(Element activity) {
        return BasicActivities.isBasisActivity(activity);
    }

    public static boolean isActivity(Element element) {
        return BpelXMLTools.isBasicActivity(element) || BpelXMLTools.isStructuredActivity(element);
    }

    public static Element createInitializeAssign(Element countVariable) {
        Element assign = BpelXMLTools.createBPELElement(ASSIGN_ELEMENT);
        Element copy = BpelXMLTools.createBPELElement(COPY_ELEMENT);
        Element from = BpelXMLTools.createBPELElement(FROM_ELEMENT);
        Element to = BpelXMLTools.createBPELElement(TO_ELEMENT);
        Element literal = BpelXMLTools.createBPELElement(LITERAL_ELEMENT);
        literal.setText("0");
        from.addContent(literal);
        to.setAttribute("variable", countVariable.getAttributeValue(NAME_ATTR));
        copy.addContent(from);
        copy.addContent(to);
        assign.addContent(copy);
        return assign;
    }

    public static Element createIncreesAssign(Element countVariable) {
        Element assign = BpelXMLTools.createBPELElement(ASSIGN_ELEMENT);
        Element copy = BpelXMLTools.createBPELElement(COPY_ELEMENT);
        Element from = BpelXMLTools.createBPELElement(FROM_ELEMENT);
        Element to = BpelXMLTools.createBPELElement(TO_ELEMENT);
        from.setText(ExpressionLanguage.getInstance(0).valueOf(countVariable.getAttributeValue(NAME_ATTR)) + " + 1");
        to.setAttribute("variable", countVariable.getAttributeValue(NAME_ATTR));
        copy.addContent(from);
        copy.addContent(to);
        assign.addContent(copy);
        return assign;
    }

    public static Element insertElseBranch(Element element) {
        Element elseElement = BpelXMLTools.createBPELElement(ELSE_ELEMENT);
        element.addContent(elseElement);
        return elseElement;
    }

    public static Element createIfActivity(String conditionContent) {
        Element if_element = BpelXMLTools.createBPELElement(IF_ELEMENT);
        Element condition = BpelXMLTools.createBPELElement(CONDITION_ELEMENT);
        condition.setAttribute(EXPRESSION_LANGUAGE_ATTR, "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0");
        condition.setText(conditionContent);
        if_element.addContent(condition);
        return if_element;
    }

    public static Element createAssign(Element from, Element to) {
        Element assign = BpelXMLTools.createBPELElement(ASSIGN_ELEMENT);
        BpelXMLTools.addCopyElement(assign, from, to);
        return assign;
    }

    public static void addCopyElement(Element assign, Element from, Element to) {
        Element copy = BpelXMLTools.createBPELElement(COPY_ELEMENT);
        copy.addContent(from);
        copy.addContent(to);
        assign.addContent(copy);
    }

    public static void sysout(Element element) {
        XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
        try {
            xmlOutputter.output(element, (OutputStream)System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Element getSurroundScope(Content content) {
        Element scope = null;
        for (Element parent = content.getParentElement(); scope == null && parent != null; parent = parent.getParentElement()) {
            String name = parent.getName();
            if (!name.equals("scope") && !name.equals(PROCESS_ELEMENT)) continue;
            scope = parent;
            break;
        }
        return scope;
    }

    public static Element createBPELElement(String name) {
        if (name.equals("flow")) {
            ++flow_count;
        }
        if (name.equals("invoke")) {
            ++invoke_count;
        }
        return new Element(name, BpelXMLTools.getProcessNamespace());
    }

    public static boolean isFaultHandlers(Element element) {
        return element.getName().equals(FAULT_HANDLERS);
    }

    public static boolean isCompensationHandler(Element element) {
        return element.getName().equals(COMPENSATION_HANDLER);
    }

    public static List<Element> getCatchBlocks(Element faultHandler) {
        ArrayList<Element> catchBlocks = new ArrayList<Element>();
        List<Element> children = JDomHelper.getChildren(faultHandler, CATCH_ELEMENT, BpelXMLTools.getProcessNamespace());
        Iterator<Element> iter = children.iterator();
        while (iter.hasNext()) {
            catchBlocks.add(iter.next());
        }
        Element catchAll = faultHandler.getChild(CATCHALL_ELEMENT, BpelXMLTools.getProcessNamespace());
        if (catchAll != null) {
            catchBlocks.add(catchAll);
        }
        return catchBlocks;
    }

    public static Element insertOtherwiseBranch(Element element) {
        Element otherwiseElement = BpelXMLTools.createBPELElement(SWITCH_OTHERWISE_ELEMENT);
        element.addContent(otherwiseElement);
        return otherwiseElement;
    }
}

