/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.util;

import de.schlichtherle.io.File;
import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.FileWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.InputSource;

public class ParseUtil {
    private static Map<String, Document> fParsedDocuments = new HashMap<String, Document>();
    private static Map<String, Definition> fParsedDefinitions = new HashMap<String, Definition>();

    public static Document getJDOMDocument(String filename) throws IOException {
        Document document;
        FileInputStream is = null;
        File file = new File(filename);
        try {
            SAXBuilder builder = new SAXBuilder();
            is = new FileInputStream(file);
            document = builder.build(is);
        }
        catch (JDOMException e) {
            throw new IOException("Error while reading document from file \"" + file.getAbsolutePath() + "\".", e);
        }
        return document;
    }

    public static Document getJDOMDocument(String filename, boolean searchCache, boolean toCache) throws IOException {
        Document document;
        FileInputStream is = null;
        File file = new File(filename);
        if (searchCache && (document = fParsedDocuments.get(filename)) != null) {
            return document;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            is = new FileInputStream(file);
            document = builder.build(is);
        }
        catch (JDOMException e) {
            throw new IOException("Error while reading document from file \"" + file.getAbsolutePath() + "\".", e);
        }
        if (toCache) {
            fParsedDocuments.put(filename, document);
        }
        return document;
    }

    public static Definition getWsdlDefinition(String filename, boolean searchCache, boolean toCache) throws IOException {
        Definition definition;
        File wsdl = new File(filename);
        if (searchCache && (definition = fParsedDefinitions.get(filename)) != null) {
            return definition;
        }
        try {
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            InputSource source = new InputSource(new FileInputStream(wsdl));
            definition = reader.readWSDL(filename, source);
        }
        catch (WSDLException e) {
            throw new IOException("Error while reading definition from WSDL file \"" + wsdl.getAbsolutePath() + "\".", e);
        }
        catch (FileNotFoundException e) {
            throw new IOException(e);
        }
        if (toCache) {
            fParsedDefinitions.put(filename, definition);
        }
        return definition;
    }

    public static Definition getWsdlDefinition(String filename) throws IOException {
        Definition def;
        File wsdl = new File(filename);
        try {
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            InputSource source = new InputSource(new FileInputStream(wsdl));
            def = reader.readWSDL(filename, source);
        }
        catch (WSDLException e) {
            throw new IOException("Error while reading definition from WSDL file \"" + wsdl.getAbsolutePath() + "\".", e);
        }
        catch (FileNotFoundException e) {
            throw new IOException(e);
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocument(Document doc, String filename) throws IOException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(filename);
            XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
            xmlOutputter.output(doc, (Writer)writer);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

