/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.util;

import java.util.ArrayList;
import java.util.List;
import net.bpelunit.framework.control.util.BPELUnitUtil;
import net.bpelunit.framework.xml.suite.XMLActivity;
import net.bpelunit.framework.xml.suite.XMLCompleteHumanTaskActivity;
import net.bpelunit.framework.xml.suite.XMLCondition;
import net.bpelunit.framework.xml.suite.XMLHeaderProcessor;
import net.bpelunit.framework.xml.suite.XMLMapping;
import net.bpelunit.framework.xml.suite.XMLReceiveActivity;
import net.bpelunit.framework.xml.suite.XMLSendActivity;
import net.bpelunit.framework.xml.suite.XMLSoapActivity;
import net.bpelunit.framework.xml.suite.XMLTrack;
import net.bpelunit.framework.xml.suite.XMLTwoWayActivity;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityUtil {
    public static ActivityConstant getActivityConstant(Object presumedActivity) {
        if (!(presumedActivity instanceof XmlObject)) {
            return null;
        }
        XmlObject activity = (XmlObject)presumedActivity;
        Node node = activity.getDomNode();
        String localName = null;
        if (node == null) {
            return null;
        }
        localName = node.getLocalName();
        return ActivityConstant.getForXmlName(localName);
    }

    public static ActivityConstant[] getActivities() {
        return ActivityConstant.values();
    }

    public static List<ActivityConstant> getTopLevelSoapActivities() {
        ActivityConstant[] constants = ActivityConstant.values();
        ArrayList<ActivityConstant> list = new ArrayList<ActivityConstant>();
        for (int i = 0; i < constants.length; ++i) {
            if (constants[i].equals((Object)ActivityConstant.RECEIVE) || constants[i].equals((Object)ActivityConstant.SEND) || constants[i].equals((Object)ActivityConstant.COMPLETEHUMANTASK)) continue;
            list.add(constants[i]);
        }
        return list;
    }

    public static boolean isActivity(Object presumedActivity) {
        return presumedActivity instanceof XMLActivity;
    }

    public static boolean isActivity(Object presumedActivity, ActivityConstant constant) {
        String localName = ActivityUtil.getName(presumedActivity);
        if (localName == null) {
            return false;
        }
        return constant.getXmlName().equals(localName);
    }

    public static boolean isTwoWayActivity(Object presumedActivity) {
        return ActivityUtil.isActivity(presumedActivity, ActivityConstant.RECEIVE_SEND_SYNC) || ActivityUtil.isActivity(presumedActivity, ActivityConstant.SEND_RECEIVE_SYNC) || ActivityUtil.isActivity(presumedActivity, ActivityConstant.RECEIVE_SEND_ASYNC) || ActivityUtil.isActivity(presumedActivity, ActivityConstant.SEND_RECEIVE_ASYNC);
    }

    public static boolean isChildActivity(Object op) {
        return ActivityUtil.isActivity(op, ActivityConstant.RECEIVE) || ActivityUtil.isActivity(op, ActivityConstant.SEND);
    }

    public static boolean isAsynchronous(Object object) {
        return ActivityUtil.isActivity(object, ActivityConstant.SEND_RECEIVE_ASYNC) || ActivityUtil.isActivity(object, ActivityConstant.RECEIVE_SEND_ASYNC);
    }

    public static boolean isReceiveFirstActivity(XMLActivity activity) {
        return ActivityUtil.isActivity(activity, ActivityConstant.RECEIVE) || ActivityUtil.isActivity(activity, ActivityConstant.RECEIVE_ONLY) || ActivityUtil.isActivity(activity, ActivityConstant.RECEIVE_SEND_ASYNC) || ActivityUtil.isActivity(activity, ActivityConstant.RECEIVE_SEND_SYNC);
    }

    public static String getName(Object presumedActivity) {
        if (!(presumedActivity instanceof XMLActivity)) {
            return null;
        }
        XMLActivity activity = (XMLActivity)presumedActivity;
        Node node = activity.getDomNode();
        if (node == null) {
            return null;
        }
        return node.getLocalName();
    }

    public static String getNiceName(Object presumedActivity) {
        ActivityConstant constant = ActivityUtil.getActivityConstant(presumedActivity);
        if (constant == null) {
            return "Unknown activity";
        }
        return constant.getNiceName();
    }

    public static String getUIName(Object presumedActivity) {
        if (presumedActivity instanceof XMLSoapActivity && ActivityUtil.getParentActivityFor(presumedActivity) == null) {
            XMLSoapActivity xml = (XMLSoapActivity)presumedActivity;
            String operation = xml.getOperation();
            operation = operation != null ? operation : "n/a";
            return operation + " (" + ActivityUtil.getNiceName(presumedActivity) + ")";
        }
        if (presumedActivity instanceof XMLCompleteHumanTaskActivity) {
            XMLCompleteHumanTaskActivity xml = (XMLCompleteHumanTaskActivity)presumedActivity;
            return xml.getTaskName() + " (" + ActivityUtil.getNiceName(presumedActivity) + ")";
        }
        if (ActivityUtil.isActivity(presumedActivity)) {
            return ActivityUtil.getNiceName(presumedActivity);
        }
        if (presumedActivity instanceof XMLMapping) {
            return "Data Copy";
        }
        if (presumedActivity instanceof XMLHeaderProcessor) {
            return "Header Processor (" + ((XMLHeaderProcessor)presumedActivity).getName() + ")";
        }
        if (presumedActivity instanceof XMLCondition) {
            return "Condition (" + StringUtils.abbreviate(BPELUnitUtil.removeSpaceLineBreaks(((XMLCondition)presumedActivity).getExpression()), 100) + ")";
        }
        if (presumedActivity != null) {
            return presumedActivity.toString();
        }
        return "";
    }

    public static List<XMLActivity> getActivities(XMLTrack xmlClientTrack) {
        ArrayList<XMLActivity> activities = new ArrayList<XMLActivity>();
        XmlCursor newCursor = xmlClientTrack.newCursor();
        if (newCursor.toFirstChild()) {
            ActivityUtil.addActivity(activities, newCursor.getObject());
            while (newCursor.toNextSibling()) {
                ActivityUtil.addActivity(activities, newCursor.getObject());
            }
        }
        return activities;
    }

    public static XMLActivity getParentActivityFor(Object viewerSelection) {
        if (!(viewerSelection instanceof XmlObject)) {
            return null;
        }
        return ActivityUtil.getParentActivityForActivity((XmlObject)viewerSelection);
    }

    private static XMLActivity getParentActivityForActivity(XmlObject parent) {
        if (parent == null) {
            return null;
        }
        XmlCursor cursor = parent.newCursor();
        if (cursor.toParent()) {
            XmlObject newParent = cursor.getObject();
            if (newParent instanceof XMLActivity) {
                return (XMLActivity)newParent;
            }
            return ActivityUtil.getParentActivityForActivity(newParent);
        }
        return null;
    }

    public static XMLTrack getEnclosingTrack(XMLActivity activity) {
        XmlCursor c = activity.newCursor();
        while (c.toParent()) {
            XmlObject object = c.getObject();
            if (object == null) {
                return null;
            }
            if (!(object instanceof XMLTrack)) continue;
            return (XMLTrack)object;
        }
        return null;
    }

    public static boolean getReceiveFault(XMLActivity activity) {
        if (ActivityUtil.isTwoWayActivity(activity)) {
            return ((XMLTwoWayActivity)activity).getReceive().getFault();
        }
        return ActivityUtil.getSimpleFault(activity);
    }

    public static boolean getSendFault(XMLActivity activity) {
        if (ActivityUtil.isTwoWayActivity(activity)) {
            return ((XMLTwoWayActivity)activity).getSend().getFault();
        }
        return ActivityUtil.getSimpleFault(activity);
    }

    public static String getReceiveFaultString(XMLActivity activity) {
        if (ActivityUtil.isTwoWayActivity(activity)) {
            return ((XMLTwoWayActivity)activity).getReceive().getFaultstring();
        }
        return ActivityUtil.getSimpleFaultString(activity);
    }

    public static String getSendFaultString(XMLActivity activity) {
        if (ActivityUtil.isTwoWayActivity(activity)) {
            return ((XMLTwoWayActivity)activity).getSend().getFaultstring();
        }
        return ActivityUtil.getSimpleFaultString(activity);
    }

    private static boolean getSimpleFault(XMLActivity activity) {
        if (ActivityUtil.isActivity(activity, ActivityConstant.RECEIVE_ONLY) || ActivityUtil.isActivity(activity, ActivityConstant.RECEIVE)) {
            return ((XMLReceiveActivity)activity).getFault();
        }
        if (ActivityUtil.isActivity(activity, ActivityConstant.SEND_ONLY) || ActivityUtil.isActivity(activity, ActivityConstant.SEND)) {
            return ((XMLSendActivity)activity).getFault();
        }
        return false;
    }

    private static String getSimpleFaultString(XMLActivity activity) {
        if (ActivityUtil.isActivity(activity, ActivityConstant.RECEIVE_ONLY) || ActivityUtil.isActivity(activity, ActivityConstant.RECEIVE)) {
            return ((XMLReceiveActivity)activity).getFaultstring();
        }
        if (ActivityUtil.isActivity(activity, ActivityConstant.SEND_ONLY) || ActivityUtil.isActivity(activity, ActivityConstant.SEND)) {
            return ((XMLSendActivity)activity).getFaultstring();
        }
        return null;
    }

    public static void addActivity(List<XMLActivity> activities, XmlObject presumedActivity) {
        if (presumedActivity instanceof XMLActivity) {
            activities.add((XMLActivity)presumedActivity);
        }
    }

    public static XMLActivity createNewTopLevelActivity(XMLTrack toTrack, ActivityConstant type) {
        switch (type) {
            case RECEIVE_ONLY: {
                return toTrack.addNewReceiveOnly();
            }
            case RECEIVE_SEND_ASYNC: {
                return toTrack.addNewReceiveSendAsynchronous();
            }
            case RECEIVE_SEND_SYNC: {
                return toTrack.addNewReceiveSend();
            }
            case SEND_ONLY: {
                return toTrack.addNewSendOnly();
            }
            case SEND_RECEIVE_ASYNC: {
                return toTrack.addNewSendReceiveAsynchronous();
            }
            case SEND_RECEIVE_SYNC: {
                return toTrack.addNewSendReceive();
            }
        }
        return null;
    }

    public static int getIndexFor(Object[] objects, Object object) {
        for (int i = 0; i < objects.length; ++i) {
            if (!objects[i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    public static boolean hasPrevious(XmlObject someObject) {
        return someObject.newCursor().toPrevSibling();
    }

    public static boolean hasNext(XmlObject someObject) {
        return someObject.newCursor().toNextSibling();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ActivityConstant {
        SEND_ONLY("sendOnly", "Send Asynchronous"),
        RECEIVE_ONLY("receiveOnly", "Receive Asynchronous"),
        SEND_RECEIVE_SYNC("sendReceive", "Send/Receive Synchronous"),
        RECEIVE_SEND_SYNC("receiveSend", "Receive/Send Synchronous"),
        SEND_RECEIVE_ASYNC("sendReceiveAsynchronous", "Send/Receive Asynchronous"),
        RECEIVE_SEND_ASYNC("receiveSendAsynchronous", "Receive/Send Asynchronous"),
        SEND("send", "Send"),
        RECEIVE("receive", "Receive"),
        WAIT("wait", "Wait"),
        COMPLETEHUMANTASK("completeHumanTask", "Complete Human Task");

        private String fXmlName;
        private String fNiceName;

        private ActivityConstant(String name, String niceName) {
            this.fXmlName = name;
            this.fNiceName = niceName;
        }

        public String getNiceName() {
            return this.fNiceName;
        }

        public String getXmlName() {
            return this.fXmlName;
        }

        public static ActivityConstant getForXmlName(String xmlName) {
            ActivityConstant[] values = ActivityConstant.values();
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].getXmlName().equals(xmlName)) continue;
                return values[i];
            }
            return null;
        }

        public static ActivityConstant getForNiceName(String niceName) {
            ActivityConstant[] values = ActivityConstant.values();
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].getNiceName().equals(niceName)) continue;
                return values[i];
            }
            return null;
        }
    }
}

