/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.soap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import net.bpelunit.framework.control.ext.IHeaderProcessor;
import net.bpelunit.framework.control.ext.SendPackage;
import net.bpelunit.framework.exception.HeaderProcessingException;
import net.bpelunit.framework.model.test.activity.ActivityContext;

public class WSAHeaderProcessor
implements IHeaderProcessor {
    static final String WSA_NAMESPACE = "http://schemas.xmlsoap.org/ws/2003/03/addressing";
    static final String WSA_TAG_RELATES_TO = "RelatesTo";
    static final String WSA_TAG_ADDRESS = "Address";
    static final String WSA_TAG_REPLY_TO = "ReplyTo";
    static final String WSA_TAG_MESSAGE_ID = "MessageID";
    static final String WSA_RECEIVED = "WSA-Received";
    static final String WSA_RECEIVED_ADDRESS = "WSA-Received-Address";
    static final String WSA_RECEIVED_ID = "WSA-Received-ID";
    static final String WSA_SENT = "WSA-Sent";
    static final String WSA_SENT_ID = "WSA-Sent-ID";
    static final String WSA_MESSAGE_ID_PREFIX = "http://www.bpelunit.net/wsa/messageId/";
    private Map<String, String> fProperties = new HashMap<String, String>();

    public void processReceive(ActivityContext context, SOAPMessage message) throws HeaderProcessingException {
        if (context.getUserData(WSA_SENT).equals("true")) {
            SOAPHeader header = this.getHeader(message, "Incoming");
            String relatesToID = this.getRelatesToID(header);
            context.setUserData(WSA_RECEIVED_ID, relatesToID);
            context.setUserData("Message-ID-Receive", relatesToID);
        } else {
            SOAPHeader header = this.getHeader(message, "Incoming");
            context.setUserData(WSA_RECEIVED, "true");
            String messageID = this.getMessageID(header);
            context.setUserData(WSA_RECEIVED_ID, messageID);
            context.setUserData("Message-ID-Receive", messageID);
            context.setUserData(WSA_RECEIVED_ADDRESS, this.getEndpointURL(header, WSA_TAG_REPLY_TO));
        }
    }

    public void processSend(ActivityContext context, SendPackage sendSpec) throws HeaderProcessingException {
        if (context.getUserData(WSA_RECEIVED).equals("true")) {
            SOAPHeader header = this.getHeader(sendSpec.getSoapMessage(), "Outgoing");
            String messageID = this.getRequiredUserData(context, WSA_RECEIVED_ID, "Message ID from presumed receive was empty.");
            if (!"".equals(messageID)) {
                this.addRelatesToHeader(header, messageID);
            }
            String targetURL = this.getRequiredUserData(context, WSA_RECEIVED_ADDRESS, "Target URL from presumed receive was empty.");
            sendSpec.setTargetURL(targetURL);
        } else {
            SOAPHeader header = this.getHeader(sendSpec.getSoapMessage(), "Outgoing");
            String id = this.addMessageID(header);
            this.addReplyTo(header, context);
            context.setUserData(WSA_SENT, "true");
            context.setUserData(WSA_SENT_ID, id);
            context.setUserData("Message-ID-Sent", id);
        }
    }

    public void setProperty(String name, String stringValue) {
        this.fProperties.put(name, stringValue);
    }

    private String addMessageID(SOAPHeader header) throws HeaderProcessingException {
        try {
            String id = null;
            id = this.fProperties.containsKey(WSA_TAG_MESSAGE_ID) ? this.fProperties.get(WSA_TAG_MESSAGE_ID) : WSA_MESSAGE_ID_PREFIX + UUID.randomUUID().toString();
            SOAPElement msgId = header.addChildElement(this.wsaQName(WSA_TAG_MESSAGE_ID));
            msgId.setTextContent(id);
            return id;
        }
        catch (SOAPException e) {
            throw new HeaderProcessingException("Could not add MessageID header to outgoing SOAP message.", e);
        }
    }

    private void addRelatesToHeader(SOAPHeader header, String messageID) throws HeaderProcessingException {
        SOAPElement msgId;
        try {
            msgId = header.addChildElement(this.wsaQName(WSA_TAG_RELATES_TO));
        }
        catch (SOAPException e) {
            throw new HeaderProcessingException("Could not add RelatesTo header to outgoing SOAP message.", e);
        }
        msgId.setTextContent(messageID);
    }

    private void addReplyTo(SOAPHeader header, ActivityContext context) throws HeaderProcessingException {
        try {
            SOAPElement replyTo = header.addChildElement(this.wsaQName(WSA_TAG_REPLY_TO));
            SOAPElement address = replyTo.addChildElement(this.wsaQName(WSA_TAG_ADDRESS));
            address.setTextContent(context.getPartnerURL());
        }
        catch (SOAPException e) {
            throw new HeaderProcessingException("Could not add ReplyTo header to outgoing SOAP message.", e);
        }
    }

    private String getEndpointURL(SOAPHeader header, String wsaTagName) throws HeaderProcessingException {
        String replyTo = null;
        Iterator i = header.getChildElements(this.wsaQName(wsaTagName));
        while (i.hasNext()) {
            SOAPElement soapElement = (SOAPElement)i.next();
            Iterator j = soapElement.getChildElements(this.wsaQName(WSA_TAG_ADDRESS));
            while (j.hasNext()) {
                SOAPElement soapElement2 = (SOAPElement)j.next();
                replyTo = soapElement2.getTextContent();
            }
        }
        if (replyTo == null) {
            throw new HeaderProcessingException(wsaTagName + " address not found in incoming message.");
        }
        return replyTo;
    }

    private SOAPHeader getHeader(SOAPMessage message, String msgDirection) throws HeaderProcessingException {
        SOAPHeader header;
        try {
            header = message.getSOAPHeader();
        }
        catch (SOAPException e) {
            throw new HeaderProcessingException(msgDirection + " SOAP message did not have a SOAP Header.", e);
        }
        return header;
    }

    private String getMessageID(SOAPHeader header) {
        String messageID = "";
        Iterator i = header.getChildElements(this.wsaQName(WSA_TAG_MESSAGE_ID));
        while (i.hasNext()) {
            SOAPElement soapElement = (SOAPElement)i.next();
            messageID = soapElement.getTextContent();
        }
        return messageID;
    }

    private String getRelatesToID(SOAPHeader header) throws HeaderProcessingException {
        String relatesTo = null;
        Iterator itRelatesTo = header.getChildElements(this.wsaQName(WSA_TAG_RELATES_TO));
        while (itRelatesTo.hasNext()) {
            SOAPElement soapE = (SOAPElement)itRelatesTo.next();
            relatesTo = soapE.getTextContent();
        }
        if (relatesTo == null) {
            throw new HeaderProcessingException("No RelatesTo header found in the incoming message");
        }
        return relatesTo;
    }

    private String getRequiredUserData(ActivityContext context, String name, String msgIfMissing) throws HeaderProcessingException {
        String targetURL = context.getUserData(name);
        if (targetURL == null) {
            throw new HeaderProcessingException(msgIfMissing);
        }
        return targetURL;
    }

    private QName wsaQName(String localPart) {
        return new QName(WSA_NAMESPACE, localPart);
    }
}

