/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.soap;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import net.bpelunit.framework.control.ext.IHeaderProcessor;
import net.bpelunit.framework.control.ext.SendPackage;
import net.bpelunit.framework.exception.HeaderProcessingException;
import net.bpelunit.framework.model.test.activity.ActivityContext;

public class OdeHeaderProcessor
implements IHeaderProcessor {
    private static final String KEY_ODE_SENT = "ODE-header-sent";
    private static final String KEY_ODE_RECEIVED = "ODE-header-received";
    private static final String KEY_ODE_SESSION_ID = "ODE-session-id";
    private static final String KEY_ODE_RECEIVED_ADDRESS = "ode-address-received";
    private static final String ODE_SESSION = OdeHeaderProcessor.generateId();
    private static final QName ELEMENT_ODE_CALLBACK = new QName("http://www.intalio.com/type/session", "callback");
    private static final QName ELEMENT_ODE_SESSION = new QName("http://www.intalio.com/type/session", "session");
    private static final QName ELEMENT_WSA_ADDRESS = new QName("http://www.w3.org/2005/08/addressing", "Address");

    public void processReceive(ActivityContext context, SOAPMessage message) throws HeaderProcessingException {
        if (context.getUserData(KEY_ODE_SENT).equals("true")) {
            context.setUserData(KEY_ODE_SENT, null);
        } else {
            SOAPHeader header;
            try {
                header = message.getSOAPHeader();
            }
            catch (SOAPException e) {
                throw new HeaderProcessingException("Incoming SOAP message did not have a SOAP Header.", e);
            }
            SOAPElement callBackHeader = null;
            Iterator i = header.getChildElements(ELEMENT_ODE_CALLBACK);
            while (i.hasNext()) {
                callBackHeader = (SOAPElement)i.next();
            }
            if (callBackHeader != null) {
                SOAPElement wsaAddress = null;
                Iterator i2 = callBackHeader.getChildElements(ELEMENT_WSA_ADDRESS);
                while (i2.hasNext()) {
                    wsaAddress = (SOAPElement)i2.next();
                }
                if (wsaAddress == null) {
                    throw new HeaderProcessingException("There was no WS-Addressing Address Element in the ODE/Intalio header.");
                }
                String replyTo = wsaAddress.getTextContent();
                SOAPElement odeSession = null;
                Iterator i3 = callBackHeader.getChildElements(ELEMENT_ODE_SESSION);
                while (i3.hasNext()) {
                    odeSession = (SOAPElement)i3.next();
                }
                if (odeSession == null) {
                    throw new HeaderProcessingException("There was no ODE Session in the ODE/Intalio header.");
                }
                String sessionId = wsaAddress.getTextContent();
                context.setUserData(KEY_ODE_RECEIVED, "true");
                context.setUserData(KEY_ODE_SESSION_ID, sessionId);
                context.setUserData(KEY_ODE_RECEIVED_ADDRESS, replyTo);
            }
        }
    }

    public void processSend(ActivityContext context, SendPackage message) throws HeaderProcessingException {
        message.getSoapMessage();
        if (context.getUserData(KEY_ODE_RECEIVED).equals("true")) {
            context.setUserData(KEY_ODE_RECEIVED, null);
            String targetURL = context.getUserData(KEY_ODE_RECEIVED_ADDRESS);
            String sessionId = context.getUserData(KEY_ODE_SESSION_ID);
            if (targetURL == null) {
                throw new HeaderProcessingException("Target URL from presumed receive was empty.");
            }
            if (sessionId == null) {
                throw new HeaderProcessingException("Session ID from presumed receive was empty.");
            }
            SOAPMessage msg = message.getSoapMessage();
            SOAPHeader header = null;
            try {
                header = msg.getSOAPHeader();
            }
            catch (SOAPException e) {
                throw new HeaderProcessingException("No SOAP header in outgoing SOAP message.", e);
            }
            if (!sessionId.equals("")) {
                try {
                    SOAPElement sessionElement = header.addChildElement(ELEMENT_ODE_CALLBACK).addChildElement(ELEMENT_ODE_SESSION);
                    sessionElement.setTextContent(sessionId);
                }
                catch (SOAPException e) {
                    throw new HeaderProcessingException("Could not add relatesTo child element to outgoing SOAP message.", e);
                }
            }
            message.setTargetURL(targetURL);
        } else {
            SOAPHeader header;
            SOAPMessage msg = message.getSoapMessage();
            try {
                header = msg.getSOAPHeader();
            }
            catch (SOAPException e) {
                throw new HeaderProcessingException("No SOAP header in outgoing SOAP message.", e);
            }
            try {
                SOAPElement odeHeaderElement = header.addChildElement(ELEMENT_ODE_CALLBACK);
                SOAPElement address = odeHeaderElement.addChildElement(ELEMENT_WSA_ADDRESS);
                address.setTextContent(context.getPartnerURL());
                String id = ODE_SESSION;
                SOAPElement sesionId = odeHeaderElement.addChildElement(ELEMENT_ODE_SESSION);
                sesionId.setTextContent(id);
                context.setUserData(KEY_ODE_SENT, "true");
                context.setUserData(KEY_ODE_SESSION_ID, id);
            }
            catch (SOAPException e) {
                throw new HeaderProcessingException("Could not add MessageID, ReplyTo or Address child element to outgoing SOAP message.", e);
            }
        }
    }

    private static String generateId() {
        return "BPELUNIT-" + Math.random() * 9.223372036854776E18 + "-" + Math.random() * 9.223372036854776E18;
    }

    public void setProperty(String name, String value) {
    }
}

