/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.deploy.ode;

import de.schlichtherle.io.ArchiveException;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.soap.SOAPException;
import net.bpelunit.framework.control.deploy.ode.ODEDeployment;
import net.bpelunit.framework.control.deploy.ode.ODERequestEntityFactory;
import net.bpelunit.framework.control.ext.IBPELDeployer;
import net.bpelunit.framework.control.ext.IDeployment;
import net.bpelunit.framework.control.util.JDomHelper;
import net.bpelunit.framework.control.util.NoPersistenceConnectionManager;
import net.bpelunit.framework.exception.DeploymentException;
import net.bpelunit.framework.model.Partner;
import net.bpelunit.framework.model.ProcessUnderTest;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.filter.ElementFilter;
import org.jdom.input.SAXBuilder;

@IBPELDeployer.IBPELDeployerCapabilities(canDeploy=true, canMeasureTestCoverage=false)
public class ODEDeployer
implements IBPELDeployer {
    private Logger fLogger = Logger.getLogger(this.getClass());
    private String fProcessId;
    private String fArchive;
    private String fDeploymentAdminServiceURL;
    private ODERequestEntityFactory fFactory = ODERequestEntityFactory.newInstance();

    @IBPELDeployer.IBPELDeployerOption(testSuiteSpecific=true)
    public void setDeploymentArchive(String archive) {
        this.fArchive = archive;
    }

    @IBPELDeployer.IBPELDeployerOption(defaultValue="http://localhost:8080/ode/processes/DeploymentService")
    public void setODEDeploymentServiceURL(String deploymentAdminServiceURL) {
        this.fDeploymentAdminServiceURL = deploymentAdminServiceURL;
    }

    public void deploy(String pathToTest, ProcessUnderTest put) throws DeploymentException {
        String responseBody;
        RequestEntity re;
        File uploadingFile;
        this.fLogger.info("ODE deployer got request to deploy " + put);
        this.check(this.fArchive, "Archive Location");
        this.check(this.fDeploymentAdminServiceURL, "deployment admin server URL");
        boolean archiveCreated = false;
        String archivePath = this.getArchiveLocation(pathToTest);
        if (!FilenameUtils.getName(archivePath).endsWith(".zip")) {
            de.schlichtherle.io.File dir = new de.schlichtherle.io.File(archivePath);
            if (dir.isDirectory()) {
                de.schlichtherle.io.File zipFile = new de.schlichtherle.io.File(dir.getAbsolutePath() + ".zip");
                dir.copyAllTo(zipFile);
                archivePath = zipFile.getAbsolutePath();
                this.fArchive = this.fArchive + ".zip";
                try {
                    de.schlichtherle.io.File.umount(true, true, true, true);
                }
                catch (ArchiveException e) {
                    throw new DeploymentException("Could not convert to zip deployment format", e);
                }
                archiveCreated = true;
            } else {
                throw new DeploymentException("Unknown archive format for the archive " + this.fArchive);
            }
        }
        if (!(uploadingFile = new File(archivePath)).exists()) {
            throw new DeploymentException("ODE deployer could not find zip file " + this.fArchive);
        }
        HttpClient client = new HttpClient(new NoPersistenceConnectionManager());
        PostMethod method = new PostMethod(this.fDeploymentAdminServiceURL);
        try {
            re = this.fFactory.getDeployRequestEntity(uploadingFile);
        }
        catch (IOException e) {
            throw new DeploymentException("Problem while creating SOAP request: " + e.getMessage(), e);
        }
        catch (SOAPException e) {
            throw new DeploymentException("Problem while creating SOAP request: " + e.getMessage(), (Exception)((Object)e));
        }
        method.setRequestEntity(re);
        this.fLogger.info("ODE deployer about to send SOAP request to deploy " + put);
        method.getParams().setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler(1, false));
        method.addRequestHeader("SOAPAction", "");
        try {
            int statusCode = client.executeMethod(method);
            responseBody = method.getResponseBodyAsString();
            if (statusCode < 200 || statusCode > 299) {
                throw new DeploymentException("ODE Server reported a Deployment Error: " + responseBody);
            }
        }
        catch (HttpException e) {
            throw new DeploymentException("Problem contacting the ODE Server: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new DeploymentException("Problem contacting the ODE Server: " + e.getMessage(), e);
        }
        finally {
            method.releaseConnection();
            if (uploadingFile.exists() && archiveCreated) {
                uploadingFile.delete();
            }
        }
        try {
            this.fProcessId = this.extractProcessId(responseBody);
        }
        catch (IOException e) {
            throw new DeploymentException("Problem extracting deployment information: " + e.getMessage(), e);
        }
    }

    public void undeploy(String testPath, ProcessUnderTest put) throws DeploymentException {
        RequestEntity re;
        HttpClient client = new HttpClient(new NoPersistenceConnectionManager());
        PostMethod method = new PostMethod(this.fDeploymentAdminServiceURL);
        try {
            re = this.fFactory.getUndeployRequestEntity(this.fProcessId);
        }
        catch (IOException e) {
            throw new DeploymentException("Problem while creating SOAP request: " + e.getMessage(), e);
        }
        catch (SOAPException e) {
            throw new DeploymentException("Problem while creating SOAP request: " + e.getMessage(), (Exception)((Object)e));
        }
        method.setRequestEntity(re);
        this.fLogger.info("ODE deployer about to send SOAP request to undeploy " + put);
        method.getParams().setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler(1, false));
        method.addRequestHeader("SOAPAction", "");
        try {
            int statusCode = client.executeMethod(method);
            String responseBody = method.getResponseBodyAsString();
            if (statusCode < 200 || statusCode > 299) {
                throw new DeploymentException("ODE Server reported a undeployment Error: " + responseBody);
            }
        }
        catch (HttpException e) {
            throw new DeploymentException("Problem contacting the ODE Server: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new DeploymentException("Problem contacting the ODE Server: " + e.getMessage(), e);
        }
        finally {
            method.releaseConnection();
        }
    }

    public IDeployment getDeployment(ProcessUnderTest put) throws DeploymentException {
        Map<String, Partner> partnerList = put.getPartners();
        Partner[] partners = new Partner[partnerList.values().size()];
        partners = new ArrayList<Partner>(partnerList.values()).toArray(partners);
        if (partners == null || this.fArchive == null) {
            throw new DeploymentException("Problem creating ODEDeployment: ", null);
        }
        ODEDeployment deployment = new ODEDeployment(partners, this.getArchiveLocation(put.getBasePath()));
        return deployment;
    }

    public String getArchiveLocation(String pathToTest) {
        String pathToArchive = FilenameUtils.concat(pathToTest, FilenameUtils.getFullPath(this.fArchive));
        String archiveName = FilenameUtils.getName(this.fArchive);
        return FilenameUtils.concat(pathToArchive, archiveName);
    }

    public void setArchiveLocation(String archive) {
        this.fArchive = archive;
    }

    private String extractProcessId(String responseBody) throws IOException {
        SAXBuilder builder = new SAXBuilder();
        String processId = null;
        try {
            Document doc = builder.build(new StringReader(responseBody));
            Element envelope = doc.getRootElement();
            Iterator<Element> it = JDomHelper.getDescendants(envelope, new ElementFilter("name"));
            Element idElement = it.next();
            processId = idElement.getTextNormalize();
        }
        catch (JDOMException e) {
            throw new IOException(e);
        }
        return processId;
    }

    private void check(String toCheck, String description) throws DeploymentException {
        if (toCheck == null) {
            throw new DeploymentException("ODE deployment configuration is missing the " + description + ".");
        }
    }

    public void cleanUpAfterTestCase() throws Exception {
    }
}

