/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.deploy.activebpel;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import net.bpelunit.framework.control.util.BPELUnitUtil;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.w3c.dom.DOMException;

public abstract class ActiveBPELRequestEntityBase
implements RequestEntity {
    public static final String NS_XMLSCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String NS_XMLSCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String NS_ACTIVEBPEL_ADMIN = "http://schemas.active-endpoints.com/activebpeladmin/2007/01/activebpeladmin.xsd";
    public static final String NS_SOAP_ENCODING = "http://schemas.xmlsoap.org/soap/encoding/";
    private SOAPMessage message;
    private byte[] bytesMessage;

    public long getContentLength() {
        return this.bytesMessage.length;
    }

    public String getContentType() {
        return "text/xml";
    }

    public boolean isRepeatable() {
        return true;
    }

    public void writeRequest(OutputStream out) throws IOException {
        out.write(this.bytesMessage);
    }

    private SOAPMessage createEmptyMessage() throws SOAPException {
        MessageFactory mFactory = BPELUnitUtil.getMessageFactoryInstance();
        SOAPMessage message = mFactory.createMessage();
        return message;
    }

    protected SOAPElement addRootElement(SOAPMessage message, QName name) throws SOAPException {
        SOAPBody body = message.getSOAPBody();
        SOAPElement rootElement = body.addChildElement(name);
        rootElement.setEncodingStyle(NS_SOAP_ENCODING);
        rootElement.addNamespaceDeclaration("xsi", NS_XMLSCHEMA_INSTANCE);
        rootElement.addNamespaceDeclaration("xsd", NS_XMLSCHEMA);
        rootElement.addNamespaceDeclaration("act", NS_ACTIVEBPEL_ADMIN);
        return rootElement;
    }

    protected void createMessage() throws IOException, SOAPException {
        this.message = this.createEmptyMessage();
        this.populateMessage(this.message);
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        this.message.writeTo((OutputStream)b);
        this.bytesMessage = b.toByteArray();
    }

    protected abstract void populateMessage(SOAPMessage var1) throws SOAPException, DOMException, IOException;
}

