/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.crypto.io.raes;

import de.schlichtherle.crypto.io.CipherReadOnlyFile;
import de.schlichtherle.crypto.io.raes.RaesAuthenticationException;
import de.schlichtherle.crypto.io.raes.RaesException;
import de.schlichtherle.crypto.io.raes.RaesParameters;
import de.schlichtherle.crypto.io.raes.RaesParametersAgent;
import de.schlichtherle.crypto.io.raes.RaesParametersException;
import de.schlichtherle.crypto.io.raes.Type0RaesParameters;
import de.schlichtherle.crypto.io.raes.Type0RaesReadOnlyFile;
import de.schlichtherle.io.rof.ReadOnlyFile;
import de.schlichtherle.io.rof.SimpleReadOnlyFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public abstract class RaesReadOnlyFile
extends CipherReadOnlyFile {
    static short readUByte(byte[] b, int off) {
        return (short)(b[off] & 0xFF);
    }

    static int readUShort(byte[] b, int off) {
        return (b[off + 1] & 0xFF) << 8 | b[off] & 0xFF;
    }

    static long readUInt(byte[] b, int off) {
        off += 3;
        long v = (long)b[off--] & 0xFFL;
        v <<= 8;
        v |= (long)b[off--] & 0xFFL;
        v <<= 8;
        v |= (long)b[off--] & 0xFFL;
        v <<= 8;
        return v |= (long)b[off] & 0xFFL;
    }

    public static RaesReadOnlyFile getInstance(File file, RaesParameters parameters) throws FileNotFoundException, RaesParametersException, RaesException, IOException {
        SimpleReadOnlyFile rof = new SimpleReadOnlyFile(file);
        try {
            return RaesReadOnlyFile.getInstance(rof, parameters);
        }
        catch (IOException failure) {
            rof.close();
            throw failure;
        }
    }

    public static RaesReadOnlyFile getInstance(ReadOnlyFile rof, RaesParameters parameters) throws FileNotFoundException, RaesParametersException, RaesException, IOException {
        byte[] leadIn = new byte[5];
        rof.seek(0L);
        rof.readFully(leadIn);
        if (RaesReadOnlyFile.readUInt(leadIn, 0) != 1397047634L) {
            throw new RaesException("No RAES signature!");
        }
        short type = RaesReadOnlyFile.readUByte(leadIn, 4);
        switch (type) {
            case 0: {
                parameters = RaesReadOnlyFile.findParameters(Type0RaesParameters.class, parameters);
                return new Type0RaesReadOnlyFile(rof, (Type0RaesParameters)parameters);
            }
        }
        throw new RaesException("Unknown RAES type: " + type);
    }

    private static RaesParameters findParameters(Class type, RaesParameters parameters) throws RaesParametersException {
        if (parameters == null) {
            throw new RaesParametersException();
        }
        if (type.isAssignableFrom(parameters.getClass())) {
            return parameters;
        }
        if (parameters instanceof RaesParametersAgent) {
            return RaesReadOnlyFile.findParameters(type, ((RaesParametersAgent)parameters).getParameters(type));
        }
        throw new RaesParametersException();
    }

    RaesReadOnlyFile(ReadOnlyFile rof) {
        super(rof);
    }

    public abstract int getKeySizeBits();

    public abstract void authenticate() throws RaesAuthenticationException, IOException;
}

