/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.client.model;

import net.bpelunit.framework.client.eclipse.BPELUnitActivator;
import net.bpelunit.framework.model.test.TestSuite;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class TestRunSession {
    private ILaunch fLaunch;
    private TestSuite fSuite;
    private boolean fAborted;

    public TestRunSession(TestSuite suite, ILaunch launch) {
        this.fSuite = suite;
        this.fLaunch = launch;
        this.fAborted = false;
    }

    public TestSuite getSuite() {
        return this.fSuite;
    }

    public void stopTest() {
        if (!this.fAborted) {
            this.fSuite.abortTest();
        }
        this.fAborted = true;
    }

    public void relaunchTest() {
        this.stopTest();
        new Thread(new Runnable(){

            @Override
            public void run() {
                ILaunchConfiguration launchConfiguration = TestRunSession.this.fLaunch.getLaunchConfiguration();
                if (launchConfiguration != null) {
                    try {
                        ILaunchConfigurationWorkingCopy tmp = launchConfiguration.copy(String.valueOf(launchConfiguration.getName()) + "_copy");
                        tmp.launch("run", null);
                    }
                    catch (CoreException e) {
                        BPELUnitActivator.log(e);
                    }
                }
            }
        }).start();
    }

    public boolean isAbortedByUser() {
        return this.fAborted;
    }
}

