/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.client.eclipse.views;

import net.bpelunit.framework.client.eclipse.views.BPELUnitProgressBar;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ProgressPanel
extends Composite {
    private Label fInfoLabel;
    private BPELUnitProgressBar fProgressBar;
    private String fLabelText;
    private int fCurrentStep;
    private int fMaxStep;
    private boolean fHasError;

    public ProgressPanel(Composite parent, String labeltext) {
        super(parent, 64);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.fLabelText = labeltext;
        this.fInfoLabel = new Label(parent, 0);
        this.fInfoLabel.setText(String.valueOf(this.fLabelText) + ": 0/0");
        this.fInfoLabel.setLayoutData((Object)new GridData(768));
        this.fProgressBar = new BPELUnitProgressBar(parent);
        this.fProgressBar.setLayoutData(new GridData(768));
    }

    public void reset() {
        this.reset(0);
    }

    public void reset(int max) {
        this.fCurrentStep = 0;
        this.fMaxStep = max;
        this.fHasError = false;
        this.fProgressBar.reset(false, false, 0, max);
        this.updateLabel();
    }

    public void stepForward(boolean hasError) {
        ++this.fCurrentStep;
        if (hasError) {
            this.fHasError = true;
        }
        this.fProgressBar.step(this.fHasError ? 1 : 0);
        this.fProgressBar.refresh();
        this.updateLabel();
    }

    public void abort() {
        this.fProgressBar.stopped();
    }

    private void updateLabel() {
        this.fInfoLabel.setText(String.valueOf(this.fLabelText) + ": " + Integer.toString(this.fCurrentStep) + "/" + Integer.toString(this.fMaxStep));
    }
}

