/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.client.eclipse.views;

import java.util.List;
import net.bpelunit.framework.model.test.data.XMLData;
import net.bpelunit.framework.model.test.report.ITestArtefact;
import net.bpelunit.framework.model.test.report.StateData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.part.PageBook;

public class DetailPane {
    private PageBook fViewerbook;
    private Composite fTextComposite;
    private Text fXmlText;
    private TableViewer fTable;
    private Color fWhite;
    private ITestArtefact fTestElement;

    public DetailPane(Composite parent, ToolBar toolBar) {
        this.fViewerbook = new PageBook(parent, 0);
        this.fTextComposite = new Composite((Composite)this.fViewerbook, 0);
        this.fTextComposite.setLayout((Layout)new GridLayout());
        Label xmlDataLabel = new Label(this.fTextComposite, 16384);
        xmlDataLabel.setLayoutData((Object)new GridData(768));
        xmlDataLabel.setText("XML Data:");
        this.fWhite = new Color((Device)parent.getShell().getDisplay(), 255, 255, 255);
        this.fXmlText = new Text(this.fTextComposite, 2826);
        this.fXmlText.setBackground(this.fWhite);
        this.fXmlText.setLayoutData((Object)new GridData(1808));
        this.fTable = new TableViewer((Composite)this.fViewerbook, 772);
        this.fTable.getTable().setHeaderVisible(true);
        this.fTable.setLabelProvider((IBaseLabelProvider)new StateDataLabelProvider());
        this.fTable.setContentProvider((IContentProvider)new StateDataContentProvider());
        TableColumn keyColumn = new TableColumn(this.fTable.getTable(), 16384);
        keyColumn.setText("Key");
        keyColumn.setWidth(100);
        TableColumn valueColumn = new TableColumn(this.fTable.getTable(), 16384);
        valueColumn.setText("Value");
        valueColumn.setWidth(400);
        this.fViewerbook.showPage((Control)this.fTextComposite);
    }

    public void dispose() {
        this.fWhite.dispose();
    }

    public Control getComposite() {
        return this.fViewerbook;
    }

    public void setArtefact(ITestArtefact testElement) {
        this.fTestElement = testElement;
        if (this.fTestElement instanceof XMLData) {
            this.fXmlText.setText(((XMLData)this.fTestElement).getXmlData());
            this.fViewerbook.showPage((Control)this.fTextComposite);
        } else {
            this.fTable.setInput((Object)testElement.getStateData());
            this.fViewerbook.showPage((Control)this.fTable.getTable());
        }
    }

    class StateDataContentProvider
    implements IStructuredContentProvider {
        StateDataContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class StateDataLabelProvider
    implements ITableLabelProvider {
        StateDataLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((StateData)element).getKey();
            }
            return ((StateData)element).getValue();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

