/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.client.eclipse.views;

import java.util.HashMap;
import java.util.Map;
import net.bpelunit.framework.client.eclipse.BPELUnitActivator;
import net.bpelunit.framework.client.eclipse.views.CounterPanel;
import net.bpelunit.framework.client.eclipse.views.DetailPane;
import net.bpelunit.framework.client.eclipse.views.ProgressPanel;
import net.bpelunit.framework.client.eclipse.views.TestSessionLabelProvider;
import net.bpelunit.framework.client.eclipse.views.TestSessionTreeContentProvider;
import net.bpelunit.framework.client.model.TestRunSession;
import net.bpelunit.framework.model.test.ITestResultListener;
import net.bpelunit.framework.model.test.PartnerTrack;
import net.bpelunit.framework.model.test.TestCase;
import net.bpelunit.framework.model.test.activity.Activity;
import net.bpelunit.framework.model.test.data.ReceiveCondition;
import net.bpelunit.framework.model.test.data.ReceiveDataSpecification;
import net.bpelunit.framework.model.test.data.SendDataSpecification;
import net.bpelunit.framework.model.test.report.ArtefactStatus;
import net.bpelunit.framework.model.test.report.ITestArtefact;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class BPELUnitView
extends ViewPart
implements ITestResultListener {
    private Map<ArtefactStatus.StatusCode, Image> fTestCaseIcons;
    private Map<ArtefactStatus.StatusCode, Image> fPartnerTrackIcons;
    private Map<ArtefactStatus.StatusCode, Image> fActivityIcons;
    private Map<ArtefactStatus.StatusCode, Image> fDataPackageIcons;
    private Image fDetailViewIcon;
    private Image fStandardStatusIcon;
    private Action fStopTestAction;
    private Action fReRunAction;
    private CounterPanel fCounterPanel;
    private Composite fCounterComposite;
    private Label fTestInfoLabel;
    private TreeViewer fTreeViewer;
    private SashForm fSashForm;
    private DetailPane fDetailPane;
    private ProgressPanel fTestCaseProgress;
    private ProgressPanel fActivityProgress;
    private DrillDownAdapter drillDownAdapter;
    private TestRunSession fTestRunSession;

    public void createPartControl(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        parent.setLayout((Layout)gridLayout);
        this.fTestInfoLabel = new Label(parent, 16384);
        this.fTestInfoLabel.setText(" BPELUnit Eclipse Runner");
        this.fTestInfoLabel.setLayoutData((Object)new GridData(768));
        this.fCounterComposite = this.createProgressCountPanel(parent);
        this.fCounterComposite.setLayoutData((Object)new GridData(768));
        SashForm sashForm = this.createSashForm(parent);
        sashForm.setLayoutData((Object)new GridData(1808));
        this.drillDownAdapter = new DrillDownAdapter(this.fTreeViewer);
        this.makeActions();
        this.contributeToActionBars();
    }

    protected Composite createProgressCountPanel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        layout.numColumns = 1;
        layout.verticalSpacing = 0;
        this.createImages();
        this.fCounterPanel = new CounterPanel(composite);
        this.fCounterPanel.setLayoutData(new GridData(768));
        this.fTestCaseProgress = new ProgressPanel(composite, "Test Cases");
        this.fActivityProgress = new ProgressPanel(composite, "Activities");
        return composite;
    }

    private void createImages() {
        this.fTestCaseIcons = this.create("testCase");
        this.fPartnerTrackIcons = this.create("partnerTrack");
        this.fActivityIcons = this.create("activity");
        this.fDataPackageIcons = this.create("dataPackage");
        this.fDetailViewIcon = BPELUnitView.createImage("icons/bpel.gif");
        this.fStandardStatusIcon = BPELUnitView.createImage("icons/plainData.gif");
    }

    private Map<ArtefactStatus.StatusCode, Image> create(String name) {
        HashMap<ArtefactStatus.StatusCode, Image> map = new HashMap<ArtefactStatus.StatusCode, Image>();
        map.put(ArtefactStatus.StatusCode.PASSED, BPELUnitView.createImage("icons/" + name + "_pass.gif"));
        if ("activity".equals(name)) {
            map.put(ArtefactStatus.StatusCode.INPROGRESS, BPELUnitView.createImage("icons/" + name + "_inprogress.gif"));
        }
        map.put(ArtefactStatus.StatusCode.ERROR, BPELUnitView.createImage("icons/" + name + "_err.gif"));
        map.put(ArtefactStatus.StatusCode.FAILED, BPELUnitView.createImage("icons/" + name + "_fail.gif"));
        map.put(ArtefactStatus.StatusCode.NOTYETSPECIFIED, BPELUnitView.createImage("icons/" + name + "_notyet.gif"));
        map.put(ArtefactStatus.StatusCode.ABORTED, BPELUnitView.createImage("icons/" + name + "_aborted.gif"));
        return map;
    }

    public static Image createImage(String path) {
        return BPELUnitActivator.getImageDescriptor(path).createImage();
    }

    private void disposeImages() {
        this.fDetailViewIcon.dispose();
        this.fStandardStatusIcon.dispose();
        this.diposeImages(this.fTestCaseIcons);
        this.diposeImages(this.fPartnerTrackIcons);
        this.diposeImages(this.fActivityIcons);
        this.diposeImages(this.fDataPackageIcons);
    }

    private void diposeImages(Map<ArtefactStatus.StatusCode, Image> testCaseIcons) {
        for (Image image : testCaseIcons.values()) {
            image.dispose();
        }
    }

    public void dispose() {
        this.disposeImages();
    }

    private SashForm createSashForm(Composite parent) {
        this.fSashForm = new SashForm(parent, 512);
        ViewForm top = new ViewForm((Composite)this.fSashForm, 0);
        Composite empty = new Composite((Composite)top, 0);
        empty.setLayout(new Layout(){

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                return new Point(1, 1);
            }

            protected void layout(Composite composite, boolean flushCache) {
            }
        });
        top.setTopLeft((Control)empty);
        this.fTreeViewer = new TreeViewer((Composite)top, 516);
        this.fTreeViewer.setUseHashlookup(true);
        this.fTreeViewer.setContentProvider((IContentProvider)new TestSessionTreeContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new TestSessionLabelProvider(this));
        this.fTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new TestSessionChangedListener());
        top.setContent((Control)this.fTreeViewer.getTree());
        ViewForm bottom = new ViewForm((Composite)this.fSashForm, 0);
        CLabel label = new CLabel((Composite)bottom, 0);
        label.setText("Details:");
        label.setImage(this.fDetailViewIcon);
        bottom.setTopLeft((Control)label);
        ToolBar failureToolBar = new ToolBar((Composite)bottom, 0x800040);
        bottom.setTopCenter((Control)failureToolBar);
        this.fDetailPane = new DetailPane((Composite)bottom, failureToolBar);
        bottom.setContent(this.fDetailPane.getComposite());
        this.fSashForm.setWeights(new int[]{50, 50});
        return this.fSashForm;
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.fStopTestAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fReRunAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.fStopTestAction);
        manager.add((IAction)this.fReRunAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
    }

    private void makeActions() {
        this.fStopTestAction = new Action(){

            public void run() {
                BPELUnitView.this.fStopTestAction.setEnabled(false);
                BPELUnitView.this.fTestRunSession.stopTest();
            }
        };
        this.fStopTestAction.setText("Stop Test");
        this.fStopTestAction.setToolTipText("Stops the current test execution");
        this.fStopTestAction.setImageDescriptor(BPELUnitActivator.getImageDescriptor("icons/stop.gif"));
        this.fStopTestAction.setEnabled(false);
        this.fReRunAction = new Action(){

            public void run() {
                BPELUnitView.this.fTestRunSession.relaunchTest();
            }
        };
        this.fReRunAction.setText("Re-Run Last Test Suite");
        this.fReRunAction.setToolTipText("Re-Runs the current test");
        this.fReRunAction.setImageDescriptor(BPELUnitActivator.getImageDescriptor("icons/relaunch.gif"));
        this.fReRunAction.setEnabled(false);
    }

    public void setFocus() {
        this.fTreeViewer.getTree().setFocus();
    }

    public void registerLaunchSession(TestRunSession session) {
        this.fTestRunSession = session;
        session.getSuite().addResultListener((ITestResultListener)this);
        this.fTreeViewer.setInput((Object)session.getSuite());
        this.fTestCaseProgress.reset(session.getSuite().getTestCaseCount());
        this.fActivityProgress.reset();
        this.fCounterPanel.reset(session.getSuite().getName(), session.getSuite().getTestCaseCount());
        this.fStopTestAction.setEnabled(true);
        this.fReRunAction.setEnabled(true);
        this.fTestInfoLabel.setText(" Now starting test: " + session.getSuite().getName());
    }

    public void deregisterLaunchSession(TestRunSession session) {
        this.fTestRunSession.getSuite().removeResultListener((ITestResultListener)this);
        this.fStopTestAction.setEnabled(false);
        this.fTestInfoLabel.setText(" Test run completed: " + session.getSuite().getName());
    }

    public void progress(final ITestArtefact testArtefact) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (testArtefact instanceof Activity) {
                    BPELUnitView.this.fActivityProgress.stepForward(testArtefact.getStatus().hasProblems());
                    BPELUnitView.this.fTreeViewer.reveal((Object)testArtefact);
                }
                BPELUnitView.this.fTreeViewer.update((Object)testArtefact, null);
            }
        });
    }

    public void testCaseEnded(final TestCase testCase) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                BPELUnitView.this.fTestCaseProgress.stepForward(testCase.getStatus().hasProblems());
                if (testCase.getStatus().isAborted()) {
                    BPELUnitView.this.abortTest();
                }
                BPELUnitView.this.fCounterPanel.addRun(testCase.getStatus().getCode());
                BPELUnitView.this.fTreeViewer.update((Object)testCase, null);
            }
        });
    }

    public void testCaseStarted(final TestCase testCase) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                BPELUnitView.this.fActivityProgress.reset(testCase.getActivityCount());
                BPELUnitView.this.fTreeViewer.update((Object)testCase, null);
                BPELUnitView.this.fTestInfoLabel.setText(" Running tests of suite: " + BPELUnitView.this.fTestRunSession.getSuite().getName());
            }
        });
    }

    public Image getImage(ITestArtefact element) {
        if (element instanceof TestCase) {
            return this.fTestCaseIcons.get(element.getStatus().getCode());
        }
        if (element instanceof PartnerTrack) {
            return this.fPartnerTrackIcons.get(element.getStatus().getCode());
        }
        if (element instanceof Activity) {
            return this.fActivityIcons.get(element.getStatus().getCode());
        }
        if (element instanceof SendDataSpecification || element instanceof ReceiveDataSpecification) {
            return this.fDataPackageIcons.get(element.getStatus().getCode());
        }
        if (element instanceof ReceiveCondition) {
            return this.fDataPackageIcons.get(element.getStatus().getCode());
        }
        return this.fStandardStatusIcon;
    }

    public void handleSelected(ITestArtefact testElement) {
        this.fDetailPane.setArtefact(testElement);
    }

    private void abortTest() {
        this.fActivityProgress.abort();
        this.fTestCaseProgress.abort();
    }

    class TestSessionChangedListener
    implements ISelectionChangedListener {
        TestSessionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object o;
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof ITestArtefact) {
                BPELUnitView.this.handleSelected((ITestArtefact)o);
            }
        }
    }
}

