/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.client.eclipse.views;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import net.bpelunit.framework.coverage.result.statistic.IFileStatistic;
import net.bpelunit.framework.coverage.result.statistic.IStatistic;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class BPELUnitCoverageResultView
extends ViewPart
implements Observer {
    private CoverageModel model;
    private org.eclipse.swt.widgets.List fileList;
    private boolean initialized = false;
    private Table tableTestCases;
    private Table table;
    private Text text;
    private Composite fParent;

    public void createPartControl(Composite parent) {
        this.fParent = parent;
        parent.setLayout((Layout)new GridLayout(3, false));
        Label fInfoLabel = new Label(parent, 16384);
        fInfoLabel.setText("BPELUnit Test Coverage");
        GridData gData = new GridData(256);
        gData.horizontalSpan = 3;
        fInfoLabel.setLayoutData((Object)gData);
        this.text = new Text(parent, 10);
        gData = new GridData(256);
        gData.horizontalSpan = 3;
        this.text.setLayoutData((Object)gData);
        Label labelFilesInArchive = new Label(parent, 0x1000000);
        labelFilesInArchive.setText("BPELFiles in archive");
        gData = new GridData();
        gData.verticalAlignment = 3;
        labelFilesInArchive.setLayoutData((Object)gData);
        Label labelTestCoverage = new Label(parent, 0x1000000);
        labelTestCoverage.setText("Test coverage");
        gData = new GridData();
        gData.verticalAlignment = 3;
        labelTestCoverage.setLayoutData((Object)gData);
        Label labelTestCases = new Label(parent, 0x1000000);
        labelTestCases.setText("Test cases");
        gData = new GridData();
        gData.verticalAlignment = 3;
        labelTestCases.setLayoutData((Object)gData);
        this.fileList = new org.eclipse.swt.widgets.List(parent, 2818);
        gData = new GridData(1808);
        gData.grabExcessVerticalSpace = true;
        gData.grabExcessHorizontalSpace = true;
        this.fileList.setLayoutData((Object)gData);
        this.fileList.setBackground(parent.getBackground());
        this.fileList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                if (arg0.getSource() instanceof org.eclipse.swt.widgets.List) {
                    org.eclipse.swt.widgets.List list = (org.eclipse.swt.widgets.List)arg0.getSource();
                    BPELUnitCoverageResultView.this.model.setSelectedFiles(list.getSelection());
                }
            }
        });
        this.initializeTable(parent);
        gData = new GridData(1808);
        this.table.setLayoutData((Object)gData);
        this.tableTestCases = new Table(parent, 268437536);
        this.tableTestCases.setLayout((Layout)new GridLayout(1, false));
        this.tableTestCases.setBackground(parent.getBackground());
        gData = new GridData(1808);
        this.tableTestCases.setLayoutData((Object)gData);
        this.tableTestCases.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32 && e.item instanceof TableItem) {
                    TableItem item = (TableItem)e.item;
                    BPELUnitCoverageResultView.this.model.setTestcaseStatus(item.getText(), item.getChecked());
                }
            }
        });
        this.initializeElements();
        this.model = new CoverageModel();
        this.model.addObserver(this);
    }

    private Table initializeTable(Composite parent) {
        this.table = new Table(parent, 0x10000800);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn col1 = new TableColumn(this.table, 0);
        col1.setText("Metric");
        col1.setWidth(180);
        col1.setMoveable(false);
        TableColumn col2 = new TableColumn(this.table, 0x1000000);
        col2.setText("total");
        col2.setWidth(100);
        col2.setMoveable(false);
        TableColumn col3 = new TableColumn(this.table, 0x1000000);
        col3.setText("tested");
        col3.setWidth(100);
        col3.setMoveable(false);
        TableColumn col4 = new TableColumn(this.table, 0);
        col4.setText("           %");
        col4.setWidth(100);
        col4.setMoveable(false);
        return this.table;
    }

    private void initializeElements() {
        this.text.setText("Info: ");
        this.fileList.removeAll();
        this.tableTestCases.removeAll();
        this.table.removeAll();
    }

    public void setFocus() {
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        TableItem item;
        if (!this.initialized) {
            this.initializeElements();
            Iterator<String> iter = this.model.getFiles().iterator();
            while (iter.hasNext()) {
                this.fileList.add(iter.next());
                this.fileList.update();
            }
            iter = this.model.getAllTestCases().iterator();
            while (iter.hasNext()) {
                TableItem item2 = new TableItem(this.tableTestCases, 0);
                item2.setText(iter.next());
            }
            String infos = this.model.getInfos();
            if (infos != null && !infos.equals("")) {
                this.text.append(infos);
            } else {
                this.text.append("Test coverage is successful measured.");
            }
            this.initialized = true;
            this.fileList.selectAll();
            this.model.selectedFiles = this.fileList.getSelection();
            int i = 0;
            while (i < this.tableTestCases.getItemCount()) {
                item = this.tableTestCases.getItem(i);
                item.setChecked(true);
                this.model.checkedTestCases.add(item.getText());
                ++i;
            }
        }
        this.table.removeAll();
        List<String[]> list = this.model.getCurrentData();
        Iterator<String[]> iter = list.iterator();
        while (iter.hasNext()) {
            item = new TableItem(this.table, 0);
            item.setText(iter.next());
        }
        this.fParent.pack();
    }

    public void setData(List<String> testCases, List<IFileStatistic> statistics, String string) {
        this.initialized = false;
        this.model.setData(testCases, statistics, string);
    }

    public void initialize() {
        this.model.initialize();
        this.initializeElements();
    }

    class CoverageModel
    extends Observable {
        private List<String> testCases;
        private String[] selectedFiles;
        private Set<String> checkedTestCases;
        private String info = null;
        private Hashtable<String, IFileStatistic> fileStatistics;

        CoverageModel() {
            this.init();
        }

        private void init() {
            this.testCases = new ArrayList<String>();
            this.checkedTestCases = new HashSet<String>();
            this.fileStatistics = new Hashtable();
            this.selectedFiles = new String[0];
        }

        public void setData(List<String> testCases, List<IFileStatistic> statistics, String string) {
            this.init();
            this.info = string;
            if (statistics != null) {
                this.testCases = testCases;
                for (IFileStatistic fileStatistic : statistics) {
                    this.fileStatistics.put(fileStatistic.getBPELFilename(), fileStatistic);
                }
            }
            this.setChanged();
            this.notifyObservers();
        }

        public void setSelectedFiles(String[] strings) {
            this.selectedFiles = strings;
            this.setChanged();
            this.notifyObservers();
        }

        public void setTestcaseStatus(String name, boolean status) {
            if (status) {
                this.checkedTestCases.add(name);
            } else {
                this.checkedTestCases.remove(name);
            }
            this.setChanged();
            this.notifyObservers();
        }

        public List<String[]> getCurrentData() {
            return this.mergeMetrics();
        }

        private List<String[]> mergeMetrics() {
            ArrayList<String[]> tableEntries = new ArrayList<String[]>();
            if (this.selectedFiles.length > 0) {
                IFileStatistic fileStatistic = this.fileStatistics.get(this.selectedFiles[0]);
                Iterator iter = fileStatistic.getStatistics().iterator();
                while (iter.hasNext()) {
                    ArrayList<IStatistic> statistics = new ArrayList<IStatistic>();
                    IStatistic statistic1 = (IStatistic)iter.next();
                    statistics.add(statistic1);
                    int i = 1;
                    while (i < this.selectedFiles.length) {
                        IFileStatistic fileStatistic2 = this.fileStatistics.get(this.selectedFiles[i]);
                        IStatistic statistic2 = fileStatistic2.getStatistic(statistic1.getName());
                        statistics.add(statistic2);
                        ++i;
                    }
                    tableEntries.add(this.mergeMetric(statistics, statistic1.getName()));
                }
            }
            return tableEntries;
        }

        private String[] mergeMetric(List<IStatistic> statistics, String statisticName) {
            int tested = 0;
            int total = 0;
            String relativ = "-";
            for (IStatistic statistic : statistics) {
                total += statistic.getTotalNumber();
                tested += statistic.getTestedNumber(this.checkedTestCases);
            }
            if (total > 0) {
                relativ = String.valueOf(Float.toString((float)(tested * 1000 / total) / 10.0f)) + "%";
            }
            return new String[]{statisticName, Integer.toString(total), Integer.toString(tested), relativ};
        }

        public Set<String> getCheckedTestCases() {
            return this.checkedTestCases;
        }

        public List<String> getAllTestCases() {
            return this.testCases;
        }

        public Set<String> getFiles() {
            return this.fileStatistics.keySet();
        }

        public String getInfos() {
            return this.info;
        }

        public void initialize() {
            this.testCases = new ArrayList<String>();
            this.fileStatistics = new Hashtable();
            this.checkedTestCases = new HashSet<String>();
            this.selectedFiles = new String[0];
        }
    }
}

