/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.client.eclipse.dialog.field;

import net.bpelunit.framework.client.eclipse.dialog.Field;
import net.bpelunit.framework.client.eclipse.dialog.FieldBasedInputDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class ListField
extends Field {
    private TableViewer fViewer;
    private ILabelProvider fLabelProvider;
    private String[] fValues;
    private String fSelection;

    public ListField(FieldBasedInputDialog inputDialog, String labelText, String initialValue, String[] values) {
        super(inputDialog, labelText, initialValue);
        this.fValues = values;
        this.fSelection = "";
    }

    public void setLabelProvider(ILabelProvider provider) {
        this.fLabelProvider = provider;
    }

    @Override
    protected void createControl(Composite parent) {
        this.fViewer = new TableViewer(parent);
        GridData gd = new GridData(4, 1, true, false);
        gd.widthHint = 200;
        gd.horizontalSpan = 2;
        this.fViewer.getTable().setLayoutData((Object)gd);
        this.fViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                String selection = ListField.this.extractSelection();
                if (selection != null) {
                    ListField.this.fSelection = selection;
                    ListField.this.getDialog().validateFields();
                }
            }
        });
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                String selection = ListField.this.extractSelection();
                if (selection != null) {
                    ListField.this.fSelection = selection;
                    ListField.this.getDialog().validateFields();
                    ListField.this.getDialog().doPressOK();
                }
            }
        });
        this.fViewer.setInput((Object)this.fValues);
    }

    @Override
    public String getSelection() {
        return this.fSelection;
    }

    private String extractSelection() {
        IStructuredSelection struct;
        Object first;
        if (this.fViewer.getSelection() instanceof IStructuredSelection && (first = (struct = (IStructuredSelection)this.fViewer.getSelection()).getFirstElement()) != null && first instanceof String) {
            return (String)first;
        }
        return null;
    }

    class ListContentProvider
    implements IStructuredContentProvider {
        ListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (String[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

