/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.client.eclipse.dialog.field;

import net.bpelunit.framework.client.eclipse.BPELUnitActivator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class FileSelector {
    public static String getFile(Shell shell, String preSelectFile, ISelectionStatusValidator validator, ViewerFilter filter, IProject project, IContainer directory) {
        IFile newFile;
        IResource res;
        String path = null;
        IFile file = null;
        if (preSelectFile != null && (res = directory.findMember(preSelectFile)) != null && res.exists() && res instanceof IFile) {
            file = (IFile)res;
        }
        if ((newFile = FileSelector.selectFile(shell, "File selection", "Select a file.", filter, (IContainer)project, file)) != null) {
            IPath projPath = newFile.getProjectRelativePath();
            if (directory.getProjectRelativePath().isPrefixOf(projPath)) {
                projPath = projPath.removeFirstSegments(directory.getProjectRelativePath().segmentCount());
            }
            path = projPath.toString();
        }
        return path;
    }

    private static IFile selectFile(Shell shell, String title, String message, ViewerFilter filter, IContainer rootElement, IFile selectedFile) {
        ISelectionStatusValidator validator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 0) {
                    return new Status(4, BPELUnitActivator.getUniqueIdentifier(), 0, "", null);
                }
                Object[] objectArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (!(element instanceof IFile)) {
                        return new Status(4, BPELUnitActivator.getUniqueIdentifier(), 0, "", null);
                    }
                    ++n2;
                }
                return new Status(0, BPELUnitActivator.getUniqueIdentifier(), 0, "", null);
            }
        };
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator(validator);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter(filter);
        dialog.setInput((Object)rootElement);
        if (selectedFile != null) {
            dialog.setInitialSelection((Object)selectedFile);
        }
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        if (dialog.open() == 0) {
            return (IFile)dialog.getFirstResult();
        }
        return null;
    }
}

