/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.client.eclipse.dialog.field;

import net.bpelunit.framework.client.eclipse.dialog.Field;
import net.bpelunit.framework.client.eclipse.dialog.FieldBasedInputDialog;
import net.bpelunit.framework.client.eclipse.dialog.field.FileSelector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class FileField
extends Field {
    private Text fText;
    private ViewerFilter fFilter;
    private ISelectionStatusValidator fFileValidator;
    private IProject fRoot;
    private IContainer fCurrentDir;
    protected String fCurrentSelection;

    public FileField(FieldBasedInputDialog inputDialog, String labelText, String initialValue, ISelectionStatusValidator validator, ViewerFilter filter, IProject root, IContainer dir) {
        super(inputDialog, labelText, initialValue);
        this.fRoot = root;
        this.fFileValidator = validator;
        this.fFilter = filter;
        this.fCurrentDir = dir;
    }

    @Override
    protected void createControl(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(this.getLabelText());
        label.setLayoutData((Object)new GridData(32));
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        this.fText = new Text(comp, 2052);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.fText.setLayoutData((Object)data);
        label.setSize(label.getSize().x, this.fText.getSize().y);
        if (this.getInitialValue() != null) {
            this.fText.setText(this.getInitialValue());
        }
        this.fCurrentSelection = this.fText.getText();
        this.fText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileField.this.fCurrentSelection = FileField.this.fText.getText();
                FileField.this.getDialog().validateFields();
            }
        });
        Button button = this.createButton(comp, 9, "&Browse...", false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selected = FileSelector.getFile(FileField.this.getDialog().getShell(), FileField.this.fText.getText(), FileField.this.fFileValidator, FileField.this.fFilter, FileField.this.fRoot, FileField.this.fCurrentDir);
                if (selected != null) {
                    FileField.this.fCurrentSelection = FileField.this.fText.getText();
                    FileField.this.fText.setText(selected);
                    FileField.this.getDialog().validateFields();
                }
            }
        });
    }

    @Override
    public String getSelection() {
        return this.fCurrentSelection;
    }
}

