/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.client.eclipse.dialog.field;

import net.bpelunit.framework.client.eclipse.dialog.Field;
import net.bpelunit.framework.client.eclipse.dialog.FieldBasedInputDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ComboField
extends Field {
    private Combo fCombo;
    private String[] fOptions;
    private String fCurrentSelection;

    public ComboField(FieldBasedInputDialog inputDialog, String labelText, String initialValue, String[] options) {
        super(inputDialog, labelText, initialValue);
        this.fOptions = options;
    }

    @Override
    protected void createControl(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(this.getLabelText());
        label.setLayoutData((Object)new GridData(32));
        this.fCombo = new Combo(parent, 2060);
        this.fCombo.setLayoutData((Object)new GridData(768));
        this.fCombo.setItems(this.fOptions);
        label.setSize(label.getSize().x, this.fCombo.getSize().y);
        if (this.getInitialValue() != null) {
            this.fCombo.setText(this.getInitialValue());
        } else if (this.fOptions.length > 0) {
            this.fCombo.setText(this.fOptions[0]);
        } else {
            this.fCombo.setText("");
        }
        this.fCurrentSelection = this.fCombo.getText();
        this.fCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ComboField.this.fCurrentSelection = ComboField.this.fCombo.getText();
                ComboField.this.getDialog().validateFields();
            }
        });
    }

    @Override
    public String getSelection() {
        return this.fCurrentSelection;
    }
}

