/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.client.eclipse.dialog;

import java.util.ArrayList;
import java.util.List;
import net.bpelunit.framework.client.eclipse.BPELUnitActivator;
import net.bpelunit.framework.client.eclipse.dialog.Field;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FieldBasedInputDialog
extends Dialog {
    protected Composite fPanel;
    private String fTitle;
    private MessageBox fMessageBox;
    private List<Field> fFields = new ArrayList<Field>();

    public FieldBasedInputDialog(Shell shell, String title) {
        super(shell);
        this.fTitle = title;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void addField(Field field) {
        this.fFields.add(field);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fTitle != null) {
            shell.setText(this.fTitle);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control bar = super.createButtonBar(parent);
        this.validateFields();
        return bar;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        this.fPanel = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        this.fPanel.setLayout((Layout)layout);
        this.fPanel.setLayoutData((Object)new GridData(4, 4, true, false));
        for (Field field : this.fFields) {
            field.createControl(this.fPanel);
        }
        this.fMessageBox = new MessageBox(container, 0);
        this.fMessageBox.setLayoutData(new GridData(4, 4, true, true));
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    public int open() {
        FieldBasedInputDialog.applyDialogFont((Control)this.fPanel);
        return super.open();
    }

    public int convertHorizontalDLUsToPixels(int dlus) {
        return super.convertHorizontalDLUsToPixels(dlus);
    }

    public void validateFields() {
        for (Field field : this.fFields) {
            String validation = field.getValidator().validate(field.getSelection());
            if (validation == null) continue;
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(validation);
            return;
        }
        this.setErrorMessage(null);
        this.getButton(0).setEnabled(true);
    }

    private void setErrorMessage(String msg) {
        this.fMessageBox.setMessage(msg);
    }

    public void doPressOK() {
        if (this.getButton(0).isEnabled()) {
            super.okPressed();
        }
    }

    private static class MessageBox
    extends Composite {
        private Label fImage;
        private Text fText;

        public MessageBox(Composite parent, int style) {
            super(parent, style);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            this.setLayout((Layout)layout);
            this.fImage = new Label((Composite)this, 0);
            this.fImage.setImage(BPELUnitActivator.getImage("info_obj"));
            Point size = this.fImage.computeSize(-1, -1);
            GridData gd = new GridData();
            gd.verticalAlignment = 128;
            gd.widthHint = size.x;
            gd.heightHint = size.y;
            this.fImage.setLayoutData((Object)gd);
            this.fImage.setImage(null);
            this.fText = new Text((Composite)this, 72);
            this.fText.setText(" \n ");
            gd = new GridData(4, 4, true, true);
            gd.widthHint = 350;
            this.fText.setLayoutData((Object)gd);
        }

        public void setMessage(String msg) {
            if (msg == null || msg.length() == 0) {
                msg = "";
            }
            this.fText.setText(this.escapeAmpersands(msg));
            if ("".equals(msg)) {
                this.fImage.setImage(null);
            } else {
                this.fImage.setImage(BPELUnitActivator.getImage("error_obj"));
                if (msg.length() > 200) {
                    GridData d = (GridData)this.fText.getLayoutData();
                    d.heightHint = 40;
                }
            }
        }

        private String escapeAmpersands(String message) {
            StringBuffer result = new StringBuffer();
            int i = 0;
            while (i < message.length()) {
                char ch = message.charAt(i);
                if (ch == '&') {
                    result.append('&');
                }
                result.append(ch);
                ++i;
            }
            return result.toString();
        }
    }
}

