/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.client.eclipse.dialog;

import net.bpelunit.framework.client.eclipse.dialog.DialogFieldValidator;
import net.bpelunit.framework.client.eclipse.dialog.FieldBasedInputDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public abstract class Field {
    private FieldBasedInputDialog fDialog;
    private String fLabelText;
    private String fInitialValue;
    private DialogFieldValidator fValidator;

    public Field(FieldBasedInputDialog inputDialog, String labelText, String initialValue) {
        this.fDialog = inputDialog;
        this.fLabelText = labelText;
        this.fInitialValue = initialValue;
    }

    protected abstract void createControl(Composite var1);

    public abstract String getSelection();

    protected FieldBasedInputDialog getDialog() {
        return this.fDialog;
    }

    protected String getInitialValue() {
        return this.fInitialValue;
    }

    protected String getLabelText() {
        return this.fLabelText;
    }

    protected DialogFieldValidator getValidator() {
        return this.fValidator;
    }

    public void setValidator(DialogFieldValidator validator) {
        this.fValidator = validator;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)new Integer(id));
        this.setButtonLayoutData(button);
        return button;
    }

    protected void setButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        int widthHint = this.getDialog().convertHorizontalDLUsToPixels(61);
        Point minSize = button.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)data);
    }
}

