/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.client.eclipse;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.bpelunit.framework.client.eclipse.BPELUnitActivator;
import net.bpelunit.framework.client.model.DataSourceExtension;
import net.bpelunit.framework.client.model.DeployerExtension;
import net.bpelunit.framework.client.model.Extension;
import net.bpelunit.framework.client.model.HeaderProcessorExtension;
import net.bpelunit.framework.client.model.SOAPEncoderExtension;
import net.bpelunit.framework.control.datasource.DataSourceHelper;
import net.bpelunit.framework.control.ext.IBPELDeployer;
import net.bpelunit.framework.control.ext.IDataSource;
import net.bpelunit.framework.exception.SpecificationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ExtensionControl {
    public static final String DEPLOYER_EXTENSION_POINT_ID = "net.bpelunit.framework.client.eclipse.bpelDeployer";
    public static final String ENCODER_EXTENSION_POINT_ID = "net.bpelunit.framework.client.eclipse.soapEncoder";
    public static final String HEADER_EXTENSION_POINT_ID = "net.bpelunit.framework.client.eclipse.headerProcessor";
    public static final String DATASOURCE_EXTENSION_POINT_ID = "net.bpelunit.framework.client.eclipse.dataSource";
    private static Map<String, DeployerExtension> fDeployers = new HashMap<String, DeployerExtension>();
    private static Map<String, HeaderProcessorExtension> fHeaderProcessors = new HashMap<String, HeaderProcessorExtension>();
    private static Map<String, SOAPEncoderExtension> fSOAPEncoders = new HashMap<String, SOAPEncoderExtension>();
    private static Map<String, DataSourceExtension> fDataSources = new HashMap<String, DataSourceExtension>();
    private static boolean isInitialized = false;

    public static Map<String, DeployerExtension> getDeployers() {
        return fDeployers;
    }

    public static Map<String, HeaderProcessorExtension> getHeaderProcessors() {
        return new HashMap<String, HeaderProcessorExtension>(fHeaderProcessors);
    }

    public static Map<String, SOAPEncoderExtension> getSOAPEncoders() {
        return new HashMap<String, SOAPEncoderExtension>(fSOAPEncoders);
    }

    public static Map<String, DataSourceExtension> getDataSources() {
        return new HashMap<String, DataSourceExtension>(fDataSources);
    }

    public static void initialize() {
        if (!isInitialized) {
            ExtensionControl.loadExtensions(DEPLOYER_EXTENSION_POINT_ID, new BPELDeployerLoader());
            ExtensionControl.loadExtensions(ENCODER_EXTENSION_POINT_ID, new SOAPEncoderLoader());
            ExtensionControl.loadExtensions(HEADER_EXTENSION_POINT_ID, new HeaderProcessorLoader());
            ExtensionControl.loadExtensions(DATASOURCE_EXTENSION_POINT_ID, new DataSourceLoader());
            isInitialized = true;
        }
    }

    private static void loadExtensions(String extensionPointID, ELoader loader) {
        IExtension[] extensions;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionPointID);
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension element = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = element.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element0 = iConfigurationElementArray[n4];
                loader.load(element0);
                ++n4;
            }
            ++n2;
        }
    }

    public static DeployerExtension findDeployerExtension(String type) {
        return fDeployers.get(type);
    }

    public static HeaderProcessorExtension findHeaderProcessorExtension(String name) {
        return fHeaderProcessors.get(name);
    }

    public static SOAPEncoderExtension findSOAPEncoderExtension(String styleEncoding) {
        return fSOAPEncoders.get(styleEncoding);
    }

    public static DataSourceExtension findDataSource(String type) {
        return fDataSources.get(type);
    }

    public static String[][] getDeployerMetaInformation() {
        ExtensionControl.initialize();
        String[][] str = new String[fDeployers.size()][2];
        int i = 0;
        for (Extension extension : fDeployers.values()) {
            str[i][0] = extension.getName();
            str[i][1] = extension.getId();
            ++i;
        }
        return str;
    }

    public static String[][] getHeaderProcessorMetaInformation() {
        ExtensionControl.initialize();
        String[][] str = new String[fHeaderProcessors.size()][2];
        int i = 0;
        for (Extension extension : fHeaderProcessors.values()) {
            str[i][0] = extension.getName();
            str[i][1] = extension.getId();
            ++i;
        }
        return str;
    }

    public static String chooseDefaultDeployerId() {
        ExtensionControl.initialize();
        if (fDeployers.isEmpty()) {
            return "";
        }
        return fDeployers.values().iterator().next().getId();
    }

    public static String getDeployerType(IBPELDeployer deployer) {
        Set<String> keys = fDeployers.keySet();
        for (String key : keys) {
            try {
                if (fDeployers.get(key).createNew().getClass() != deployer.getClass()) continue;
                return fDeployers.get(key).getId();
            }
            catch (SpecificationException specificationException) {
                return null;
            }
        }
        return null;
    }

    static class BPELDeployerLoader
    extends ELoader {
        BPELDeployerLoader() {
        }

        @Override
        public void load(IConfigurationElement e) {
            super.load(e);
            if (this.id == null) {
                BPELUnitActivator.logErrorMessage("Error reading bpel deployer list from plugin.xml files - required attributes are missing.");
            } else {
                fDeployers.put(this.id, new DeployerExtension(this.id, this.name, e));
            }
        }
    }

    static class DataSourceLoader
    extends ELoader {
        DataSourceLoader() {
        }

        @Override
        public void load(IConfigurationElement e) {
            super.load(e);
            try {
                IDataSource ds = (IDataSource)e.createExecutableExtension("class");
                String shortName = DataSourceHelper.getShortName((IDataSource)ds);
                this.name = DataSourceHelper.getName((IDataSource)ds);
                fDataSources.put(this.id, new DataSourceExtension(shortName, this.name, e));
            }
            catch (CoreException e1) {
                BPELUnitActivator.logErrorMessage("Error reading data source list from plugin.xml files - data source class cannot be instantiated.");
                e1.printStackTrace();
            }
        }
    }

    static class ELoader {
        protected String id;
        protected String name;
        protected String icon;

        ELoader() {
        }

        public void load(IConfigurationElement e) {
            this.id = e.getAttribute("id");
            this.name = e.getAttribute("name");
        }
    }

    static class HeaderProcessorLoader
    extends ELoader {
        HeaderProcessorLoader() {
        }

        @Override
        public void load(IConfigurationElement e) {
            super.load(e);
            if (this.id == null) {
                BPELUnitActivator.logErrorMessage("Error reading header processor list from plugin.xml files - required attributes are missing.");
            } else {
                fHeaderProcessors.put(this.id, new HeaderProcessorExtension(this.id, this.name, e));
            }
        }
    }

    static class SOAPEncoderLoader
    extends ELoader {
        SOAPEncoderLoader() {
        }

        @Override
        public void load(IConfigurationElement e) {
            super.load(e);
            if (this.id == null) {
                BPELUnitActivator.logErrorMessage("Error reading soap encoder list from plugin.xml files - required attributes are missing.");
            } else {
                fSOAPEncoders.put(this.id, new SOAPEncoderExtension(this.id, this.name, e));
            }
        }
    }
}

