/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.client.eclipse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.bpelunit.framework.BPELUnitRunner;
import net.bpelunit.framework.client.eclipse.BPELUnitActivator;
import net.bpelunit.framework.client.eclipse.ExtensionControl;
import net.bpelunit.framework.client.model.DataSourceExtension;
import net.bpelunit.framework.client.model.DeployerExtension;
import net.bpelunit.framework.client.model.ExtensionUtil;
import net.bpelunit.framework.client.model.HeaderProcessorExtension;
import net.bpelunit.framework.client.model.SOAPEncoderExtension;
import net.bpelunit.framework.control.ext.IBPELDeployer;
import net.bpelunit.framework.control.ext.IDataSource;
import net.bpelunit.framework.control.ext.IHeaderProcessor;
import net.bpelunit.framework.control.ext.ISOAPEncoder;
import net.bpelunit.framework.control.run.TestCaseRunner;
import net.bpelunit.framework.coverage.CoverageMeasurementTool;
import net.bpelunit.framework.coverage.ICoverageMeasurementTool;
import net.bpelunit.framework.exception.ConfigurationException;
import net.bpelunit.framework.exception.SpecificationException;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.jface.preference.IPreferenceStore;

public class EclipseBPELUnitRunner
extends BPELUnitRunner {
    public void configureDeployers() throws ConfigurationException {
    }

    public void configureExtensions() throws ConfigurationException {
        ExtensionControl.initialize();
    }

    public void configureInit() throws ConfigurationException {
    }

    public void configureLogging() {
        Logger rootLogger = Logger.getRootLogger();
        rootLogger.removeAllAppenders();
    }

    public void configureLogging(Level level, Appender appender) {
        Logger rootLogger = Logger.getRootLogger();
        rootLogger.removeAllAppenders();
        rootLogger.addAppender(appender);
        rootLogger.setLevel(level);
    }

    public IBPELDeployer createNewDeployer(String type) throws SpecificationException {
        DeployerExtension deployer = ExtensionControl.findDeployerExtension(type);
        if (deployer != null) {
            IBPELDeployer newDeployer = deployer.createNew();
            return newDeployer;
        }
        throw new SpecificationException("Could not find a deployer for type " + type);
    }

    public IHeaderProcessor createNewHeaderProcessor(String name) throws SpecificationException {
        HeaderProcessorExtension hproc = ExtensionControl.findHeaderProcessorExtension(name);
        if (hproc != null) {
            return hproc.createNew();
        }
        throw new SpecificationException("Could not find a header processor for type " + name);
    }

    public ISOAPEncoder createNewSOAPEncoder(String styleEncoding) throws SpecificationException {
        SOAPEncoderExtension soapEnc = ExtensionControl.findSOAPEncoderExtension(styleEncoding);
        if (soapEnc != null) {
            return soapEnc.createNew();
        }
        throw new SpecificationException("Could not find a SOAP Encoder for type " + styleEncoding);
    }

    public IDataSource createNewDataSource(String type) throws SpecificationException {
        DataSourceExtension dataSource = ExtensionControl.findDataSource(type);
        if (dataSource != null) {
            return dataSource.createNew();
        }
        throw new SpecificationException("Could not find a Data Source for type " + type);
    }

    public void configureCoverageTool() throws ConfigurationException {
    }

    public void configureCoverageTool(BPELUnitActivator plugin) {
        HashMap map = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        IPreferenceStore preference = plugin.getPreferenceStore();
        if (preference.getBoolean("receive")) {
            list.add("receive");
        }
        if (preference.getBoolean("reply")) {
            list.add("reply");
        }
        if (preference.getBoolean("invoke")) {
            list.add("invoke");
        }
        if (preference.getBoolean("assign")) {
            list.add("assign");
        }
        if (preference.getBoolean("throw")) {
            list.add("throw");
        }
        if (preference.getBoolean("exit")) {
            list.add("exit");
        }
        if (preference.getBoolean("wait")) {
            list.add("wait");
        }
        if (preference.getBoolean("empty")) {
            list.add("empty");
        }
        if (preference.getBoolean("compensate")) {
            list.add("compensate");
        }
        if (preference.getBoolean("compensateScope")) {
            list.add("compensateScope");
        }
        if (preference.getBoolean("rethrow")) {
            list.add("rethrow");
        }
        if (preference.getBoolean("validate")) {
            list.add("validate");
        }
        if (preference.getBoolean("terminate")) {
            list.add("terminate");
        }
        if (list.size() > 0) {
            map.put("ActivityCoverage", list);
        }
        if (preference.getBoolean("BranchCoverage")) {
            map.put("BranchCoverage", null);
        }
        if (preference.getBoolean("LinkCoverage")) {
            map.put("LinkCoverage", null);
        }
        if (preference.getBoolean("FaultHandlerCoverage")) {
            map.put("FaultHandlerCoverage", null);
        }
        if (preference.getBoolean("CompensationHandlerCoverage")) {
            map.put("CompensationHandlerCoverage", null);
        }
        TestCaseRunner.setWaitTimeForCoverageMarkers((int)preference.getInt("WaitTime"));
        CoverageMeasurementTool coverageTool = new CoverageMeasurementTool();
        BPELUnitRunner.setCoverageMeasurmentTool((ICoverageMeasurementTool)coverageTool);
        try {
            coverageTool.configureMetrics(map);
        }
        catch (ConfigurationException configurationException) {}
    }

    public Map<String, String> getGlobalConfigurationForDeployer(IBPELDeployer deployer) {
        IPreferenceStore ps = BPELUnitActivator.getDefault().getPreferenceStore();
        String type = ExtensionControl.getDeployerType(deployer);
        if (type == null) {
            return null;
        }
        String serializedMap = ps.getString(type);
        if (serializedMap == null) {
            return null;
        }
        return ExtensionUtil.deserializeMap(serializedMap);
    }
}

