/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import net.blugrid.core.dao.SocialMediaProfileDAO;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.SocialMediaProfile;
import net.blugrid.core.model.SocialMediaProfileResponse;
import net.blugrid.core.model.Token;
import net.blugrid.core.utils.PostgresqlJson;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class SocialMediaProfileDAOImpl
implements SocialMediaProfileDAO {
    private static final Logger logger = Logger.getLogger(SocialMediaProfileDAOImpl.class);
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_socialmediaprofile(    :token::t_pgpmessage,    null::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public SocialMediaProfileResponse post(Token token, SocialMediaProfile socialmediaprofile) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json FROM proc_post_socialmediaprofile(   :insessiontoken::t_pgpmessage,   :insocialmediaprofileuuid::t_uuid,   :insocialmedianetwork::t_socialmedianetwork,   :inurl::t_urladdress,   :instatus::t_status ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("insessiontoken", (Object)token.getid_token());
        parameters.addValue("insocialmediaprofileuuid", (Object)socialmediaprofile.getSocialmediaprofileuuid());
        parameters.addValue("insocialmedianetwork", (Object)socialmediaprofile.getSocialmedianetwork());
        parameters.addValue("inurl", (Object)socialmediaprofile.getUrl());
        parameters.addValue("instatus", (Object)socialmediaprofile.getStatus());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        SocialMediaProfileResponse response = PostgresqlJson.jsonToSocialMediaProfileResponse((String)json.getJson());
        return response;
    }

    @Override
    public List<SocialMediaProfile> postList(Token token, List<SocialMediaProfile> socialmediaprofileList) {
        ArrayList<SocialMediaProfile> response = new ArrayList<SocialMediaProfile>();
        if (socialmediaprofileList != null) {
            for (int i = 0; i < socialmediaprofileList.size(); ++i) {
                SocialMediaProfileResponse sp = this.post(token, socialmediaprofileList.get(i));
                if (!sp.getStatus().equalsIgnoreCase("OK")) continue;
                response.add(sp.getSocialmediaprofile());
            }
        }
        return response;
    }
}

