/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.PublicationSeriesDAO;
import net.blugrid.core.model.CustomerAccount;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.ObjectResponse;
import net.blugrid.core.model.PublicationSeries;
import net.blugrid.core.model.Token;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class PublicationSeriesDAOImpl
implements PublicationSeriesDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_publicationseries(   :token::t_pgpmessage,   NULL::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_publicationseries(   :token::t_pgpmessage,   :uuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("uuid", (Object)uuid);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public ObjectResponse<PublicationSeries> post(Token token, PublicationSeries publicationseries) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json  FROM proc_post_publicationseries(   :token::t_pgpmessage,   :inpublicationseriesuuid::t_uuid,   :inpublicationseriesname::t_name,   :inpublicationseriesdescription::t_text,   :instatus::t_status ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("inpublicationseriesuuid", (Object)publicationseries.getPublicationseriesuuid());
        parameters.addValue("inpublicationseriesname", (Object)publicationseries.getPublicationseriesname());
        parameters.addValue("inpublicationseriesdescription", (Object)publicationseries.getPublicationseriesdescrciption());
        parameters.addValue("instatus", (Object)publicationseries.getStatus());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        Type type = new TypeToken<ObjectResponse<PublicationSeries>>(){}.getType();
        ObjectResponse response = (ObjectResponse)new Gson().fromJson(json.getJson(), type);
        return response;
    }

    @Override
    public ObjectResponse<CustomerAccount> postCustomerPublicationSubscription(Token token, CustomerAccount customeraccount) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json FROM proc_post_customerpublicationsubscription (  :sessiontoken::t_pgpmessage,  :inpartyuuid::t_uuid,  :incustomeraccountuuid::t_uuid,  :incustomeraccounttype::t_customeraccounttype,  :incustomeraccountcode::t_codemetadata,  :ineffectivedate::t_timestamp,  :inexpirationdate::t_timestamp,  :incustomeraccountstatus::t_customeraccountstatus,  :inpublicationseriesuuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("sessiontoken", (Object)token.getid_token());
        parameters.addValue("inpartyuuid", (Object)customeraccount.getPartyuuid());
        parameters.addValue("incustomeraccountuuid", (Object)customeraccount.getCustomeraccountuuid());
        parameters.addValue("incustomeraccounttype", (Object)customeraccount.getCustomeraccounttype());
        parameters.addValue("incustomeraccountcode", (Object)customeraccount.getCustomeraccountcode());
        parameters.addValue("ineffectivedate", (Object)customeraccount.getExpirationdate());
        parameters.addValue("inexpirationdate", (Object)customeraccount.getExpirationdate());
        parameters.addValue("incustomeraccountstatus", (Object)customeraccount.getCustomeraccountuuid());
        parameters.addValue("inpublicationseriesuuid", (Object)customeraccount.getPublicationseriesuuid());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        Type type = new TypeToken<ObjectResponse<CustomerAccount>>(){}.getType();
        ObjectResponse response = (ObjectResponse)new Gson().fromJson(json.getJson(), type);
        return response;
    }
}

