/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.LocationDAO;
import net.blugrid.core.dao.WebPageDAO;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.Location;
import net.blugrid.core.model.ObjectResponse;
import net.blugrid.core.model.Token;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class LocationDAOImpl
implements LocationDAO {
    private static final Logger logger = Logger.getLogger(LocationDAOImpl.class);
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;
    @Autowired
    private WebPageDAO WebPagedao;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_location(   :token::t_pgpmessage,   NULL::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_location(   :token::t_pgpmessage,   :inlocationuuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("inlocationuuid", (Object)uuid.toString());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public ObjectResponse<Location> post(Token Token2, Location location) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json FROM proc_post_location(   :insessiontoken::t_pgpmessage,  :inlocationuuid::t_uuid,  :inlocationname::t_name,  :inbusinessunituuid::t_uuid,  :inaddressuuid::t_uuid,  :inaddressline1::t_address,  :inaddressline2::t_address,  :inaddressline3::t_address,  :incityname::t_city,  :instatename::t_name,  :inPostalCode::t_PostalCode,  :incountrycode2::t_code2,  :instatecode::t_code,  :instatus::t_status  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("insessiontoken", (Object)Token2.getid_token());
        parameters.addValue("inlocationuuid", (Object)location.getLocationuuid());
        parameters.addValue("inlocationname", (Object)location.getLocationname());
        parameters.addValue("inbusinessunituuid", (Object)location.getBusinessunituuid());
        parameters.addValue("inaddressuuid", (Object)location.getAddress().getAddressuuid());
        parameters.addValue("inaddressline1", (Object)location.getAddress().getAddressline1());
        parameters.addValue("inaddressline2", (Object)location.getAddress().getAddressline2());
        parameters.addValue("inaddressline3", (Object)location.getAddress().getAddressline3());
        parameters.addValue("incityname", (Object)location.getAddress().getCityname());
        parameters.addValue("instatename", (Object)location.getAddress().getStatename());
        parameters.addValue("inPostalCode", (Object)location.getAddress().getPostalcode());
        parameters.addValue("incountrycode2", (Object)location.getAddress().getCountry().getCountrycode2());
        parameters.addValue("instatecode", (Object)location.getAddress().getState().getCode());
        parameters.addValue("instatus", (Object)location.getStatus());
        JsonData jsondata = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        Type type = new TypeToken<ObjectResponse<Location>>(){}.getType();
        ObjectResponse response = (ObjectResponse)new Gson().fromJson(jsondata.getJson(), type);
        return response;
    }
}

