/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.ItemCategoryDAO;
import net.blugrid.core.model.ItemCategory;
import net.blugrid.core.model.ItemCategoryClassification;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.Response;
import net.blugrid.core.model.Token;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ItemCategoryDAOImpl
implements ItemCategoryDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = " SELECT outnodes AS json  FROM proc_view_itemcategoryhierarchy(   :token::t_pgpmessage,   NULL::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = " SELECT outdata AS json  FROM proc_view_itemcategory(   :token::t_pgpmessage,   :itemcategoryuuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("itemcategoryuuid", (Object)uuid);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getList(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = " SELECT outnodes AS json  FROM proc_view_itemcategoryhierarchy_list(   :token::t_pgpmessage,   :itemcategoryhierarchyuuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("itemcategoryhierarchyuuid", (Object)uuid);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getFlatList(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = " SELECT json_agg(itemcategory) AS json FROM (   SELECT outitemcategoryhierarchyuuid as itemcategoryhierarchyuuid,    outitemcategoryuuid as itemcategoryuuid,    outitemcategoryname as itemcategoryname,    outitemcategorydescription as itemcategorydescription,    outitemcategorycode as itemcategorycode,    outparentuuid as parentuuid,    outlevel1code as level1code,    outlevel1name as level1name,    outlevel2code as level2code,    outlevel2name as level2name,    outlevel3code as level3code,    outlevel3name as level3name,    outlevel4code as level4code,     outlevel4name as level4name,    outlevel5code as level5code,    outlevel5name as level5name  FROM proc_view_itemcategoryhierarchy_flat(        :token::t_pgpmessage,        :itemcategoryhierarchyuuid::t_uuid      )) itemcategory ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("itemcategoryhierarchyuuid", (Object)uuid);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public Response post(Token Token2, ItemCategory cat) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outstatus as status,   outsource as source,   outmessage as message  FROM proc_post_itemcategory(   :sessiontoken::t_pgpmessage,  :itemcategoryuuid::t_uuid,  :itemcategoryname::t_descriptionshort,   :itemcategorydescription::t_description,   :itemcategorycode::t_code  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("sessiontoken", (Object)Token2.getid_token());
        parameters.addValue("itemcategoryuuid", (Object)cat.getItemcategoryuuid());
        parameters.addValue("itemcategoryname", (Object)cat.getItemcategoryname());
        parameters.addValue("itemcategorydescription", (Object)cat.getItemcategorydescription());
        parameters.addValue("itemcategorycode", (Object)cat.getItemcategorycode());
        Response response = (Response)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(Response.class));
        if (!cat.getClassificationattributes().isEmpty()) {
            String attsql = "SELECT outstatus as status,   outsource as source,   outmessage as message  FROM proc_post_classificationattribute (  :sessiontoken::t_pgpmessage,  :attributeuuid::t_uuid,  :attributename::t_descriptionshort,  :attributedefinition::t_description,  :itemcategoryuuid::t_uuid,  :insequence::t_linenumber,  :instatus::t_status ) ";
            for (int i = 0; i < cat.getClassificationattributes().size(); ++i) {
                MapSqlParameterSource eparameters = new MapSqlParameterSource();
                eparameters.addValue("sessiontoken", (Object)Token2.getid_token());
                eparameters.addValue("attributeuuid", (Object)((ItemCategoryClassification)cat.getClassificationattributes().get(i)).getAttributeuuid());
                eparameters.addValue("attributename", (Object)((ItemCategoryClassification)cat.getClassificationattributes().get(i)).getAttributename());
                eparameters.addValue("attributedefinition", (Object)((ItemCategoryClassification)cat.getClassificationattributes().get(i)).getAttributedefinition());
                eparameters.addValue("itemcategoryuuid", (Object)cat.getItemcategoryuuid());
                eparameters.addValue("insequence", (Object)((ItemCategoryClassification)cat.getClassificationattributes().get(i)).getSequence());
                eparameters.addValue("instatus", (Object)((ItemCategoryClassification)cat.getClassificationattributes().get(i)).getStatus());
                Response response2 = (Response)namedParameterJdbcTemplate.queryForObject(attsql, (SqlParameterSource)eparameters, (RowMapper)BeanPropertyRowMapper.newInstance(Response.class));
            }
        }
        return response;
    }

    @Override
    public Response postHierarchy(Token Token2, ItemCategory cat) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        List<ItemCategory> flatlist = new ArrayList<ItemCategory>();
        flatlist.add(cat);
        if (!cat.getChilds().isEmpty()) {
            flatlist = this.flatten(flatlist, cat);
            flatlist = this.RemoveChilds(flatlist);
        }
        Gson gson = new Gson();
        String json = gson.toJson(flatlist);
        String sql = "SELECT outstatus as status,   outsource as source,   outmessage as message  FROM proc_post_itemcategoryhierarchy(   :sessiontoken::t_pgpmessage,  NULL::t_uuid,  :jsondata::json ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        String emptystr = "";
        parameters.addValue("sessiontoken", (Object)Token2.getid_token());
        parameters.addValue("jsondata", (Object)json);
        Response response = (Response)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(Response.class));
        return response;
    }

    public List<ItemCategory> flatten(List<ItemCategory> list, ItemCategory cat) {
        ItemCategory child = new ItemCategory();
        for (int i = 0; i < cat.getChilds().size(); ++i) {
            child = (ItemCategory)cat.getChilds().get(i);
            list.add(child);
            if (((ItemCategory)cat.getChilds().get(i)).getChilds().isEmpty()) continue;
            list = this.flatten(list, (ItemCategory)cat.getChilds().get(i));
        }
        return list;
    }

    public List<ItemCategory> RemoveChilds(List<ItemCategory> list) {
        ArrayList blank = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).setChilds(blank);
        }
        return list;
    }
}

