/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.reflect.TypeToken;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.ExternalDataSyncProfileDAO;
import net.blugrid.core.model.ExternalDataSyncProfile;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.Party;
import net.blugrid.core.model.Token;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ExternalDataSyncProfileDAOImpl
implements ExternalDataSyncProfileDAO {
    private static final Logger logger = Logger.getLogger(ExternalDataSyncProfileDAOImpl.class);
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public List<ExternalDataSyncProfile> getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_externaldatasyncprofile(:token::t_pgpmessage,   NULL::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        ArrayList<ExternalDataSyncProfile> response = new ArrayList();
        try {
            response = (List)new ObjectMapper().readValue(json.getJson(), (TypeReference)new TypeReference<List<ExternalDataSyncProfile>>(){});
        }
        catch (IOException ex) {
            logger.error((Object)("Error parsing json: " + ex));
        }
        return response;
    }

    @Override
    public ExternalDataSyncProfile getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_externaldatasyncprofile(   :token::t_pgpmessage,   :inexternaldatasyncprofileuuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("inexternaldatasyncprofileuuid", (Object)uuid);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        ExternalDataSyncProfile response = new ExternalDataSyncProfile();
        try {
            response = (ExternalDataSyncProfile)new ObjectMapper().readValue(json.getJson(), ExternalDataSyncProfile.class);
        }
        catch (IOException ex) {
            logger.error((Object)("Error parsing json: " + ex));
        }
        return response;
    }

    @Override
    public List<Party> getCustomerDataSyncPull(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_customerdatasyncprofile_pull(   :token::t_pgpmessage,   :inexternaldatasyncprofileuuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("inexternaldatasyncprofileuuid", (Object)uuid);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        List<Object> response = new ArrayList<Party>();
        if (json.getJson() != null) {
            try {
                Type listType = new TypeToken<ArrayList<Party>>(){}.getType();
                response = (List)new GsonBuilder().create().fromJson(json.getJson(), listType);
            }
            catch (Exception ex) {
                logger.error((Object)("Error parsing json: " + ex));
            }
        }
        return response;
    }
}

