/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.AddressDAO;
import net.blugrid.core.dao.EmailAddressDAO;
import net.blugrid.core.dao.EmailMessageDAO;
import net.blugrid.core.dao.TelephoneDAO;
import net.blugrid.core.dao.TimeGroupDAO;
import net.blugrid.core.dao.WebsiteDAO;
import net.blugrid.core.model.Address;
import net.blugrid.core.model.EmailAddress;
import net.blugrid.core.model.EmailMessageResponse;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.Telephone;
import net.blugrid.core.model.TimeGroupResponse;
import net.blugrid.core.model.Token;
import net.blugrid.core.model.Website;
import net.blugrid.core.model.WebsiteGoogleAnalyticsAccountAssignment;
import net.blugrid.core.utils.PostgresqlJson;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class WebsiteDAOImpl
implements WebsiteDAO {
    private static final Logger logger = Logger.getLogger(WebsiteDAOImpl.class);
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;
    @Autowired
    private EmailMessageDAO EmailMessagedao;
    @Autowired
    private AddressDAO Addressdao;
    @Autowired
    private EmailAddressDAO EmailAddressdao;
    @Autowired
    private TelephoneDAO Telephonedao;
    @Autowired
    private TimeGroupDAO TimeGroupdao;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson as json FROM proc_view_website(    :token::t_pgpmessage,    NULL::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public Website postByUUID(Token token, Website website) {
        int i;
        EmailMessageResponse invEmailResponse = new EmailMessageResponse();
        if (website.getInvoiceemail() != null) {
            logger.info((Object)"Posting Invoice email.");
            invEmailResponse = this.EmailMessagedao.post(token, website.getInvoiceemail());
        }
        EmailMessageResponse passwordEmailResponse = new EmailMessageResponse();
        if (website.getPasswordresetemail() != null) {
            logger.info((Object)"Posting Password reset email.");
            passwordEmailResponse = this.EmailMessagedao.post(token, website.getPasswordresetemail());
        }
        Website response = new Website();
        response = website;
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String websql = " SELECT outdeviceuuid AS deviceuuid  FROM proc_post_website (    :insessiontoken::t_pgpmessage,    :indeviceuuid::t_uuid,    :inname::t_descriptionshort,    :instatus::t_status,    :inwebpagetitle::t_text,    :inwebpagedescription::t_text,    :inbranduuid::t_uuid,    :infootercontentuuid::t_uuid,    :indefaultwebpageuuid::t_uuid,    :inloginwebpageuuid::t_uuid,    :inpasswordresetmessageuuid::t_uuid,    :ininvoicemessageuuid::t_uuid ) ";
        MapSqlParameterSource eparameters = new MapSqlParameterSource();
        eparameters.addValue("insessiontoken", (Object)token.getid_token());
        eparameters.addValue("indeviceuuid", (Object)website.getDeviceuuid());
        eparameters.addValue("inname", (Object)website.getName());
        eparameters.addValue("instatus", (Object)website.getStatus());
        eparameters.addValue("inwebpagetitle", (Object)website.getWebpagetitle());
        eparameters.addValue("inwebpagedescription", (Object)website.getWebpagedescription());
        if (website.getBrand() != null) {
            eparameters.addValue("inbranduuid", (Object)website.getBrand().getBranduuid());
        } else {
            eparameters.addValue("inbranduuid", null);
        }
        if (website.getFooter() != null) {
            eparameters.addValue("infootercontentuuid", (Object)website.getFooter().getWebcontentuuid());
        } else {
            eparameters.addValue("infootercontentuuid", null);
        }
        if (website.getDefaultwebpage() != null) {
            eparameters.addValue("indefaultwebpageuuid", (Object)website.getDefaultwebpage().getWebpageuuid());
        } else {
            eparameters.addValue("indefaultwebpageuuid", null);
        }
        if (website.getLoginwebpage() != null) {
            eparameters.addValue("inloginwebpageuuid", (Object)website.getLoginwebpage().getWebpageuuid());
        } else {
            eparameters.addValue("inloginwebpageuuid", null);
        }
        if (invEmailResponse.getEmailmessage() != null) {
            eparameters.addValue("ininvoicemessageuuid", (Object)invEmailResponse.getEmailmessage().getMessageuuid());
        } else {
            eparameters.addValue("ininvoicemessageuuid", null);
        }
        if (passwordEmailResponse.getEmailmessage() != null) {
            eparameters.addValue("inpasswordresetmessageuuid", (Object)passwordEmailResponse.getEmailmessage().getMessageuuid());
        } else {
            eparameters.addValue("inpasswordresetmessageuuid", null);
        }
        Website uuid = (Website)namedParameterJdbcTemplate.queryForObject(websql, (SqlParameterSource)eparameters, (RowMapper)BeanPropertyRowMapper.newInstance(Website.class));
        response.setDeviceuuid(uuid.getDeviceuuid());
        if (!website.getTelephone().isEmpty()) {
            for (i = 0; i < website.getTelephone().size(); ++i) {
                Telephone tel = this.Telephonedao.postWebsiteTelephone(token, (Telephone)website.getTelephone().get(i), website.getDeviceuuid());
                ((Telephone)website.getTelephone().get(i)).setTelephoneuuid(tel.getTelephoneuuid());
            }
        }
        if (!website.getEmailaddress().isEmpty()) {
            for (i = 0; i < website.getEmailaddress().size(); ++i) {
                EmailAddress em = this.EmailAddressdao.postWebsitEmailAddress(token, (EmailAddress)website.getEmailaddress().get(i), website.getDeviceuuid());
                ((EmailAddress)website.getEmailaddress().get(i)).setEmailuuid(em.getEmailuuid());
            }
        }
        if (!website.getAddress().isEmpty()) {
            for (i = 0; i < website.getAddress().size(); ++i) {
                Address addr = this.Addressdao.postWebsiteAddress(token, (Address)website.getAddress().get(i), website.getDeviceuuid());
                ((Address)website.getAddress().get(i)).setAddressuuid(addr.getAddressuuid());
            }
        }
        if (website.getWebsitegoogleanalyticsaccountassignment() != null) {
            this.postWebsiteGoogleAnalyticAccount(token, website.getWebsitegoogleanalyticsaccountassignment());
        }
        if (website.getTradinghours() != null) {
            TimeGroupResponse trandinghoursrsp = this.TimeGroupdao.post(token, website.getTradinghours());
            response.setTradinghours(trandinghoursrsp.getTimegroup());
        }
        return response;
    }

    private void postWebsiteGoogleAnalyticAccount(Token token, List<WebsiteGoogleAnalyticsAccountAssignment> assignmentList) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson as json FROM proc_post_websitegoogleanalyticsassignment(    :insessiontoken::t_uuid,    :indeviceuuid::t_uuid,    :ingoogleanalyticsaccountuuid::t_uuid,    :instatus::t_uuid  ) ";
        for (int i = 0; i < assignmentList.size(); ++i) {
            WebsiteGoogleAnalyticsAccountAssignment assignment = assignmentList.get(i);
            MapSqlParameterSource parameters = new MapSqlParameterSource();
            parameters.addValue("insessiontoken", (Object)token.getid_token());
            parameters.addValue("indeviceuuid", (Object)assignment.getDeviceuuid());
            parameters.addValue("ingoogleanalyticsaccountuuid", (Object)assignment.getGoogleanalyticsaccount().getGoogleanalyticsaccountuuid());
            parameters.addValue("instatus", (Object)assignment.getStatus());
            JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        }
    }

    @Override
    public String getWebsiteInitData(UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson as json FROM proc_view_website_config(    :indeviceuuid::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("indeviceuuid", (Object)uuid.toString());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public Website getWebsiteByUUID(Token token, UUID uuid) {
        String str = this.getWebsiteString(token, uuid);
        Website website = PostgresqlJson.jsonToWebsite((String)str);
        return website;
    }

    @Override
    public String getWebsiteString(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson as json FROM proc_view_website(    :token::t_pgpmessage,    :indeviceuuid::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("indeviceuuid", (Object)uuid.toString());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getConfig(UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson as json FROM proc_view_website_config(    :indeviceuuid::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("indeviceuuid", (Object)uuid.toString());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }
}

