/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.CompetitionDAO;
import net.blugrid.core.model.Competition;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.Token;
import net.blugrid.core.utils.PostgresqlJson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CompetitionDAOImpl
implements CompetitionDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public Competition post(Token Token2, Competition comp) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT c.outcompetitionuuid AS competitionuuid FROM proc_post_competition (  :sessiontoken::t_pgpmessage,  :competitionuuid::t_uuid,  :competitionname::t_name,  :competitiondescription::t_descriptionnarrative,  :effectivedate::t_datecalendar,  :expirationdate::t_datecalendar,  :maxentrants::t_quantitytransactioncount,  :entrants::t_quantitytransactioncount,  :availableentrants::t_quantitytransactioncount) c ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        String emptystr = "";
        parameters.addValue("sessiontoken", (Object)Token2.getid_token());
        parameters.addValue("competitionuuid", (Object)comp.getCompetitionuuid());
        parameters.addValue("competitionname", (Object)comp.getCompetitionname());
        parameters.addValue("competitiondescription", (Object)comp.getCompetitiondescription());
        parameters.addValue("effectivedate", (Object)comp.getEffectivedate());
        parameters.addValue("expirationdate", (Object)comp.getExpirationdate());
        parameters.addValue("maxentrants", (Object)comp.getMaxentrants());
        parameters.addValue("entrants", (Object)comp.getEntrants());
        parameters.addValue("availableentrants", (Object)comp.getAvailableentrants());
        Competition newcomp = (Competition)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(Competition.class));
        comp.setCompetitionuuid(newcomp.getCompetitionuuid());
        return comp;
    }

    @Override
    public List<Competition> getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson from proc_view_competition(:token::t_pgpmessage,   :competitionuuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("competitionuuid", (Object)uuid);
        List jsondata = namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new RowMapper<JsonData>(){

            public JsonData mapRow(ResultSet rs, int rowNum) throws SQLException {
                JsonData json = new JsonData();
                json.setJson(rs.getString("outjson"));
                return json;
            }
        });
        List complist = PostgresqlJson.jsonListToCompetitionList((List)jsondata);
        return complist;
    }

    @Override
    public List<Competition> getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson from proc_view_competition(   :token::t_pgpmessage,   NULL::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        List jsondata = namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new RowMapper<JsonData>(){

            public JsonData mapRow(ResultSet rs, int rowNum) throws SQLException {
                JsonData json = new JsonData();
                json.setJson(rs.getString("outjson"));
                return json;
            }
        });
        List complist = PostgresqlJson.jsonListToCompetitionList((List)jsondata);
        return complist;
    }
}

