/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.BrandDAO;
import net.blugrid.core.model.Brand;
import net.blugrid.core.model.BrandResponse;
import net.blugrid.core.model.ColorPurpose;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.Token;
import net.blugrid.core.utils.PostgresqlJson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class BrandDAOImpl
implements BrandDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_brand(    :token::t_pgpmessage,    NULL::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_brand(    :token::t_pgpmessage,    :inbranduuid::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("inbranduuid", (Object)uuid.toString());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getAllWebsiteBrands(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_website_brand(    :token::t_pgpmessage,    :inbranduuid::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("inbranduuid", null);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getWebsiteBrandByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_website_brand(    :token::t_pgpmessage,    :inbranduuid::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("inbranduuid", null);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public BrandResponse post(Token token, Brand brand) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_post_brand(    :token::t_pgpmessage,    :inbranduuid::t_uuid,   :inbrandname::t_name,    :indescription::t_descriptionshort,    :inownerpartyuuid::t_uuid,   :instatus::t_status  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        if (brand.getBranduuid() != null) {
            parameters.addValue("inbranduuid", (Object)brand.getBranduuid());
        } else {
            parameters.addValue("inbranduuid", null);
        }
        parameters.addValue("inbrandname", (Object)brand.getBrandname());
        parameters.addValue("indescription", (Object)brand.getDescription());
        parameters.addValue("inownerpartyuuid", null);
        parameters.addValue("instatus", (Object)brand.getStatus());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        BrandResponse response = PostgresqlJson.jsonToBrandResponse((JsonData)json);
        if (response.getStatus().equalsIgnoreCase("OK")) {
            brand.setBranduuid(response.getBrand().getBranduuid());
            if (brand.getColorpurposes() != null) {
                sql = "SELECT outjson AS json from proc_post_brandcolorpurpose(    :token::t_pgpmessage,    :inbranduuid::t_uuid,   :incolorpaletteuuid::t_uuid,    :inhex::t_hexint,    :incolorpurposeid::t_identity,   :instatus::t_status  ) ";
                for (int i = 0; i < brand.getColorpurposes().size(); ++i) {
                    ColorPurpose colorp = (ColorPurpose)brand.getColorpurposes().get(i);
                    if (colorp.getColor() == null) continue;
                    MapSqlParameterSource cparameters = new MapSqlParameterSource();
                    cparameters.addValue("token", (Object)token.getid_token());
                    cparameters.addValue("inbranduuid", (Object)brand.getBranduuid());
                    cparameters.addValue("incolorpaletteuuid", (Object)brand.getColorpalette().getColorpaletteuuid());
                    cparameters.addValue("inhex", (Object)colorp.getColor().getHex());
                    cparameters.addValue("incolorpurposeid", (Object)colorp.getColorpurposeid());
                    cparameters.addValue("instatus", (Object)colorp.getStatus());
                    JsonData cpjson = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)cparameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
                }
            }
        }
        return response;
    }
}

