/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.util.ArrayList;
import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.AudienceDAO;
import net.blugrid.core.model.Audience;
import net.blugrid.core.model.AudienceResponse;
import net.blugrid.core.model.AudienceSelector;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.Token;
import net.blugrid.core.utils.PostgresqlJson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AudienceDAOImpl
implements AudienceDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_audience(    :token::t_pgpmessage,    NULL::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_audience(    :token::t_pgpmessage,    :inaudienceuuid::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("inaudienceuuid", (Object)uuid.toString());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public AudienceResponse post(Token token, Audience audience) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_post_audience(    :token::t_pgpmessage,    :inaudienceuuid::t_uuid,   :inaudiencename::t_name,    :instatus::t_status  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        if (audience.getAudienceuuid() != null) {
            parameters.addValue("inaudienceuuid", (Object)audience.getAudienceuuid());
        } else {
            parameters.addValue("inaudienceuuid", null);
        }
        parameters.addValue("inaudiencename", (Object)audience.getAudiencename());
        parameters.addValue("instatus", (Object)audience.getStatus());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        AudienceResponse response = PostgresqlJson.jsonToAudienceResponse((JsonData)json);
        if (response.getStatus().equalsIgnoreCase("OK")) {
            ArrayList newlocationselectors = new ArrayList();
            for (int i = 0; i < audience.getAudienceselectors().size(); ++i) {
                sql = "SELECT outjson AS json from proc_post_audienceselector(    :token::t_pgpmessage,    :inaudienceuuid::t_uuid,   :inaudienceselectortype::t_audienceselectortype,    :inexcludeflag::t_flag,   :inselections::t_text,    :inudfselections::JSON,    :instatus::t_status  ) ";
                MapSqlParameterSource sparameters = new MapSqlParameterSource();
                sparameters.addValue("token", (Object)token.getid_token());
                sparameters.addValue("inaudienceuuid", (Object)response.getAudience().getAudienceuuid());
                sparameters.addValue("inaudienceselectortype", (Object)((AudienceSelector)audience.getAudienceselectors().get(i)).getAudienceselectortype());
                sparameters.addValue("inexcludeflag", (Object)((AudienceSelector)audience.getAudienceselectors().get(i)).getExcludeflag());
                sparameters.addValue("instatus", (Object)((AudienceSelector)audience.getAudienceselectors().get(i)).getStatus());
                sparameters.addValue("inudfselections", ((AudienceSelector)audience.getAudienceselectors().get(i)).getUdfselections());
                if (((AudienceSelector)audience.getAudienceselectors().get(i)).getSelections().size() > 0) {
                    ArrayList<String> clist = new ArrayList<String>();
                    for (int j = 0; j < ((AudienceSelector)audience.getAudienceselectors().get(i)).getSelections().size(); ++j) {
                        String cname = ((String)((AudienceSelector)audience.getAudienceselectors().get(i)).getSelections().get(j)).toString();
                        clist.add(cname);
                    }
                    String str = ((Object)clist).toString();
                    str = str.replace("[", "{");
                    str = str.replace("]", "}");
                    sparameters.addValue("inselections", (Object)str);
                } else {
                    sparameters.addValue("inselections", null);
                }
                json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)sparameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
                newlocationselectors.add(audience.getAudienceselectors().get(i));
            }
            response.getAudience().setAudienceselectors(newlocationselectors);
        }
        return response;
    }
}

