/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import com.google.gson.GsonBuilder;
import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.TransactionDAO;
import net.blugrid.core.model.CreditDebitCardTenderLineItem;
import net.blugrid.core.model.CreditDebitTenderLineItemResponse;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.PaymentAuthorization;
import net.blugrid.core.model.PaymentAuthorizationResponse;
import net.blugrid.core.model.Response;
import net.blugrid.core.model.RetailTransaction;
import net.blugrid.core.model.RetailTransactionResponse;
import net.blugrid.core.model.SaleReturnLineItem;
import net.blugrid.core.model.Token;
import net.blugrid.service.TransactionService;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class TransactionDAOImpl
implements TransactionDAO {
    private static final Logger logger = Logger.getLogger(TransactionDAOImpl.class);
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;
    @Autowired
    private TransactionService Transactionservice;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAll(Token token, Boolean lastonly) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_transaction(    :token::t_pgpmessage,    NULL::t_uuid,    NULL::t_identity,    NULL::t_identity,    :inlastonly::t_flag  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("inlastonly", (Object)lastonly);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public RetailTransaction getByUUID(Token token, UUID uuid) {
        String str = this.getByUUIDString(token, uuid);
        RetailTransaction response = (RetailTransaction)new GsonBuilder().create().fromJson(str, RetailTransaction.class);
        return response;
    }

    @Override
    public String getByUUIDString(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_transaction(    :token::t_pgpmessage,    :intransactionuuid::t_uuid,    NULL::t_identity,    NULL::t_identity  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("intransactionuuid", (Object)uuid.toString());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String initRetailTransaction(Token token, RetailTransaction transaction) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_init_retailtransaction (  :insessiontoken::t_pgpmessage,  :inbusinessunituuid::t_uuid,  :inbegindatetimestamp::t_timestamp,  :inenddatetimestamp::t_timestamp,  :incancelledflag::t_flag,  :invoidedflag::t_flag,  :intrainingflag::t_flag,  :inkeyedofflineflag::t_flag,  :insuspendedflag::t_flag,  :incustomerpartyuuid::t_uuid,  :incustomerorderuuid::t_uuid  )";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("insessiontoken", (Object)token.getid_token());
        if (transaction.getBusinessunit() != null) {
            parameters.addValue("inbusinessunituuid", (Object)transaction.getBusinessunit().getBusinessunituuid());
        } else {
            parameters.addValue("inbusinessunituuid", null);
        }
        parameters.addValue("inbegindatetimestamp", (Object)transaction.getBegindatetimestamp());
        parameters.addValue("inenddatetimestamp", (Object)transaction.getEnddatetimestamp());
        parameters.addValue("incancelledflag", (Object)transaction.getCancelledflag());
        parameters.addValue("invoidedflag", (Object)transaction.getVoidedflag());
        parameters.addValue("intrainingflag", (Object)transaction.getTrainingflag());
        parameters.addValue("inkeyedofflineflag", (Object)transaction.getKeyedofflineflag());
        parameters.addValue("insuspendedflag", (Object)transaction.getSuspendedflag());
        if (transaction.getCustomer() != null) {
            parameters.addValue("incustomerpartyuuid", (Object)transaction.getCustomer().getPartyuuid());
        } else {
            parameters.addValue("incustomerpartyuuid", null);
        }
        parameters.addValue("incustomerorderuuid", null);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String postSaleReturnLineItem(Token token, SaleReturnLineItem lineitem) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_post_salereturnlineitem (  :insessiontoken::t_pgpmessage,  :intransactionuuid::t_uuid,  :inlineitemnumber::t_linenumber,  :inlineitemgroupid::t_linenumber,  :incustomerorderuuid::t_uuid,  :incustomerordersequencenumber::t_linenumber,  :inbegindatetimestamp::t_timestamp,  :inenddatetimestamp::t_timestamp,  :invoidflag::t_flag,  :insalereturnlineitemtype::t_salereturnlineitemtype,  :initemuuid::t_uuid,  :intaxrulecode::t_code,  :inregularunitprice::t_money,  :inactualunitprice::t_money,  :inquantity::t_quantity,  :ingrosssalesamount::t_money,  :inextendedamount::t_money,  :inextendedtaxamount::t_float  )";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("insessiontoken", (Object)token.getid_token());
        if (lineitem.getTransactionuuid() != null) {
            parameters.addValue("intransactionuuid", (Object)lineitem.getTransactionuuid());
            parameters.addValue("inlineitemnumber", (Object)lineitem.getLineitemnumber());
            parameters.addValue("inlineitemgroupid", null);
            if (lineitem.getCustomerorderlineitem() != null) {
                parameters.addValue("incustomerorderuuid", (Object)lineitem.getCustomerorderlineitem().getCustomerorderuuid());
                parameters.addValue("incustomerordersequencenumber", (Object)lineitem.getCustomerorderlineitem().getCustomerordersequencenumber());
            } else {
                parameters.addValue("incustomerorderuuid", null);
                parameters.addValue("incustomerordersequencenumber", null);
            }
            parameters.addValue("inbegindatetimestamp", (Object)lineitem.getBegindatetimestamp());
            parameters.addValue("inenddatetimestamp", (Object)lineitem.getEnddatetimestamp());
            parameters.addValue("invoidflag", (Object)lineitem.getVoidflag());
            parameters.addValue("insalereturnlineitemtype", (Object)lineitem.getSalereturnlineitemtype());
            if (lineitem.getItem() != null) {
                parameters.addValue("initemuuid", (Object)lineitem.getItem().getItemuuid());
            } else {
                parameters.addValue("initemuuid", null);
            }
        } else {
            Response error = new Response();
            error.setStatus("ERROR");
            error.setMessage("Missing or Invalid Transaction UUID");
            return error.toString();
        }
        parameters.addValue("intaxrulecode", (Object)lineitem.getTaxrulecode());
        parameters.addValue("inregularunitprice", (Object)lineitem.getRegularunitprice());
        parameters.addValue("inactualunitprice", (Object)lineitem.getActualunitprice());
        parameters.addValue("inquantity", (Object)lineitem.getQuantity());
        parameters.addValue("ingrosssalesamount", (Object)lineitem.getGrosssalesamount());
        parameters.addValue("inextendedamount", (Object)lineitem.getExtendedamount());
        parameters.addValue("inextendedtaxamount", (Object)lineitem.getExtendedtaxamount());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public CreditDebitTenderLineItemResponse postCreditDebitTenderLineItem(Token token, CreditDebitCardTenderLineItem lineitem) {
        CreditDebitTenderLineItemResponse response = new CreditDebitTenderLineItemResponse();
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_post_creditdebittenderlineitem (  :insessiontoken::t_pgpmessage,  :intransactionuuid::t_uuid,  :inlineitemnumber::t_linenumber,  :inlineitemgroupid::t_linenumber,  :incustomerorderuuid::t_uuid,  :incustomerordersequencenumber::t_linenumber,  :inbegindatetimestamp::t_timestamp,  :inenddatetimestamp::t_timestamp,  :invoidflag::t_flag,  :intendertype::t_tendertype,  :intenderuuid::t_uuid,   :intenderamount::t_money,  :incashbackamount::t_money,  :tipamount::t_money,  :inamount::t_money,  :increditdebitcardtype::t_creditdebitcardtype,  :insuccessflag::t_flag,  :incvccheckflag::t_flag,  :inexpirymonth::t_datecalendarmonth,  :inexpiryyear::t_datecalendaryear,  :incardlast4digits::t_Code4  )";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("insessiontoken", (Object)token.getid_token());
        if (lineitem.getTransactionuuid() == null) {
            response.setStatus("ERROR");
            response.setMessage("Missing or Invalid Transaction UUID");
            return response;
        }
        parameters.addValue("intransactionuuid", (Object)lineitem.getTransactionuuid());
        parameters.addValue("inlineitemnumber", (Object)lineitem.getLineitemnumber());
        parameters.addValue("inlineitemgroupid", null);
        if (lineitem.getCustomerorderlineitem() != null) {
            parameters.addValue("incustomerorderuuid", (Object)lineitem.getCustomerorderlineitem().getCustomerorderuuid());
            parameters.addValue("incustomerordersequencenumber", (Object)lineitem.getCustomerorderlineitem().getCustomerordersequencenumber());
        } else {
            parameters.addValue("incustomerorderuuid", null);
            parameters.addValue("incustomerordersequencenumber", null);
        }
        parameters.addValue("inbegindatetimestamp", (Object)lineitem.getBegindatetimestamp());
        parameters.addValue("inenddatetimestamp", (Object)lineitem.getEnddatetimestamp());
        parameters.addValue("invoidflag", (Object)lineitem.getVoidflag());
        parameters.addValue("intendertype", (Object)lineitem.getTendertype());
        parameters.addValue("intenderuuid", (Object)lineitem.getTender().getTenderuuid());
        parameters.addValue("intenderamount", (Object)lineitem.getTenderamount());
        parameters.addValue("incashbackamount", (Object)lineitem.getCashbackamount());
        parameters.addValue("tipamount", (Object)lineitem.getTipamount());
        parameters.addValue("inamount", (Object)lineitem.getAmount());
        parameters.addValue("insuccessflag", (Object)lineitem.getSuccessFlag());
        if (lineitem.getCreditdebitcard() != null) {
            parameters.addValue("increditdebitcardtype", (Object)lineitem.getCreditdebitcard().getCreditcardtype());
            parameters.addValue("incvccheckflag", (Object)lineitem.getCreditdebitcard().getCvcCheckFlag());
            parameters.addValue("inexpirymonth", (Object)lineitem.getCreditdebitcard().getExpirymonth());
            parameters.addValue("inexpiryyear", (Object)lineitem.getCreditdebitcard().getExpiryyear());
            parameters.addValue("incardlast4digits", (Object)lineitem.getCreditdebitcard().getCardlast4digits());
        } else {
            parameters.addValue("increditdebitcardtype", null);
            parameters.addValue("incvccheckflag", null);
            parameters.addValue("inexpirymonth", null);
            parameters.addValue("inexpiryyear", null);
            parameters.addValue("incardlast4digits", null);
        }
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        response = (CreditDebitTenderLineItemResponse)new GsonBuilder().create().fromJson(json.getJson(), CreditDebitTenderLineItemResponse.class);
        return response;
    }

    @Override
    public PaymentAuthorizationResponse postPaymentAuthorization(Token token, PaymentAuthorization paymentauth) {
        PaymentAuthorizationResponse response = new PaymentAuthorizationResponse();
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_post_paymentauthorization (  :insessiontoken::t_pgpmessage,  :intransactionuuid::t_uuid,  :inlineitemnumber::t_linenumber,  :inpaymentauthorizationsequencenumber::t_linenumber,  :inpaymentprocessoraccountuuid::t_uuid,  :inrequestedamount::t_money,  :intoken::t_codelong,  :increatedtimestamp::t_timestamp,  :inamountcharged::t_money,  :inamountrefunded::t_money,  :incaptured::t_flag,  :incurrencycode::t_code,  :indescription::t_description,  :insuccessflag::t_flag,  :inresponsedata::json  )";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("insessiontoken", (Object)token.getid_token());
        if (paymentauth.getTransactionuuid() == null) {
            response.setStatus("ERROR");
            response.setMessage("Missing or Invalid Transaction UUID");
            return response;
        }
        parameters.addValue("intransactionuuid", (Object)paymentauth.getTransactionuuid());
        parameters.addValue("inlineitemnumber", (Object)paymentauth.getLinenumber());
        parameters.addValue("inpaymentauthorizationsequencenumber", (Object)paymentauth.getPaymentauthorizationsequencenumber());
        if (paymentauth.getPaymentprocessoraccount() != null) {
            parameters.addValue("inpaymentprocessoraccountuuid", (Object)paymentauth.getPaymentprocessoraccount().getPaymentprocessoraccountuuid());
        } else {
            parameters.addValue("inpaymentprocessoraccountuuid", null);
        }
        parameters.addValue("inrequestedamount", (Object)paymentauth.getRequestedamount());
        parameters.addValue("intoken", (Object)paymentauth.getToken());
        parameters.addValue("increatedtimestamp", (Object)paymentauth.getCreatedtimestamp());
        parameters.addValue("inamountcharged", (Object)paymentauth.getAmountcharged());
        parameters.addValue("inamountrefunded", (Object)paymentauth.getAmountrefunded());
        parameters.addValue("incaptured", (Object)paymentauth.getCaptured());
        parameters.addValue("incurrencycode", null);
        parameters.addValue("indescription", (Object)paymentauth.getDescription());
        parameters.addValue("insuccessflag", (Object)paymentauth.getSuccessflag());
        parameters.addValue("inresponsedata", paymentauth.getResponsedata());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        response = (PaymentAuthorizationResponse)new GsonBuilder().create().fromJson(json.getJson(), PaymentAuthorizationResponse.class);
        return response;
    }

    @Override
    public RetailTransactionResponse closeRetailTransaction(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_close_retailtransaction (  :insessiontoken::t_pgpmessage,  :intransactionuuid::t_uuid )";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("insessiontoken", (Object)token.getid_token());
        parameters.addValue("intransactionuuid", (Object)uuid);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        RetailTransactionResponse response = (RetailTransactionResponse)new GsonBuilder().create().fromJson(json.getJson(), RetailTransactionResponse.class);
        if (response.getStatus().equalsIgnoreCase("OK")) {
            this.Transactionservice.afterCloseRetailTransaction(token, response.getRetailtransaction());
        }
        return response;
    }
}

