/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.SocialShareDAO;
import net.blugrid.core.dao.WebContentDAO;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.ObjectResponse;
import net.blugrid.core.model.SocialShare;
import net.blugrid.core.model.Token;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class SocialShareDAOImpl
implements SocialShareDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;
    @Autowired
    private WebContentDAO Webcontentdao;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_socialshare(   :token::t_pgpmessage,   NULL::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_socialshare(   :token::t_pgpmessage,   :uuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("uuid", (Object)uuid);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public ObjectResponse<SocialShare> post(Token token, SocialShare socialshare) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json  FROM proc_post_socialshare(   :token::t_pgpmessage,   :insocialshareuuid::t_uuid,   :inlongurl::t_urladdress,   :insocialmedianetwork::t_socialmedianetwork,   :inpartyuuid::t_uuid,   :inwebpageuuid::t_uuid,   :instatus::t_status ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("insocialshareuuid", (Object)socialshare.getSocialshareuuid());
        parameters.addValue("inlongurl", (Object)socialshare.getLongurl());
        parameters.addValue("insocialmedianetwork", (Object)socialshare.getSocialmedianetwork());
        parameters.addValue("inpartyuuid", (Object)socialshare.getPartyuuid());
        parameters.addValue("inwebpageuuid", (Object)socialshare.getWebpageuuid());
        parameters.addValue("instatus", (Object)socialshare.getStatus());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        Type type = new TypeToken<ObjectResponse<SocialShare>>(){}.getType();
        ObjectResponse response = (ObjectResponse)new Gson().fromJson(json.getJson(), type);
        return response;
    }
}

