/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.util.List;
import javax.sql.DataSource;
import net.blugrid.core.dao.ScheduledTaskDAO;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.ScheduledTask;
import net.blugrid.core.model.Token;
import net.blugrid.core.utils.PostgresqlJson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ScheduledTaskDAOImpl
implements ScheduledTaskDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public List<ScheduledTask> getAllPending() {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_lkp_pending_scheduledtask_list() ";
        JsonData json = (JsonData)jdbcTemplate.queryForObject(sql, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        List tasklist = PostgresqlJson.jsonListToScheduledTaskList((String)json.getJson());
        return tasklist;
    }

    @Override
    public String getAllString(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_task(    :token::t_pgpmessage,    NULL::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public List<ScheduledTask> getAll(Token token) {
        String json = this.getAllString(token);
        List tasklist = PostgresqlJson.jsonListToScheduledTaskList((String)json);
        return tasklist;
    }
}

