/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.ScheduleDAO;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.Schedule;
import net.blugrid.core.model.ScheduleResponse;
import net.blugrid.core.model.Token;
import net.blugrid.core.utils.PostgresqlJson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ScheduleDAOImpl
implements ScheduleDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAllString(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_schedule(    :token::t_pgpmessage,    NULL::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public List<Schedule> getAll(Token token) {
        String json = this.getAllString(token);
        List schedulelist = PostgresqlJson.jsonListToScheduleList((String)json);
        return schedulelist;
    }

    @Override
    public String getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_schedule(    :token::t_pgpmessage,    :inscheduleuuid::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("inscheduleuuid", (Object)uuid.toString());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public ScheduleResponse post(Token token, Schedule schedule) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_post_schedule(    :token::t_pgpmessage,    :inscheduleuuid::t_uuid,   :inschedulename::t_name,    :inscheduletype::t_scheduletype,   :inminutes::t_text,   :inhours::t_text,   :indays::t_text,   :inweekdays::t_text,   :inmonths::t_text,   :inrunoncetimestamp::t_timestamp,   :infrequency::t_quantityshortcount,    :instatus::t_status  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        if (schedule.getScheduleuuid() != null) {
            parameters.addValue("inscheduleuuid", (Object)schedule.getScheduleuuid());
        } else {
            parameters.addValue("inscheduleuuid", null);
        }
        parameters.addValue("inschedulename", (Object)schedule.getSchedulename());
        parameters.addValue("inscheduletype", (Object)schedule.getScheduletype());
        parameters.addValue("inminutes", (Object)schedule.getMinutes());
        parameters.addValue("inhours", (Object)schedule.getHours());
        parameters.addValue("indays", (Object)schedule.getDays());
        parameters.addValue("inweekdays", (Object)schedule.getWeekdays());
        parameters.addValue("inmonths", (Object)schedule.getMinutes());
        parameters.addValue("inrunoncetimestamp", (Object)schedule.getRunoncetimestamp());
        parameters.addValue("infrequency", (Object)schedule.getFrequency());
        parameters.addValue("instatus", (Object)schedule.getStatus());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        ScheduleResponse response = PostgresqlJson.jsonToScheduleResponse((JsonData)json);
        return response;
    }
}

