/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import com.google.gson.GsonBuilder;
import javax.sql.DataSource;
import net.blugrid.core.dao.PaymentProcessorDAO;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.StripeAccount;
import net.blugrid.core.model.Token;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class PaymentProcessorDAOImpl
implements PaymentProcessorDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public StripeAccount postStripeAccount(Token token, StripeAccount stripeaccount) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_post_paymentprocessoraccount(    :token::t_pgpmessage,    :inpaymentprocessoraccountuuid::t_uuid,    :inpaymentprocessortype::t_paymentprocessortype,    :indescription::t_description,    :instatus::t_status,    :inaccountid::t_codelong,    :inemail::t_emailaddress,    :inbusinessurl::t_urladdress,    :intestsecretkey::t_codelong,    :intestpublishablekey::t_codelong,    :inlivesecretkey::t_codelong,    :inlivepublishablekey::t_codelong,    :intenderuuid::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        if (stripeaccount.getPaymentprocessoraccountuuid() != null) {
            parameters.addValue("inpaymentprocessoraccountuuid", (Object)stripeaccount.getPaymentprocessoraccountuuid().toString());
        } else {
            parameters.addValue("inpaymentprocessoraccountuuid", null);
        }
        parameters.addValue("inpaymentprocessortype", (Object)stripeaccount.getPaymentprocessortype());
        parameters.addValue("indescription", (Object)stripeaccount.getDescription());
        parameters.addValue("instatus", (Object)stripeaccount.getStatus());
        parameters.addValue("inaccountid", (Object)stripeaccount.getAccount().getId());
        parameters.addValue("inemail", (Object)stripeaccount.getAccount().getEmail());
        parameters.addValue("inbusinessurl", (Object)stripeaccount.getAccount().getBusinessUrl());
        parameters.addValue("intestsecretkey", (Object)stripeaccount.getAccount().getKeys().getSecret());
        parameters.addValue("intestpublishablekey", (Object)stripeaccount.getAccount().getKeys().getPublishable());
        parameters.addValue("inlivesecretkey", (Object)stripeaccount.getAccount().getKeys().getSecret());
        parameters.addValue("inlivepublishablekey", (Object)stripeaccount.getAccount().getKeys().getPublishable());
        parameters.addValue("intenderuuid", null);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        StripeAccount response = (StripeAccount)new GsonBuilder().create().fromJson(json.getJson(), StripeAccount.class);
        return response;
    }
}

