/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import com.google.gson.GsonBuilder;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.AddressDAO;
import net.blugrid.core.dao.CustomerReviewDAO;
import net.blugrid.core.dao.EmailAddressDAO;
import net.blugrid.core.dao.PartyDAO;
import net.blugrid.core.dao.TelephoneDAO;
import net.blugrid.core.model.Address;
import net.blugrid.core.model.CustomerReview;
import net.blugrid.core.model.EmailAddress;
import net.blugrid.core.model.Hashtag;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.Party;
import net.blugrid.core.model.PartyFilter;
import net.blugrid.core.model.PartyResponse;
import net.blugrid.core.model.PartyRoleAssignment;
import net.blugrid.core.model.Response;
import net.blugrid.core.model.Telephone;
import net.blugrid.core.model.Token;
import net.blugrid.core.utils.PostgresqlJson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class PartyDAOImpl
implements PartyDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;
    @Autowired
    private AddressDAO Addressdao;
    @Autowired
    private EmailAddressDAO EmailAddressdao;
    @Autowired
    private TelephoneDAO Telephonedao;
    @Autowired
    private CustomerReviewDAO CustomerReviewdao;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_party(:token::t_pgpmessage,   NULL::t_uuid,   NULL::json,   NULL::t_uuid,   NULL::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByFilter(Token token, PartyFilter filter, Boolean getdataflag) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_vw_party_filter(:token::t_pgpmessage,   :ingetdataflag::t_flag,   :ingenderlist::TEXT[],   :inminage::TEXT[],   :inmaxage::TEXT[],   :inhashtaglist::TEXT[],   :inmaritalstatuslist::TEXT[],   :inoccupationlist::TEXT[],   :inemploymentstatuslist::TEXT[],   :inreligionlist::TEXT[],   :ineducationlevellist::TEXT[],   :inpersonudfselections::json,   :incountrylist::TEXT[],   :instatelist::TEXT[],   :incitylist::TEXT[]  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("ingetdataflag", (Object)getdataflag);
        parameters.addValue("ingenderlist", (Object)PostgresqlJson.StringListToArray((List)filter.getAudienceSelectorByType("Gender").getSelections()));
        parameters.addValue("inminage", (Object)PostgresqlJson.StringListToArray((List)filter.getAudienceSelectorByType("MinAge").getSelections()));
        parameters.addValue("inmaxage", (Object)PostgresqlJson.StringListToArray((List)filter.getAudienceSelectorByType("MaxAge").getSelections()));
        parameters.addValue("inhashtaglist", (Object)PostgresqlJson.StringListToArray((List)filter.getAudienceSelectorByType("Hashtag").getSelections()));
        parameters.addValue("inmaritalstatuslist", (Object)PostgresqlJson.StringListToArray((List)filter.getAudienceSelectorByType("MaritalStatus").getSelections()));
        parameters.addValue("inoccupationlist", (Object)PostgresqlJson.StringListToArray((List)filter.getAudienceSelectorByType("Occupation").getSelections()));
        parameters.addValue("inemploymentstatuslist", (Object)PostgresqlJson.StringListToArray((List)filter.getAudienceSelectorByType("EmploymentStatus").getSelections()));
        parameters.addValue("inreligionlist", (Object)PostgresqlJson.StringListToArray((List)filter.getAudienceSelectorByType("Religon").getSelections()));
        parameters.addValue("ineducationlevellist", (Object)PostgresqlJson.StringListToArray((List)filter.getAudienceSelectorByType("EducationLevel").getSelections()));
        parameters.addValue("inpersonudfselections", filter.getAudienceSelectorByType("PersonUdf").getUdfselections());
        parameters.addValue("incountrylist", (Object)PostgresqlJson.StringListToArray((List)filter.getTargetLocationSelectorByType("Country").getSelections()));
        parameters.addValue("instatelist", (Object)PostgresqlJson.StringListToArray((List)filter.getTargetLocationSelectorByType("State").getSelections()));
        parameters.addValue("incitylist", (Object)PostgresqlJson.StringListToArray((List)filter.getTargetLocationSelectorByType("City").getSelections()));
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByFilterOld(Token token, String partyrolelist) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_party(:token::t_pgpmessage,   NULL::t_uuid,   :rolelist::json,   NULL::t_uuid,   NULL::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("rolelist", (Object)partyrolelist);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getPartynameCheck(Token token, String partyname) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_partyname_check(   :token::t_pgpmessage,   :inpartyname::t_name  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("inpartyname", (Object)partyname);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_party(:token::t_pgpmessage,   :partyuuid::t_uuid,   NULL::json,   NULL::t_uuid,   NULL::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("partyuuid", (Object)uuid);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByActivityStream(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_party_activity_stream(:token::t_pgpmessage,   :partyuuid::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("partyuuid", (Object)uuid);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByEvent(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_party(:token::t_pgpmessage,   NULL::t_uuid,   NULL::json,   :eventuuid::t_uuid,   NULL::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("eventuuid", (Object)uuid);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByCompetition(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_party(:token::t_pgpmessage,   NULL::t_uuid,   NULL::json,   NULL::t_uuid,   :compeitionuuid::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("compeitionuuid", (Object)uuid);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public PartyResponse post(Token Token2, Party party) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json FROM proc_post_party (  :clientuuid::t_uuid,  :sessiontoken::t_pgpmessage, :partyuuid::t_uuid,  :partyname::t_name, :optoutflag::t_flag,  :instatus::t_status,  :abn::t_descriptionshort, :salutation::t_name, :firstname::t_name, :middlenames::t_name, :lastname::t_name, :gendertype::t_code1, :birthyearnumber::t_datecalendaryear, :birthmonthnumber::t_datecalendarmonth, :birthdaynumber::t_datecalendarday, :country::t_name,  :language::t_name,  :occupation::t_name,  :educationlevel::t_name,  :maritalstatus::t_name,  :employmentstatus::t_name,  :religion::t_name,  :incompanyname::t_name,  :injobtitle::t_description,  :password::t_password,  :inhashtaglist::text[],  :udfmodeldata::t_json  )";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        String emptystr = "";
        parameters.addValue("clientuuid", (Object)party.getClientuuid());
        parameters.addValue("sessiontoken", (Object)Token2.getid_token());
        parameters.addValue("partyuuid", (Object)party.getPartyuuid());
        parameters.addValue("partyname", (Object)party.getPartyname());
        parameters.addValue("optoutflag", (Object)party.getOptoutflag());
        parameters.addValue("instatus", (Object)party.getStatus());
        parameters.addValue("abn", (Object)party.getOrganisation().getABN());
        parameters.addValue("salutation", (Object)party.getPerson().getSalutation());
        parameters.addValue("firstname", (Object)party.getPerson().getFirstname());
        parameters.addValue("middlenames", (Object)party.getPerson().getMiddlenames());
        parameters.addValue("lastname", (Object)party.getPerson().getLastname());
        parameters.addValue("gendertype", (Object)party.getPerson().getGendertype());
        parameters.addValue("birthdaynumber", (Object)party.getPerson().getBirthdaynumber());
        parameters.addValue("birthmonthnumber", (Object)party.getPerson().getBirthmonthnumber());
        parameters.addValue("birthyearnumber", (Object)party.getPerson().getBirthyearnumber());
        parameters.addValue("country", (Object)party.getPerson().getCountryname());
        parameters.addValue("language", (Object)party.getPerson().getLanguagename());
        parameters.addValue("occupation", (Object)party.getPerson().getOccupationname());
        parameters.addValue("educationlevel", (Object)party.getPerson().getEducationlevelname());
        parameters.addValue("maritalstatus", (Object)party.getPerson().getMaritalstatusname());
        parameters.addValue("employmentstatus", (Object)party.getPerson().getEmploymentstatusname());
        parameters.addValue("religion", (Object)party.getPerson().getReligionname());
        parameters.addValue("incompanyname", (Object)party.getPerson().getCompanyname());
        parameters.addValue("injobtitle", (Object)party.getPerson().getJobtitle());
        parameters.addValue("udfmodeldata", party.getPerson().getUdfmodeldata());
        parameters.addValue("password", (Object)party.getPassword());
        ArrayList<String> hashtaglist = new ArrayList<String>();
        for (int j = 0; j < party.getHashtags().size(); ++j) {
            String hashtag = ((Hashtag)party.getHashtags().get(j)).getHashtag();
            hashtaglist.add(hashtag);
        }
        String str = ((Object)hashtaglist).toString();
        str = str.replace("[", "{");
        str = str.replace("]", "}");
        parameters.addValue("inhashtaglist", (Object)str);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        PartyResponse response = (PartyResponse)new GsonBuilder().create().fromJson(json.getJson(), PartyResponse.class);
        if (response.getStatus().equalsIgnoreCase("OK")) {
            party.setPartyuuid(response.getParty().getPartyuuid());
            if (!party.getPartyroles().isEmpty()) {
                String rosql = "SELECT proc_post_party_role (   :sessiontoken::t_pgpmessage,   :partyuuid::t_uuid,   :partyroletypecode::t_partyroletype,  :effectivedate::t_datecalendar,  :expirationdate::t_datecalendar )";
                for (int i = 0; i < party.getPartyroles().size(); ++i) {
                    MapSqlParameterSource roparameters = new MapSqlParameterSource();
                    roparameters.addValue("sessiontoken", (Object)Token2.getid_token());
                    roparameters.addValue("partyuuid", (Object)party.getPartyuuid());
                    roparameters.addValue("partyroletypecode", (Object)((PartyRoleAssignment)party.getPartyroles().get(i)).getPartyroletypecode());
                    roparameters.addValue("effectivedate", (Object)((PartyRoleAssignment)party.getPartyroles().get(i)).getEffectivedate());
                    roparameters.addValue("expirationdate", (Object)((PartyRoleAssignment)party.getPartyroles().get(i)).getExpirationdate());
                    namedParameterJdbcTemplate.execute(rosql, (SqlParameterSource)roparameters, new PreparedStatementCallback(){

                        public Object doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                            return ps.execute();
                        }
                    });
                }
            }
            if (!party.getTelephone().isEmpty()) {
                for (int i = 0; i < party.getTelephone().size(); ++i) {
                    Telephone tel = this.Telephonedao.postPartyTelehone(Token2, (Telephone)party.getTelephone().get(i), party.getPartyuuid());
                    ((Telephone)party.getTelephone().get(i)).setTelephoneuuid(tel.getTelephoneuuid());
                }
            }
            if (!party.getEmailaddress().isEmpty()) {
                for (int i = 0; i < party.getEmailaddress().size(); ++i) {
                    EmailAddress em = this.EmailAddressdao.postPartyEmailAddress(Token2, (EmailAddress)party.getEmailaddress().get(i), party.getPartyuuid());
                    ((EmailAddress)party.getEmailaddress().get(i)).setEmailuuid(em.getEmailuuid());
                }
            }
            if (!party.getAddress().isEmpty()) {
                for (int i = 0; i < party.getAddress().size(); ++i) {
                    Address addr = this.Addressdao.postPartyAddress(Token2, (Address)party.getAddress().get(i), party.getPartyuuid());
                    ((Address)party.getAddress().get(i)).setAddressuuid(addr.getAddressuuid());
                }
            }
            if (party.getCustomer() != null && party.getCustomer().getCustomerreviews() != null) {
                List<CustomerReview> customerreviews = this.CustomerReviewdao.postCustomerReviewList(Token2, party.getCustomer().getCustomerreviews());
                party.getCustomer().setCustomerreviews(customerreviews);
            }
            response.setParty(party);
        }
        return response;
    }

    @Override
    public Response postFacebook(Token Token2, UUID partyuuid, String facebookdata) {
        Response response = new Response();
        response.setStatus("OK");
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String addrsql = "SELECT outstatus as status  FROM proc_post_party_facebook ( :sessiontoken::t_pgpmessage, :partyuuid::t_uuid,  :facebookdata::json )";
        MapSqlParameterSource aparameters = new MapSqlParameterSource();
        aparameters.addValue("sessiontoken", (Object)Token2.getid_token());
        aparameters.addValue("partyuuid", (Object)partyuuid);
        aparameters.addValue("facebookdata", (Object)facebookdata);
        response = (Response)namedParameterJdbcTemplate.queryForObject(addrsql, (SqlParameterSource)aparameters, (RowMapper)BeanPropertyRowMapper.newInstance(Response.class));
        return response;
    }

    @Override
    public Response postSurvey(Token Token2, UUID partyuuid, String surveydata) {
        Response response = new Response();
        response.setStatus("OK");
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String addrsql = "SELECT outstatus as status  FROM proc_post_party_survey ( :sessiontoken::t_pgpmessage, :partyuuid::t_uuid,  :surveydata::json )";
        MapSqlParameterSource aparameters = new MapSqlParameterSource();
        aparameters.addValue("sessiontoken", (Object)Token2.getid_token());
        aparameters.addValue("partyuuid", (Object)partyuuid);
        aparameters.addValue("surveydata", (Object)surveydata);
        response = (Response)namedParameterJdbcTemplate.queryForObject(addrsql, (SqlParameterSource)aparameters, (RowMapper)BeanPropertyRowMapper.newInstance(Response.class));
        return response;
    }
}

